package com.avaya.ipoffice.openapi.samples;

import java.io.StringReader;
import java.io.StringWriter;

import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

import com.avaya.ipoffice.openapi.samples.data.*;
import com.avaya.ipoffice.openapi.samples.data.Error;
import com.avaya.ipoffice.openapi.samples.data.EventType;

import javax.xml.transform.*;
import javax.xml.transform.stream.*;

public class LoginSample {

	public String clientSessionID = "";
	public String webSocketUrl;
	public String username;
	public String password;
	public String port;
	public String serverIP;
	public UserLoginResponse loginResponse;
	public String extension;
	public String xmlResponse;
	public static void main(String arg[]) {
	
	}
	
	public Response login(String username, String password, String serverIP, String port) {
		
		this.username = username;
		this.password = password;
		this.serverIP = serverIP;
		this.port = port;
		
		Client client = ClientBuilder.newClient();
		WebTarget webTarget = client.target("http://"+serverIP+":"+port+"/inyama/service").path("session");
		UserLoginRequest userLoginrequest = new UserLoginRequest();
		userLoginrequest.setUserName(username);
		userLoginrequest.setUserPassword(password);
		userLoginrequest.setApplicationName("app");
		LoginSubscriptionRequest subscription = new LoginSubscriptionRequest();
		subscription.setHttpMethod(HttpMethod.WEBSOCKET);
		subscription.getEventTypes().add(EventType.CALL_CONTROL_FEATURES_EVENTS);
		subscription.getEventTypes().add(EventType.SNAPSHOT_SERVICES_CALLBACK_EVENTS);
		subscription.getEventTypes().add(EventType.CALL_ASSOCIATED_FEATURES_EVENTS);
		subscription.getEventTypes().add(EventType.PHYSICAL_DEVICE_FEATURES_EVENTS);
		
		userLoginrequest.setLoginSubscriptionRequest(subscription);
	  
		Invocation.Builder invocationBuilder =	webTarget.request(MediaType.APPLICATION_XML);
		Entity<UserLoginRequest> entity = Entity.entity(userLoginrequest, MediaType.APPLICATION_XML);
		try
		{
			Response response = invocationBuilder.post(entity);
			Source xmlInput = new StreamSource(new StringReader(response.readEntity(String.class)));
	        StringWriter stringWriter = new StringWriter();
	        StreamResult xmlOutput = new StreamResult(stringWriter);
	        TransformerFactory transformerFactory = TransformerFactory.newInstance();
	        transformerFactory.setAttribute("indent-number", 10);
	        Transformer transformer = transformerFactory.newTransformer(); 
	        transformer.setOutputProperty(OutputKeys.INDENT, "yes");
	        transformer.transform(xmlInput, xmlOutput);
	        this.xmlResponse = xmlOutput.getWriter().toString();
			
	        invocationBuilder =	webTarget.request(MediaType.APPLICATION_XML);
	        response = invocationBuilder.post(entity);
			if (response.getStatus() == 200) {
				//this.responseString = (String)response.getEntity();
				this.loginResponse = response.readEntity(UserLoginResponse.class);
				this.clientSessionID = loginResponse.getClientSessionID();
				this.webSocketUrl = loginResponse.getWebSocketWsUrl();
				this.extension = loginResponse.getUserExtension();
			} else {
				Error error = response.readEntity(Error.class);
			}
			return response;
		}
		catch(Exception e)
		{
			System.out.println("Exception");
			return null;
		}
		
	}

}