package com.avaya.ipoffice.openapi.samples.data;

import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlType;

@XmlType(name = "EndPointType")
@XmlEnum
public enum EndPointType {

    @XmlEnumValue("FLARE")
    FLARE("FLARE"), 
    @XmlEnumValue("MOBILITY")
    MOBILITY("MOBILITY"),
    @XmlEnumValue("PRIMARY")
    PRIMARY("PRIMARY");
    
    
    private final String value;   
    
    EndPointType(String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    public static EndPointType fromValue(String v) {
        for (EndPointType c: EndPointType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

    


}
