package com.avaya.ipoffice.openapi.samples;

import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;


import com.avaya.ipoffice.openapi.samples.data.*;

public class VoiceMail {
	
	
	public LoginSample user1;
	
	public VoiceMail(String username, String password, String serverIP, String port)
	{
		this.user1 = new LoginSample();
		this.user1.login(username, password, serverIP, port);
	}
	
	public static void main(String arg[]) {
	
	}

	public Response getVoicemails()
	{
		String clientSessionId = this.user1.clientSessionID;
		DeviceID calledDirectoryNumber = new DeviceID();
		calledDirectoryNumber.setSwitchingSubDomainInformationElements("127.0.0.1".getBytes());
		calledDirectoryNumber.setValue(user1.extension);
		calledDirectoryNumber.setTypeOfNumber(TypeOfNumberEnum.DEVICE_NUMBER);
		AVMSnapshotVoiceMailbox avms = new AVMSnapshotVoiceMailbox();
		avms.setDevice(calledDirectoryNumber);
		
		Client client = ClientBuilder.newClient();
		WebTarget webTarget = client.target("http://"+this.user1.serverIP+":"+this.user1.port+"/inyama/service").path("voicemail/getMessages");
		Invocation.Builder invocationBuilder =	webTarget.request(MediaType.APPLICATION_XML).header("ClientSessionId", clientSessionId);
		Entity<AVMSnapshotVoiceMailbox> entity = Entity.entity(avms, MediaType.APPLICATION_XML);
		Response response = invocationBuilder.post(entity);
		
		return response;
		
	}
}
