package com.avaya.ipoffice.openapi.samples.data;

import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlType;

@XmlType(name = "anonymousEndPointType")
@XmlEnum
public enum AnonymousEndPointType {

	@XmlEnumValue("None")
	NONE("None"),
	@XmlEnumValue("External")
	 EXTERNAL("External"),
	@XmlEnumValue("Withheld")
	 WITHHELD("Withheld");
	private final String value;

	AnonymousEndPointType(String v) {
		value = v;
	}

	public String value() {
		return value;
	}

	public static AnonymousEndPointType fromValue(String v) {
		for (AnonymousEndPointType c: AnonymousEndPointType.values()) {
			if (c.value.equals(v)) {
				return c;
			}
		}
		throw new IllegalArgumentException(v);
	}
}
