package com.avaya.ipoffice.openapi.samples.javafx;

import javafx.event.EventHandler;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.TextField;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Pane;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;
import javafx.scene.control.Alert.AlertType;

public class ShowCallSnapshotScreen{
	
	 String name;
	 String password;
	 String serverIP;
	 String port;
	 Stage primaryStage;
	
	 public  void setParameters(String username, String password, String serverIP, String port) 
	{
		this.name = username;
		this.password = password;
		this.serverIP = serverIP;
		this.port = port;
	
		/*
		 * Since this is a sample app, GUI elements are extracted from Primarystage
		 * by Hardcode indexes. But all the GUI elements can be obtained from
		 * Primarystage by getting their ID's.
		 */
		
		Pane pane = (Pane)this.primaryStage.getScene().rootProperty().get().getChildrenUnmodifiable().get(0);
		GridPane grid = (GridPane)pane.getChildren().get(0);
		TextField serverIPText = (TextField)grid.getChildren().get(1);
		TextField portText = (TextField)grid.getChildren().get(5);
		TextField usernameText = (TextField)grid.getChildren().get(3);
		TextField passwordText = (TextField)grid.getChildren().get(7);
		
		serverIPText.setText(serverIP);
		usernameText.setText(username);
		passwordText.setText(password);
		portText.setText(port);
	
		usernameText.setEditable(false);
		passwordText.setEditable(false);
		serverIPText.setEditable(false);
		portText.setEditable(false);
		
		Pane makecallPane = (Pane)this.primaryStage.getScene().rootProperty().get().getChildrenUnmodifiable().get(2);
		TextField dialedNUmber = (TextField)makecallPane.getChildren().get(0);
		Button makecallButton = (Button)makecallPane.getChildren().get(1);
		
		dialedNUmber.setVisible(false);
		makecallButton.setVisible(false);
	}

	public void start() 
	{
		try 
		{
			this.primaryStage = new Stage();
			Parent root = FXMLLoader.load(getClass().getResource("/callsnapshotSample.fxml"));
			Scene scene = new Scene(root);
			this.primaryStage.setScene(scene);
			this.primaryStage.initModality(Modality.APPLICATION_MODAL);
			this.primaryStage.setResizable(false);
			this.primaryStage.show();
			this.primaryStage.setOnCloseRequest(new EventHandler<WindowEvent>() {
					@Override
					public void handle(WindowEvent event) {
						Alert alert = new Alert(AlertType.WARNING);
						alert.setTitle("Warning Dialog");
						alert.setHeaderText("Warning:");
						alert.setContentText("Please Click On Logout Button To Close the Window!!!");
						alert.show();
						event.consume();
					}
				});
			
		} 
		catch(Exception e) 
		{
			e.printStackTrace();
		}
	}
	public void mymain() 
	{
		start();
	}	
}