package com.avaya.ipoffice.openapi.samples.javafx;

import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.transform.TransformerException;

import com.avaya.ipoffice.openapi.samples.CallLogSample;
import com.avaya.ipoffice.openapi.samples.data.*;

import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.AnchorPane;
import javafx.stage.Stage;

public class controllerCallLogs {
	
	@FXML TextField usernameTextCallLogs;
	@FXML TextField passwordTextCallLogs;
	@FXML TextField portTextCallLogs;
	@FXML TextField serverTextCallLogs;
	@FXML AnchorPane rootCalllogs;
	
	@FXML TableView<CallLogEntry> callLogs;
	@FXML TableColumn<CallLogEntry, String> callLogName;						
	@FXML TableColumn<CallLogEntry, String> callLogNumber;
	@FXML TableColumn<CallLogEntry, XMLGregorianCalendar> callLogDateTime;
	@FXML TableColumn<CallLogEntry, String> callLogDuration;
	
	@FXML TextArea xmlResponseCallLogs;
	
	public String name;
	public String password;
	public String serverIP;
	public String port;
	public String clientSessionId = "";
	
	public void mainCallLogs()
	{
		ObservableList<CallLogEntry> callLogsList = FXCollections.observableArrayList();
		
		this.name = usernameTextCallLogs.getText();	
		this.password = passwordTextCallLogs.getText();
		this.serverIP = serverTextCallLogs.getText();
		this.port = portTextCallLogs.getText();
		
		callLogName.setCellValueFactory(new PropertyValueFactory<CallLogEntry, String>("callingPartyName"));
		callLogNumber.setCellValueFactory(new PropertyValueFactory<CallLogEntry, String>("dialbackNumber"));
		callLogDateTime.setCellValueFactory(new PropertyValueFactory<CallLogEntry, XMLGregorianCalendar>("callTimestamp"));
		callLogDuration.setCellValueFactory(new PropertyValueFactory<CallLogEntry, String>("duration"));
		
		CallLogSample callLogSample = new CallLogSample(this.name, this.password, this.serverIP, this.port);
		this.clientSessionId = callLogSample.user1.clientSessionID;
		
		Response reponse = callLogSample.calllog();
		SendStoredCallLogResponse sendStoredCallLogResponse = callLogSample.sendStoredCallLogResponse;
		
		for(int i=1;i<sendStoredCallLogResponse.getReturn().size();i++){
			callLogsList.add(sendStoredCallLogResponse.getReturn().get(i));
		}
		callLogs.setItems(callLogsList);
		xmlResponseCallLogs.setWrapText(true);
		xmlResponseCallLogs.setStyle("-fx-text-fill: green;");
		xmlResponseCallLogs.setText(callLogSample.xmlResponse);
	}	
	
	public void closeCalllogs()
	{
		
		Stage stage = (Stage)rootCalllogs.getScene().getWindow();
		
		if(this.clientSessionId.equals(""))
			stage.close();
		else
		{
			Client client = ClientBuilder.newClient();
			WebTarget webTarget = client.target("http://"+serverIP+":"+port+"/inyama/service").path("session");
			Invocation.Builder invocationBuilder =	webTarget.request(MediaType.APPLICATION_XML).header("ClientSessionId", this.clientSessionId);
			Response response = invocationBuilder.delete();
			stage.close();
		}
	}
	
}
