package com.avaya.ipoffice.openapi.websocket;

import java.io.StringReader;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;

import com.avaya.ipoffice.openapi.websocket.WebSocketEventMessageListener;
import com.avaya.ipoffice.openapi.samples.data.*;
import com.avaya.ipoffice.openapi.samples.javafx.controllerCallSnapshot;
import com.avaya.ipoffice.openapi.samples.javafx.controllerVoiceMail;
public class WebSocketEventHandler {

	private JAXBContext ctx;
	public controllerVoiceMail cv;
	public controllerCallSnapshot ccs, cs;
	
	public WebSocketEventHandler(Object obj, String className)
	{
		cs = new controllerCallSnapshot();
		if(className.equals("controllerVoiceMail"))
			this.cv = (controllerVoiceMail)obj;
		
		else if(className.equals("controllerCallsnapshot"))
			this.ccs = (controllerCallSnapshot)obj;
	}
	public final WebSocketEventMessageListener listener = new WebSocketEventMessageListener() {
		@Override
		public void notifyEventMessageReceived(String message) throws JAXBException
		{
			ctx = JAXBContext.newInstance( 
					PresenceStates.class, 
					TelephonyPresenceEvent.class, 
					AVMSnapshotEvent.class, 
					//AVMNewMessageEvent.class,
					DeliveredEvent.class, 
					EstablishedEvent.class, 
					ConnectionClearedEvent.class,
					CallInformationEvent.class,
					HeldEvent.class,
					RetrievedEvent.class,
					CallLogEvent.class,
					Events.class);
			
			Events events = (Events)ctx.createUnmarshaller().unmarshal(new StringReader(message));
			Object event =events.getAny().get(0);
			if (event instanceof AVMSnapshotEvent) 
			{
				controllerVoiceMail cvtemp = new controllerVoiceMail();
				cvtemp.VoiceMailTable((AVMSnapshotEvent)event, cv);
				cvtemp.xmlVoicemails(message, cv);
			}
			else if (event instanceof EstablishedEvent || event instanceof DeliveredEvent || event instanceof ConnectionClearedEvent || event instanceof HeldEvent || event instanceof CallInformationEvent || event instanceof RetrievedEvent) 
			{
				cs.updateCallSnapshot(ccs, event);
				
			}
			
		}
	};
	
}
