package com.avaya.ipoffice.openapi.samples.javafx;

import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

import com.avaya.ipoffice.openapi.samples.data.*;
import com.avaya.ipoffice.openapi.samples.LoginSample;
import com.avaya.ipoffice.openapi.websocket.OpenApiJettyWebSocketClient;
import com.avaya.ipoffice.openapi.websocket.WebSocketEventHandler;

import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;

public class controllerCallSnapshot 
{
	@FXML TextField usernameTextCallSnapshot;
	@FXML TextField passwordTextCallSnapshot;
	@FXML TextField portTextCallSnapshot;
	@FXML TextField serverTextCallSnapshot;
	@FXML TextField dialedNumber;
	@FXML Button makecallButton;
	@FXML GridPane callsnapshotPane;
	@FXML AnchorPane rootCallSnapshot;
	
	@FXML Button close; 
	public String name;
	public String password;
	public String serverIP;
	public String port;
	public LoginSample user1;
	
	public void callsnapshot()
	{
		
		
			name = usernameTextCallSnapshot.getText();
			password = passwordTextCallSnapshot.getText();
			serverIP = serverTextCallSnapshot.getText();
			port = portTextCallSnapshot.getText();
			
			this.user1 = new LoginSample();
			this.user1.login(this.name, this.password, this.serverIP, this.port);
		
			Object obj = (Object)this;
			WebSocketEventHandler handler = new WebSocketEventHandler(obj, "controllerCallsnapshot");
			OpenApiJettyWebSocketClient client = new OpenApiJettyWebSocketClient(this.user1.webSocketUrl,handler.listener);
			
			Client tmpClient = ClientBuilder.newClient();
			WebTarget webTarget1 = tmpClient.target("http://"+serverIP+":"+port+"/inyama/service").path("snapshot");
			Invocation.Builder invocationBuilder1 =	webTarget1.request(MediaType.APPLICATION_XML).header("ClientSessionId", this.user1.clientSessionID);
			Response response = invocationBuilder1.get();
			dialedNumber.setVisible(true);
			makecallButton.setVisible(true);
	}
	
	public void makecall()
	{
		
		if(!(dialedNumber.getText().equals("")))
		{
			String clientSessionId =this.user1.clientSessionID;
			MakeCall makeCall = new MakeCall();
			DeviceID callingDevice = new DeviceID();
			callingDevice.setSwitchingSubDomainInformationElements("127.0.0.1".getBytes());
			callingDevice.setValue(this.user1.extension);
			callingDevice.setTypeOfNumber(TypeOfNumberEnum.DIALING_NUMBER);
			
			DeviceID calledDirectoryNumber = new DeviceID();
			calledDirectoryNumber.setValue(dialedNumber.getText());
			calledDirectoryNumber.setTypeOfNumber(TypeOfNumberEnum.DIALING_NUMBER);
		
			makeCall.setCallingDevice(callingDevice);
			makeCall.setCalledDirectoryNumber(calledDirectoryNumber);
			makeCall.setAutoOriginate(AutoOriginate.DO_NOT_PROMPT);
			
			String callId = "makecall-"+this.user1.extension+"-"+dialedNumber.getText();
			CorrelatorData correlatorData = new CorrelatorData();
			correlatorData.setString(callId.getBytes());
			
			makeCall.setCorrelatorData(correlatorData);
			
			MediaCallCharacteristics mediaCallCharacteristics = new MediaCallCharacteristics();
			MediaClass mediaClass = new MediaClass();
			mediaClass.setVoice(true);
			mediaCallCharacteristics.setMediaClass(mediaClass);
			
			makeCall.setMediaCallCharacteristics(mediaCallCharacteristics);
			makeCall.setSubjectOfCall("");
			Client client = ClientBuilder.newClient();
			WebTarget webTarget = client.target("http://"+serverIP+":"+port+"/inyama/service").path("callcontrol/makeCall");
		
			Invocation.Builder invocationBuilder =	webTarget.request(MediaType.APPLICATION_XML).header("ClientSessionId", clientSessionId);
			Entity<MakeCall> entity = Entity.entity(makeCall, MediaType.APPLICATION_XML);
			Response response = invocationBuilder.post(entity);
		}
	}
	
	public void updateCallSnapshot(final controllerCallSnapshot cs, final Object event)
	{
			new Thread(new Runnable() {
			    @Override public void run() {
			        Platform.runLater(new Runnable() {
			            @Override public void run() { 
			            	updateGUI(cs.callsnapshotPane, event, cs);}   
			            });
			    }
				}).start();
			
	}
	public void closeCallsnapshot()
	{
		
		Stage stage = (Stage)rootCallSnapshot.getScene().getWindow();
		if(this.user1 == null)
			stage.close();
		else
		{
			Client client = ClientBuilder.newClient();
			WebTarget webTarget = client.target("http://"+serverIP+":"+port+"/inyama/service").path("session");
			Invocation.Builder invocationBuilder =	webTarget.request(MediaType.APPLICATION_XML).header("ClientSessionId", user1.clientSessionID);
			Response response = invocationBuilder.delete();
			stage.close();
		}
	}
	public void updateGUI(final GridPane original, Object event, final controllerCallSnapshot cs)
	{
		DeliveredEvent de = null;
		ConnectionClearedEvent cc = null;
		EstablishedEvent ee = null;
		CallInformationEvent ci = null;
		HeldEvent hd = null;
		RetrievedEvent rt = null;
		
		if(event instanceof HeldEvent)
		{
			hd = (HeldEvent)event;	
			String callId = hd.getHeldConnection().getCallID();
			for(int i = 0; i < original.getChildren().size(); i++)
			{
				Pane temp = (Pane)original.getChildren().get(i);
				if(callId.equals(temp.getId()))
				{	
					VBox vb = (VBox)temp.getChildren().get(0);
					HBox hb = (HBox)vb.getChildren().get(1);
					Label lb = (Label)hb.getChildren().get(0);
					HBox hb2 = (HBox)vb.getChildren().get(2);
					
					Button answer = (Button)hb2.getChildren().get(0);
					Button hold = (Button)hb2.getChildren().get(4);
					Button unhold = (Button)hb2.getChildren().get(6);
					
					lb.setText("Held");
					
					hold.setVisible(false);
					unhold.setVisible(true);
					answer.setVisible(false);
					
					return;
				}
			}
			
		}
		else if(event instanceof RetrievedEvent)
		{
			rt = (RetrievedEvent)event;	
			String callId = rt.getRetrievedConnection().getCallID();
			for(int i = 0; i < original.getChildren().size(); i++)
			{
				Pane temp = (Pane)original.getChildren().get(i);
				if(callId.equals(temp.getId()))
				{	
					VBox vb = (VBox)temp.getChildren().get(0);
					HBox hb = (HBox)vb.getChildren().get(1);
					Label lb = (Label)hb.getChildren().get(0);
					HBox hb2 = (HBox)vb.getChildren().get(2);
					
					Button hold = (Button)hb2.getChildren().get(4);
					Button unhold = (Button)hb2.getChildren().get(6);
					
					lb.setText("Connected");
					
					hold.setVisible(true);
					unhold.setVisible(false);
					
					return;
				}
			}
			
		}
		
		else if(event instanceof DeliveredEvent)
		{
			de = (DeliveredEvent)event;
			add(original, de, cs);
		}
		else if(event instanceof ConnectionClearedEvent)
		{
			cc = (ConnectionClearedEvent)event;	
			String callId = cc.getDroppedConnection().getCallID();
			for(int i = 0; i < original.getChildren().size(); i++)
			{
				Pane temp = (Pane)original.getChildren().get(i);
				if(callId.equals(temp.getId()))
				{	
					original.getChildren().remove(i);
					return;
				}
			}
		}
		else if(event instanceof EstablishedEvent)
		{
			ee = (EstablishedEvent)event;
			String callId = ee.getEstablishedConnection().getCallID();
			for(int i = 0; i < original.getChildren().size(); i++)
			{
				Pane temp = (Pane)original.getChildren().get(i);
				if(callId.equals(temp.getId()))
				{
					VBox vb = (VBox)temp.getChildren().get(0);
					HBox hb = (HBox)vb.getChildren().get(1);
					Label lb = (Label)hb.getChildren().get(0);
					HBox hb2 = (HBox)vb.getChildren().get(2);
					Button answer = (Button)hb2.getChildren().get(0);
					Button hold = (Button)hb2.getChildren().get(4);
					
					lb.setText("Connected");
					hold.setVisible(true);
					answer.setVisible(false);
				}
			}
			
		}
		else if(event instanceof CallInformationEvent)
		{
			ci = (CallInformationEvent)event;
			addCurrentCalls(original, ci, cs);
		}
		
	}
	
	public void add(final GridPane original, final DeliveredEvent de, final controllerCallSnapshot cs)
	{
		Pane entry = new Pane();
		VBox v1 = new VBox();
		
		final String callingParty = de.getCallingDevice().getDeviceIdentifier().getValue();
		final String calledParty =  de.getCalledDevice().getDeviceIdentifier().getValue();
		final String callId  = de.getConnection().getCallID();
		
		entry.setId(callId);
		
		HBox hb1 = new HBox();
		Label name = new Label(calledParty);
		name.setStyle("-fx-text-fill: blue; -fx-font-size: 15px;");
		Label marker = new Label("  ");
		Label number = new Label("Extn"+calledParty);
		number.setStyle("-fx-text-fill: orange; -fx-font-size: 15px;");
		
		hb1.getChildren().addAll(name, marker, number);
		
		HBox hb2 = new HBox();
		Label state = new Label("alerting...");
		state.setStyle("-fx-text-fill: red; -fx-font-size: 15px;");
		
		hb2.getChildren().addAll(state);
		
		HBox hb3 = new HBox();
		final Button answer = new Button("Answer");
		answer.setStyle("-fx-base: green;");
		
		if(callingParty.equals(cs.user1.extension))
			answer.setVisible(false);
		
		final String tempServerIP = cs.serverIP;
		final String tempPort = cs.port;
		final String tempSession = cs.user1.clientSessionID;
		
		answer.setOnAction(new EventHandler<ActionEvent>() {
			@Override
			public void handle(ActionEvent event) {
				
				AnswerCall answerCall = new AnswerCall();
				ConnectionID conn = new ConnectionID();
				conn.setCallID(de.getConnection().getCallID());
				answerCall.setCallToBeAnswered(conn);
				
				Client client = ClientBuilder.newClient();
				WebTarget webTarget = client.target("http://"+tempServerIP+":"+tempPort+"/inyama/service").path("callcontrol/answerCall");
				Invocation.Builder invocationBuilder =	webTarget.request(MediaType.APPLICATION_XML).header("ClientSessionId",tempSession);
				Entity<AnswerCall> entity = Entity.entity(answerCall, MediaType.APPLICATION_XML);
				Response response = invocationBuilder.post(entity);
				
				answer.setDisable(true);
			}
		});
		
		Label marker2 = new Label("  ");
		final Button end = new Button("End");
		end.setStyle("-fx-base: red;");

		end.setOnAction(new EventHandler<ActionEvent>() {
			@Override
			public void handle(ActionEvent event) {
				ClearConnection clearConnection = new ClearConnection();
				ConnectionID conn = new ConnectionID();
				conn.setCallID(callId);
				clearConnection.setConnectionToBeCleared(conn);
				
				Client client = ClientBuilder.newClient();
				WebTarget webTarget = client.target("http://"+tempServerIP+":"+tempPort+"/inyama/service").path("callcontrol/clearConnection");
				Invocation.Builder invocationBuilder =	webTarget.request(MediaType.APPLICATION_XML).header("ClientSessionId",tempSession);
				Entity<ClearConnection> entity = Entity.entity(clearConnection, MediaType.APPLICATION_XML);
				Response response = invocationBuilder.post(entity);
				
				for(int i = 0; i < original.getChildren().size(); i++)
				{
					Pane temp = (Pane)original.getChildren().get(i);
					if(callId.equals(temp.getId()))
						original.getChildren().remove(i);
				}
			}
			
		});
		
		Label marker3 = new Label("  ");
		
		final Button hold = new Button("Hold");
		hold.setStyle("-fx-base: yellow;");
		hold.setVisible(false);
		hold.setOnAction(new EventHandler<ActionEvent>() {
			@Override
			public void handle(ActionEvent event) {
				
				HoldCall holdcall = new HoldCall();
				ConnectionID conn = new ConnectionID();
				conn.setCallID(callId);
				holdcall.setCallToBeHeld(conn);
				
				Client client = ClientBuilder.newClient();
				WebTarget webTarget = client.target("http://"+tempServerIP+":"+tempPort+"/inyama/service").path("callcontrol/holdCall");
				Invocation.Builder invocationBuilder =	webTarget.request(MediaType.APPLICATION_XML).header("ClientSessionId",tempSession);
				Entity<HoldCall> entity = Entity.entity(holdcall, MediaType.APPLICATION_XML);
				Response response = invocationBuilder.post(entity);
			}
		});
		
		
		Label marker4 = new Label("  ");
		
		final Button unhold = new Button("Retrieve");
		unhold.setStyle("-fx-base: orange;");
		unhold.setVisible(false);
		
		unhold.setOnAction(new EventHandler<ActionEvent>() {
			@Override
			public void handle(ActionEvent event) {
				
				RetrieveCall rtv = new RetrieveCall();
				ConnectionID conn = new ConnectionID();
				conn.setCallID(callId);
				rtv.setCallToBeRetrieved(conn);				
				Client client = ClientBuilder.newClient();
				WebTarget webTarget = client.target("http://"+tempServerIP+":"+tempPort+"/inyama/service").path("callcontrol/retrieveCall");
				Invocation.Builder invocationBuilder =	webTarget.request(MediaType.APPLICATION_XML).header("ClientSessionId",tempSession);
				Entity<RetrieveCall> entity = Entity.entity(rtv, MediaType.APPLICATION_XML);
				Response response = invocationBuilder.post(entity);
			}
		});
		
		hb3.getChildren().addAll(answer, marker2, end, marker3, hold, marker4, unhold);	
	
		if(callingParty.equals(cs.user1.extension))
			answer.setDisable(true);

		v1.getChildren().addAll(hb1, hb2, hb3);
		
		@SuppressWarnings("deprecation")
		int length = original.impl_getRowCount();
		boolean flag = false;
		for(int i = 0; i < length; i++)
		{
			Pane temp = (Pane)original.getChildren().get(i);
			if(entry.getId().equals(temp.getId()))
				flag = true;
		}
		if(flag == false)
		{
			entry.getChildren().addAll(v1);
			original.addRow(length, entry);
		}
	}

	public void addCurrentCalls(final GridPane original, final CallInformationEvent ci, final controllerCallSnapshot cs)
	{
		Pane entry = new Pane();
		VBox v1 = new VBox();
		
		String callingParty = ci.getDevice().getDeviceIdentifier().getValue();
		String calledParty = ci.getCallingDevice().getDeviceIdentifier().getValue();

		final String callId  = ci.getConnection().getCallID();
		entry.setId(callId);
		HBox hb1 = new HBox();
		Label name = new Label(calledParty);
		name.setStyle("-fx-text-fill: blue; -fx-font-size: 15px;");
		
		Label marker = new Label("  ");
		Label number = new Label("Extn"+calledParty);
		number.setStyle("-fx-text-fill: orange; -fx-font-size: 15px;");
		
		hb1.getChildren().addAll(name, marker, number);
		
		HBox hb2 = new HBox();
		Label state = new Label("Connected");
		state.setStyle("-fx-text-fill: red; -fx-font-size: 15px;");
		
		hb2.getChildren().addAll(state);
		
		HBox hb3 = new HBox();
		final Button answer = new Button("Answer");
		answer.setStyle("-fx-base: green;");
		answer.setVisible(false);
		
		final String tempServerIP = cs.serverIP;
		final String tempPort = cs.port;
		final String tempSession = cs.user1.clientSessionID;
		
		answer.setOnAction(new EventHandler<ActionEvent>() {
			@Override
			public void handle(ActionEvent event) {
				
				AnswerCall answerCall = new AnswerCall();
				ConnectionID conn = new ConnectionID();
				conn.setCallID(ci.getConnection().getCallID());
				answerCall.setCallToBeAnswered(conn);
				
				Client client = ClientBuilder.newClient();
				WebTarget webTarget = client.target("http://"+tempServerIP+":"+tempPort+"/inyama/service").path("callcontrol/answerCall");
				Invocation.Builder invocationBuilder =	webTarget.request(MediaType.APPLICATION_XML).header("ClientSessionId",tempSession);
				Entity<AnswerCall> entity = Entity.entity(answerCall, MediaType.APPLICATION_XML);
				Response response = invocationBuilder.post(entity);
				
				answer.setDisable(true);
			}
		});
		
		Label marker2 = new Label("  ");
		final Button end = new Button("End");
		end.setStyle("-fx-base: red;");

		end.setOnAction(new EventHandler<ActionEvent>() {
			@Override
			public void handle(ActionEvent event) {
				ClearConnection clearConnection = new ClearConnection();
				ConnectionID conn = new ConnectionID();
				conn.setCallID(callId);
				clearConnection.setConnectionToBeCleared(conn);
				
				Client client = ClientBuilder.newClient();
				WebTarget webTarget = client.target("http://"+tempServerIP+":"+tempPort+"/inyama/service").path("callcontrol/clearConnection");
				Invocation.Builder invocationBuilder =	webTarget.request(MediaType.APPLICATION_XML).header("ClientSessionId",tempSession);
				Entity<ClearConnection> entity = Entity.entity(clearConnection, MediaType.APPLICATION_XML);
				Response response = invocationBuilder.post(entity);
				
				for(int i = 0; i < original.getChildren().size(); i++)
				{
					Pane temp = (Pane)original.getChildren().get(i);
					if(callId.equals(temp.getId()))
					{
						original.getChildren().remove(i);
					}
				}
			}
			
		});
		
		Label marker3 = new Label("  ");
		
		final Button hold = new Button("Hold");
		hold.setStyle("-fx-base: yellow;");
		hold.setVisible(true);
		
		hold.setOnAction(new EventHandler<ActionEvent>() {
			@Override
			public void handle(ActionEvent event) {
				
				HoldCall holdcall = new HoldCall();
				ConnectionID conn = new ConnectionID();
				conn.setCallID(callId);
				holdcall.setCallToBeHeld(conn);
				
				Client client = ClientBuilder.newClient();
				WebTarget webTarget = client.target("http://"+tempServerIP+":"+tempPort+"/inyama/service").path("callcontrol/holdCall");
				Invocation.Builder invocationBuilder =	webTarget.request(MediaType.APPLICATION_XML).header("ClientSessionId",tempSession);
				Entity<HoldCall> entity = Entity.entity(holdcall, MediaType.APPLICATION_XML);
				Response response = invocationBuilder.post(entity);
			}
		});
		
		Label marker4 = new Label("  ");
		
		final Button unhold = new Button("Retrieve");
		unhold.setStyle("-fx-base: orange;");
		unhold.setVisible(false);
		
		unhold.setOnAction(new EventHandler<ActionEvent>() {
			@Override
			public void handle(ActionEvent event) {
				
				RetrieveCall rtv = new RetrieveCall();
				ConnectionID conn = new ConnectionID();
				conn.setCallID(callId);
				rtv.setCallToBeRetrieved(conn);				
				Client client = ClientBuilder.newClient();
				WebTarget webTarget = client.target("http://"+tempServerIP+":"+tempPort+"/inyama/service").path("callcontrol/retrieveCall");
				Invocation.Builder invocationBuilder =	webTarget.request(MediaType.APPLICATION_XML).header("ClientSessionId",tempSession);
				Entity<RetrieveCall> entity = Entity.entity(rtv, MediaType.APPLICATION_XML);
				Response response = invocationBuilder.post(entity);
			}
		});
		
		
		hb3.getChildren().addAll(answer, marker2, end, marker3, hold, marker4, unhold);	
	
		if(callingParty.equals(cs.user1.extension))
			answer.setDisable(true);
		
		v1.getChildren().addAll(hb1, hb2, hb3);
		
		@SuppressWarnings("deprecation")
		int length = original.impl_getRowCount();
		boolean flag = false;
		for(int i = 0; i < length; i++)
		{
			Pane temp = (Pane)original.getChildren().get(i);
			if(entry.getId().equals(temp.getId()))
				flag = true;
		}
		if(flag == false)
		{
			entry.getChildren().addAll(v1);
			original.addRow(length, entry);
		}
	}

}