package com.avaya.ipoffice.openapi.samples.javafx;

import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.xml.transform.TransformerException;

import com.avaya.ipoffice.openapi.samples.data.*;
import com.avaya.ipoffice.openapi.samples.LoginSample;

import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.layout.AnchorPane;
import javafx.stage.Stage;

public class controllerLogin {

	@FXML Button getLoginResponse;
	@FXML Label codeLabel;
	@FXML TextField codeText;
	@FXML TextField sessionText;
	@FXML TextField versionText;
	@FXML TextField wssurlText;
	@FXML TextField wsurlText;
	@FXML TextArea xmlData;
	
	@FXML TextField usernameTextLogin;
	@FXML TextField passwordTextLogin;
	@FXML TextField portTextLogin;
	@FXML TextField serverTextLogin;
	@FXML TextArea xmlResponseLogin;
	@FXML AnchorPane rootLogin;
	@FXML Button close;
	
	String name;
	String password;
	String serverIP;
	String port;
	String clientSessionId = "";
	public void mainLogin()
	{
		
		LoginSample user1 = new LoginSample();
		this.name = usernameTextLogin.getText();
		this.password = passwordTextLogin.getText();
		this.serverIP = serverTextLogin.getText();
		this.port = portTextLogin.getText();
		
		Response response = user1.login(this.name, this.password, this.serverIP, this.port);
		UserLoginResponse loginresponse = user1.loginResponse;
		this.clientSessionId = user1.clientSessionID;
		
		codeText.setText(""+response.getStatus());
		sessionText.setText(loginresponse.getClientSessionID());
		versionText.setText(loginresponse.getApplicationVersion());
		wssurlText.setText(loginresponse.getWebSocketWssUrl());
		wsurlText.setText(loginresponse.getWebSocketWsUrl());
		
		xmlResponseLogin.setWrapText(true);
		xmlResponseLogin.setStyle("-fx-text-fill: green;");
		xmlResponseLogin.setText(user1.xmlResponse);
		
		codeText.setEditable(false);
		versionText.setEditable(false);
		sessionText.setEditable(false);
		wssurlText.setEditable(false);
		wsurlText.setEditable(false);
		
	}
	public void closeLogin()
	{
		
		Stage stage = (Stage)rootLogin.getScene().getWindow();
		
		if(this.clientSessionId.equals(""))
			stage.close();
		else
		{
			Client client = ClientBuilder.newClient();
			WebTarget webTarget = client.target("http://"+serverIP+":"+port+"/inyama/service").path("session");
			Invocation.Builder invocationBuilder =	webTarget.request(MediaType.APPLICATION_XML).header("ClientSessionId", this.clientSessionId);
			Response response = invocationBuilder.delete();
			stage.close();
		}
	}
	
}
