﻿function ipoJsonStrings() {
    var switchingDevice;
    this.setSwitchDevice = setSwitchDevice;
    this.Base64Encode = Base64Encode;
    this.Base64Decode = Base64Decode;

    this.getLoginPayload = function (username, password) {
        var loginPayload = JSON.stringify({ "UserLoginRequest": { "userName": "<<USERNAME>>", "userPassword": "<<PASSWORD>>", "applicationName": "SalesForce", "applicationVersion": "10.0.0.0", "loginSubscriptionRequest": { "httpMethod": "WEBSOCKET", "callBackUrl": null, "eventTypes": ["CALL_CONTROL_FEATURES_EVENTS", "PHYSICAL_DEVICE_FEATURES_EVENTS", "LOGICAL_DEVICE_FEATURES_EVENTS", "DEVICE_MAINTENANCE_EVENTS", "VOICEMAIL_SERVICES_EVENTS", "PRESENCE_EVENTS", "DIRECTORY_EVENTS", "SNAPSHOT_SERVICES_CALLBACK_EVENTS", "CALL_ASSOCIATED_FEATURES_EVENTS", "CAPABILITY_EXCHANGE_SERVICES_CALLBACK_EVENTS", "SYSTEM_SERVICES_CALLBACK_EVENTS", "MONITORING_SERVICES_CALLBACK_EVENTS", "IO_SERVICES_FEATURES_CALLBACK_EVENTS", "LOGOUT_EVENTS", "RECORDING_SERVICES_EVENTS"] } } });
        loginPayload = loginPayload.replace('<<USERNAME>>', username).replace('<<PASSWORD>>', password);
        printOnConsole(loginPayload);
        return loginPayload;
    }

    this.getMakeCallPayload = function (calling, called) {
        var uuid = toBase64(guid());
        var payload = JSON.stringify({ "MakeCall": { "callingDevice": { "value": "<<CALLING>>", "typeOfNumber": "DIALING_NUMBER", "mediaClass": ["AUDIO"], "connectionRate": null, "bitRate": "CONSTANT", "delayTolerance": null, "switchingSubDomainCCIEType": null, "switchingSubDomainInformationElements": "<<SWITCHINGDEVICE>>" }, "calledDirectoryNumber": { "value": "<<CALLED>>", "typeOfNumber": "DIALING_NUMBER", "mediaClass": ["AUDIO"], "connectionRate": null, "bitRate": "CONSTANT", "delayTolerance": null, "switchingSubDomainCCIEType": null, "switchingSubDomainInformationElements": null }, "accountCode": "", "authCode": null, "autoOriginate": "DO_NOT_PROMPT", "correlatorData": { "string": "<<UUID>>", "private": null }, "userData": null, "callCharacteristics": null, "mediaCallCharacteristics": { "mediaClass": { "voice": true, "data": null, "image": null, "audio": null, "other": null, "notKnown": null, "chat": null, "email": null, "message": null, "im": null, "sms": null, "mms": null }, "connectionRate": null, "bitRate": null, "delayTolerance": null, "switchingSubDomainCCIEType": null, "switchingSubDomainInformationElements": null }, "callingConnectionInfo": null, "subjectOfCall": "", "languagePreferences": null, "reason": null, "extensions": null } });
        payload = payload.replace('<<CALLING>>', calling).replace('<<CALLED>>', called).replace('<<SWITCHINGDEVICE>>', switchingDevice).replace('<<UUID>>', uuid);
        printOnConsole(payload);
        return payload;
    }

    this.getAnswerCallPayload = function (connection_id) {
        var payload = JSON.stringify({ "AnswerCall": { "callToBeAnswered": { "content": [], "callID": "<<CONNECTIONID>>", "deviceID": null }, "correlatorData": null, "userData": null, "extensions": null } });
        payload = payload.replace('<<CONNECTIONID>>', connection_id);
        printOnConsole(payload);
        return payload;
    }

    this.getDropCallPayload = function (connection_id) {
        var payload = JSON.stringify({ "ClearConnection": { "connectionToBeCleared": { "content": [], "callID": "<<CONNECTIONID>>", "deviceID": null }, "correlatorData": null, "userData": null, "reason": null, "extensions": null } });
        payload = payload.replace('<<CONNECTIONID>>', connection_id);
        printOnConsole(payload);
        return payload;
    }

    this.getHoldCallPayload = function (connection_id) {
        var payload = JSON.stringify({ "HoldCall": { "callToBeHeld": { "content": [], "callID": "<<CONNECTIONID>>", "deviceID": null }, "connectionReservation": null, "extensions": null } });
        payload = payload.replace('<<CONNECTIONID>>', connection_id);
        printOnConsole(payload);
        return payload;
    }

    this.getUnHoldCallPayload = function (connection_id) {
        var payload = JSON.stringify({ "RetrieveCall": { "callToBeRetrieved": { "content": [], "callID": "<<CONNECTIONID>>", "deviceID": null }, "extensions": null } });
        payload = payload.replace('<<CONNECTIONID>>', connection_id);
        printOnConsole(payload);
        return payload;
    }

    this.getAlternateCallPayload = function (held_connection_id, active_connection_id) {
        var payload = JSON.stringify({ "AlternateCall": { "heldCall": { "content": [], "callID": "<<HELD_CONNECTIONID>>", "deviceID": null }, "activeCall": { "content": [], "callID": "<<ACTIVE_CONNECTIONID>>", "deviceID": null }, "connectionReservation": null, "consultOptions": null, "extensions": null } });
        payload = payload.replace('<<HELD_CONNECTIONID>>', held_connection_id).replace('<<ACTIVE_CONNECTIONID>>', active_connection_id);
        printOnConsole(payload);
        return payload;
    }

    this.getConferenceCallPayload = function (held_connection_id, active_connection_id) {
        var payload = JSON.stringify({ "ConferenceCall": { "heldCall": { "callID": "<<HELD_CONNECTIONID>>", "deviceID": null }, "activeCall": { "callID": "<<ACTIVE_CONNECTIONID>>", "deviceID": null }, "extensions": null } });
        payload = payload.replace('<<HELD_CONNECTIONID>>', held_connection_id).replace('<<ACTIVE_CONNECTIONID>>', active_connection_id);
        printOnConsole(payload);
        return payload;
    }

    this.getMuteUnmuteCallPayload = function (connection_id, isMuted) {
        var payload = '';
        var pData = toBase64(connection_id);
        if (isMuted == true) {
            payload = JSON.stringify({ "SetMicrophoneMute": { "device": null, "auditoryApparatus": null, "microphoneMuteOn": false, "extensions": { "security": null, "privateData": { "string": "<<CONNECTIONID>>", "private": null } } } });
        }
        else {
            payload = JSON.stringify({ "SetMicrophoneMute": { "device": null, "auditoryApparatus": null, "microphoneMuteOn": true, "extensions": { "security": null, "privateData": { "string": "<<CONNECTIONID>>", "private": null } } } });
        }
        payload = payload.replace('<<CONNECTIONID>>', pData);
        printOnConsole(payload);
        return payload;
    }

    this.getTransferCallPayload = function (connection_id, toNumber) {
        var payload = JSON.stringify({ "SingleStepTransferCall": { "activeCall": { "content": [], "callID": "<<CONNECTIONID>>", "deviceID": null }, "transferredTo": { "value": "<<TONUMBER>>", "typeOfNumber": "DIALING_NUMBER", "mediaClass": ["NOT_KNOWN"], "connectionRate": null, "bitRate": "CONSTANT", "delayTolerance": null, "switchingSubDomainCCIEType": null, "switchingSubDomainInformationElements": null }, "accountCode": "", "authCode": null, "correlatorData": null, "userData": null, "subjectOfCall": "", "languagePreferences": null, "reason": null, "extensions": null } });
        payload = payload.replace('<<CONNECTIONID>>', connection_id).replace('<<TONUMBER>>', toNumber);
        printOnConsole(payload);
        return payload;
    }

    this.getConsultationCallPayload = function (existing_connection_id, consultedNumber) {
        var uuid = toBase64(guid());
        var payload = JSON.stringify({ "ConsultationCall": { "existingCall": { "content": [], "callID": "<<CONNECTIONID>>", "deviceID": null }, "consultedDevice": { "value": "<<CONSULTEDNUMBER>>", "typeOfNumber": "DIALING_NUMBER", "mediaClass": ["AUDIO"], "connectionRate": null, "bitRate": "CONSTANT", "delayTolerance": null, "switchingSubDomainCCIEType": null, "switchingSubDomainInformationElements": null }, "connectionReservation": null, "accountCode": "", "authCode": null, "correlatorData": { "string": "<<UUID>>", "private": null }, "userData": null, "callCharacteristics": null, "mediaCallCharacteristics": null, "callingConnectionInfo": null, "consultOptions": null, "subjectOfCall": "", "languagePreferences": null, "extensions": null } });
        payload = payload.replace('<<CONNECTIONID>>', existing_connection_id).replace('<<CONSULTEDNUMBER>>', consultedNumber).replace('<<UUID>>', uuid);
        printOnConsole(payload);
        return payload;
    }

    this.getTransferCompleteCallPayload = function (held_connection_id, active_connection_id) {
        var payload = JSON.stringify({ "TransferCall": { "heldCall": { "content": [], "callID": "<<HELD_CONNECTIONID>>", "deviceID": null }, "activeCall": { "content": [], "callID": "<<ACTIVE_CONNECTIONID>>", "deviceID": null}, "extensions": null } });
        payload = payload.replace('<<HELD_CONNECTIONID>>', held_connection_id).replace('<<ACTIVE_CONNECTIONID>>', active_connection_id);
        printOnConsole(payload);
        return payload;
    }

    this.getJsonDtmfPayload = function (connection_id, digits) {
        var payload = JSON.stringify({ "GenerateDigits": { "connectionToSendDigits": { "callID": "<<CONNECTIONID>>", "deviceID": null }, "digitMode": null, "charactersToSend": "<<DIGITS>>", "toneDuration": null, "pulseRate": null, "pauseDuration": null, "extensions": null } });
        payload = payload.replace('<<CONNECTIONID>>', connection_id).replace('<<DIGITS>>', digits);
        printOnConsole(payload);
        return payload;
    }

    this.getJsonSnapshotPayload = function (device) {
        var payload = JSON.stringify({ "SnapshotDevice": { "snapshotObject": { "typeOfNumber": "DEVICE_NUMBER", "mediaClass": "VOICE", "switchingSubDomainInformationElements": "<<SWITCHINGDEVICE>>", "text": "<<DEVICE>>" } } });
        payload = payload.replace('<<DEVICE>>', device).replace('<<SWITCHINGDEVICE>>', switchingDevice);
        printOnConsole(payload);
        return payload;
    }
    
    function printOnConsole(message) {
        try {
            console.log(message);
            console.log('\n');
        } catch (e) {
        }
    }

    function charToHex(switchingDevice) {
        var hexString = "";
        for (var i = 0; i < switchingDevice.length; ++i) {
            hexString += switchingDevice.charCodeAt(i).toString(16).toUpperCase();
        }
        return hexString;
    }

    function toBase64(switchingDevice) {
        return Base64.encode(switchingDevice);
    }

    function guid() {
        function s4() {
            return Math.floor((1 + Math.random()) * 0x10000)
              .toString(16)
              .substring(1);
        }
        return s4() + s4() + '-' + s4() + '-' + s4() + '-' +
          s4() + '-' + s4() + s4() + s4();
    }
    
    function charToHex(inputString) {
        var hexString = "";
        for (var i = 0; i < inputString.length; ++i) {
            hexString += inputString.charCodeAt(i).toString(16).toUpperCase();
        }
        return hexString;
    }

    function Base64Encode(input) {
        return Base64.encode(input);
    }

    function Base64Decode(input) {
        return Base64.decode(input);
    }

    var Base64 = {
        _keyStr: "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=",

        encode: function (input) {
            var output = "";
            var chr1, chr2, chr3, enc1, enc2, enc3, enc4;
            var i = 0;

            input = Base64._utf8_encode(input);

            while (i < input.length) {

                chr1 = input.charCodeAt(i++);
                chr2 = input.charCodeAt(i++);
                chr3 = input.charCodeAt(i++);

                enc1 = chr1 >> 2;
                enc2 = ((chr1 & 3) << 4) | (chr2 >> 4);
                enc3 = ((chr2 & 15) << 2) | (chr3 >> 6);
                enc4 = chr3 & 63;

                if (isNaN(chr2)) {
                    enc3 = enc4 = 64;
                } else if (isNaN(chr3)) {
                    enc4 = 64;
                }

                output = output + this._keyStr.charAt(enc1) + this._keyStr.charAt(enc2) + this._keyStr.charAt(enc3) + this._keyStr.charAt(enc4);
            }
            return output;
        },

        decode: function (input) {
            var output = "";
            var chr1, chr2, chr3;
            var enc1, enc2, enc3, enc4;
            var i = 0;

            input = input.replace(/[^A-Za-z0-9\+\/\=]/g, "");

            while (i < input.length) {

                enc1 = this._keyStr.indexOf(input.charAt(i++));
                enc2 = this._keyStr.indexOf(input.charAt(i++));
                enc3 = this._keyStr.indexOf(input.charAt(i++));
                enc4 = this._keyStr.indexOf(input.charAt(i++));

                chr1 = (enc1 << 2) | (enc2 >> 4);
                chr2 = ((enc2 & 15) << 4) | (enc3 >> 2);
                chr3 = ((enc3 & 3) << 6) | enc4;

                output = output + String.fromCharCode(chr1);

                if (enc3 != 64) {
                    output = output + String.fromCharCode(chr2);
                }
                if (enc4 != 64) {
                    output = output + String.fromCharCode(chr3);
                }

            }

            output = Base64._utf8_decode(output);

            return output;
        },

        _utf8_encode: function (string) {
            string = string.replace(/\r\n/g, "\n");
            var utftext = "";

            for (var n = 0; n < string.length; n++) {

                var c = string.charCodeAt(n);

                if (c < 128) {
                    utftext += String.fromCharCode(c);
                }
                else if ((c > 127) && (c < 2048)) {
                    utftext += String.fromCharCode((c >> 6) | 192);
                    utftext += String.fromCharCode((c & 63) | 128);
                }
                else {
                    utftext += String.fromCharCode((c >> 12) | 224);
                    utftext += String.fromCharCode(((c >> 6) & 63) | 128);
                    utftext += String.fromCharCode((c & 63) | 128);
                }

            }

            return utftext;
        },

        _utf8_decode: function (utftext) {
            var string = "";
            var i = 0;
            var c = c1 = c2 = 0;

            while (i < utftext.length) {

                c = utftext.charCodeAt(i);

                if (c < 128) {
                    string += String.fromCharCode(c);
                    i++;
                }
                else if ((c > 191) && (c < 224)) {
                    c2 = utftext.charCodeAt(i + 1);
                    string += String.fromCharCode(((c & 31) << 6) | (c2 & 63));
                    i += 2;
                }
                else {
                    c2 = utftext.charCodeAt(i + 1);
                    c3 = utftext.charCodeAt(i + 2);
                    string += String.fromCharCode(((c & 15) << 12) | ((c2 & 63) << 6) | (c3 & 63));
                    i += 3;
                }

            }

            return string;
        }
    }

    function setSwitchDevice(switchDevice) {
        switchingDevice = toBase64(switchDevice);
    }
}