package com.avaya.ipoffice.openapi.samples.adapter;

import com.avaya.ipoffice.openapi.samples.adapter.exception.OpenApiException;
import com.avaya.ipoffice.openapi.samples.adapter.jaxb.UserLoginResponse;
import com.avaya.ipoffice.openapi.samples.adapter.session.SessionOpenApiRestAdapter;
import com.avaya.ipoffice.openapi.samples.adapter.websocket.OpenApiEventNotifier;
import com.avaya.ipoffice.openapi.samples.adapter.websocket.OpenApiWebSocketAdapter;

public class WebSocketAdapterSample {

	public static void main(String arg[]) {
		
		OpenApiRestServiceConfig.setServer("148.147.216.234");
		OpenApiRestServiceConfig.setPort("8080");
		OpenApiRestServiceConfig.setServiceUrl("/inyama/service/");
		OpenApiRestServiceConfig.setSecure(false);
		
		try {
			UserLoginResponse loginResponse = SessionOpenApiRestAdapter.login("Extn111", "1234", "App");
			String clientSessionId = loginResponse.getClientSessionID();
			String webSocketUrl = loginResponse.getWebSocketWsUrl();
			System.out.println("clientSessionId "+clientSessionId);
			System.out.println("webSocketUrl "+webSocketUrl);
			
			OpenApiWebSocketAdapter  OpenApiWebSocketAdapter = new OpenApiWebSocketAdapter(clientSessionId);
			OpenApiWebSocketAdapter.connect(webSocketUrl);
			
			OpenApiWebSocketAdapter.addOpenApiEventNotifier(new OpenApiEventNotifier() {
				
				@Override
				public void notifyEvent(Object eventObject) {
					System.out.println("Received Open api event "+eventObject);
				}
			});
			
		} catch (OpenApiException e) {
			System.out.println("Error : "+e.getMessage());
		}
	}
}

