package com.avaya.ipoffice.openapi.samples.adapter.calllog;

import com.avaya.ipoffice.openapi.samples.adapter.jaxb.AVMMessageStateChangedEvent;
import com.avaya.ipoffice.openapi.samples.adapter.jaxb.AVMNewMessageEvent;
import com.avaya.ipoffice.openapi.samples.adapter.jaxb.AVMSnapshotEvent;
import com.avaya.ipoffice.openapi.samples.adapter.jaxb.CallLogEvent;
import com.avaya.ipoffice.openapi.samples.adapter.jaxb.CallLogEventType;
import com.avaya.ipoffice.openapi.samples.adapter.ui.data.SessionDataStore;
import com.avaya.ipoffice.openapi.samples.adapter.websocket.OpenApiEventNotifier;

public class CallLogOpenApiEventAdapter implements OpenApiEventNotifier {
	
	private String clientSessionId;
	
	public CallLogOpenApiEventAdapter(String clientSessionId) {
		this.clientSessionId = clientSessionId;
	}

	@Override
	public void notifyEvent(Object eventObject) {
		
		if (eventObject instanceof CallLogEvent) {
			CallLogEvent callLogEvent = (CallLogEvent)eventObject;
			//if (callLogEvent.getType() == CallLogEventType.ADDED) {
				SessionDataStore.getSessionDataStore(clientSessionId).getCallLogDataStore().add(callLogEvent.getEntry());
			//}
		} 
	}

}
