package com.avaya.ipoffice.openapi.samples.adapter.calllog;

import java.util.List;

import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

import com.avaya.ipoffice.openapi.samples.adapter.OpenApiRestServiceConfig;
import com.avaya.ipoffice.openapi.samples.adapter.exception.OpenApiException;
import com.avaya.ipoffice.openapi.samples.adapter.jaxb.CallLogEntry;
import com.avaya.ipoffice.openapi.samples.adapter.jaxb.Error;
import com.avaya.ipoffice.openapi.samples.adapter.jaxb.Errors;
import com.avaya.ipoffice.openapi.samples.adapter.jaxb.SendStoredCallLogResponse;

public class CallLogOpenApiRestAdapter extends OpenApiRestServiceConfig {
	
	public static List<CallLogEntry> getCallLogs(String clientSessionId) throws Exception {
		
		Client client = ClientBuilder.newClient();
		WebTarget webTarget = client.target(OpenApiRestServiceConfig.getOpenApiRestServiceUrl()).path("calllog");
		
	
		Invocation.Builder invocationBuilder =	webTarget.request(MediaType.APPLICATION_XML).header("ClientSessionId", clientSessionId);

		Response response = invocationBuilder.get();
		//System.out.println( response.readEntity(String.class));
		if (response.getStatus() == 202) {
			SendStoredCallLogResponse callLogResponse = response.readEntity(SendStoredCallLogResponse.class);
			return  callLogResponse.getReturn();
		} else {
			if (response.getStatus() != 400) {
				Error error = response.readEntity(Error.class);
				throw new OpenApiException(error);
			} else {
				Errors errors = response.readEntity(Errors.class);
				throw new OpenApiException(errors);
			}
		}
	}
}
