package com.avaya.ipoffice.openapi.samples.adapter.presence;

import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

import com.avaya.ipoffice.openapi.samples.adapter.OpenApiRestServiceConfig;
import com.avaya.ipoffice.openapi.samples.adapter.exception.OpenApiException;
import com.avaya.ipoffice.openapi.samples.adapter.jaxb.Error;
import com.avaya.ipoffice.openapi.samples.adapter.jaxb.Errors;
import com.avaya.ipoffice.openapi.samples.adapter.jaxb.PresenceState;
import com.avaya.ipoffice.openapi.samples.adapter.jaxb.PresenceStates;
import com.avaya.ipoffice.openapi.samples.adapter.jaxb.TelephonyPresence;

public class PresenceOpenApiRestAdapter {
	
	public static PresenceState getXmppPresence(String clientSessionId) throws OpenApiException {

		Client client = ClientBuilder.newClient();
		WebTarget webTarget = client.target(OpenApiRestServiceConfig.getOpenApiRestServiceUrl()).path("presence");
		
	
		Invocation.Builder invocationBuilder =	webTarget.request(MediaType.APPLICATION_XML).header("ClientSessionId", clientSessionId);

		Response response = invocationBuilder.get();
		//System.out.println(response.readEntity(String.class));
		if (response.getStatus() == 202) {
			PresenceStates presenceStates = response.readEntity(PresenceStates.class);
			return presenceStates.getPresenceState().get(0);
		} else {
			if (response.getStatus() != 400) {
				Error error = response.readEntity(Error.class);
				throw new OpenApiException(error);
			} else {
				Errors errors = response.readEntity(Errors.class);
				throw new OpenApiException(errors);
			}
		}
	}
}
