package com.avaya.ipoffice.openapi.samples.adapter.ui;

import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.List;

import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

import com.avaya.ipoffice.openapi.samples.adapter.OpenApiRestServiceConfig;
import com.avaya.ipoffice.openapi.samples.adapter.callcontrol.CallControlOpenApiEventAdapter;
import com.avaya.ipoffice.openapi.samples.adapter.callcontrol.CallControlOpenApiRestAdapter;
import com.avaya.ipoffice.openapi.samples.adapter.calllog.CallLogOpenApiEventAdapter;
import com.avaya.ipoffice.openapi.samples.adapter.calllog.CallLogOpenApiRestAdapter;
import com.avaya.ipoffice.openapi.samples.adapter.directory.DirectoryOpenApiEventAdapter;
import com.avaya.ipoffice.openapi.samples.adapter.directory.DirectoryOpenApiRestAdapter;
import com.avaya.ipoffice.openapi.samples.adapter.exception.OpenApiException;
import com.avaya.ipoffice.openapi.samples.adapter.jaxb.CallLogEntry;
import com.avaya.ipoffice.openapi.samples.adapter.jaxb.DirectoryContact;
import com.avaya.ipoffice.openapi.samples.adapter.jaxb.PresenceState;
import com.avaya.ipoffice.openapi.samples.adapter.jaxb.TelephonyPresence;
import com.avaya.ipoffice.openapi.samples.adapter.jaxb.UserLoginResponse;
import com.avaya.ipoffice.openapi.samples.adapter.presence.PresenceOpenApiEventAdapter;
import com.avaya.ipoffice.openapi.samples.adapter.presence.PresenceOpenApiRestAdapter;
import com.avaya.ipoffice.openapi.samples.adapter.session.SessionOpenApiRestAdapter;
import com.avaya.ipoffice.openapi.samples.adapter.ui.data.SessionDataStore;
import com.avaya.ipoffice.openapi.samples.adapter.voicemail.VoicemailOpenApiEventAdapter;
import com.avaya.ipoffice.openapi.samples.adapter.voicemail.VoicemailOpenApiRestAdapter;
import com.avaya.ipoffice.openapi.samples.adapter.websocket.OpenApiEventNotifier;
import com.avaya.ipoffice.openapi.samples.adapter.websocket.OpenApiWebSocketAdapter;

public class OpenApiSampleAdapterClientUI implements ActionListener {

	
	private JPanel centerPanel = new JPanel();
	private JPanel logoutPanel = new JPanel();
	private LoginPanel loginPanel;
	private ConfigPanel configPanel;
	private JButton loginButton;
	private JButton logoutButton;
	private SnapshotPanel snapshotPanel;
	
	private String clientSessionId;
	
	
	JFrame frame = new JFrame("Open Api Sample Client");

	
	public OpenApiSampleAdapterClientUI() {
		
		JPanel startPanel = new JPanel();
		startPanel.setLayout(new GridLayout(3,1));
		
		loginPanel = new LoginPanel();
		configPanel = new ConfigPanel();
		
		
		loginButton = new JButton("Login");
		loginButton.addActionListener(this);
		
		JPanel buttonPanel = new JPanel();
		buttonPanel.add(loginButton);
		
		startPanel.add(loginPanel);
		startPanel.add(configPanel);
		startPanel.add(buttonPanel);
		
		centerPanel.add(startPanel);
		centerPanel.setAlignmentX(JComponent.CENTER_ALIGNMENT);
		centerPanel.setAlignmentY(JComponent.CENTER_ALIGNMENT);
		
		frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

		
	    frame.getContentPane().add(centerPanel, BorderLayout.CENTER);

	    frame.setSize(1000, 600);
	    frame.setVisible(true);
		
	}
	

	@Override
	public void actionPerformed(ActionEvent e) {
		if (e.getSource() == loginButton) {
			String server = configPanel.getServer();
			String port = configPanel.getPort();
			boolean secure = configPanel.getSecure();
			String serviceUrl = configPanel.getServiceUrl();
			
			OpenApiRestServiceConfig.setServer(server);
			OpenApiRestServiceConfig.setPort(port);
			OpenApiRestServiceConfig.setServiceUrl(serviceUrl);
			OpenApiRestServiceConfig.setSecure(secure);
	
			
			String username = loginPanel.getUsername();
			String password = loginPanel.getPassword();
			String appname = loginPanel.getApplication();
			
			try {
				UserLoginResponse loginResponse = SessionOpenApiRestAdapter.login(username, password, appname);
				clientSessionId = loginResponse.getClientSessionID();
				String webSocketUrl = loginResponse.getWebSocketWsUrl();
				System.out.println("clientSessionId "+clientSessionId);
				System.out.println("webSocketUrl "+webSocketUrl);
					
				SessionDataStore.getSessionDataStore(clientSessionId).setUserSessionInfo(loginResponse);
				
				OpenApiWebSocketAdapter  OpenApiWebSocketAdapter = new OpenApiWebSocketAdapter(clientSessionId);
				OpenApiWebSocketAdapter.addOpenApiEventNotifier(new CallControlOpenApiEventAdapter(clientSessionId)) ;
				OpenApiWebSocketAdapter.addOpenApiEventNotifier(new VoicemailOpenApiEventAdapter(clientSessionId)) ;
				OpenApiWebSocketAdapter.addOpenApiEventNotifier(new CallLogOpenApiEventAdapter(clientSessionId)) ;
				OpenApiWebSocketAdapter.addOpenApiEventNotifier(new DirectoryOpenApiEventAdapter(clientSessionId)) ;
				OpenApiWebSocketAdapter.addOpenApiEventNotifier(new PresenceOpenApiEventAdapter(clientSessionId)) ;
	
				OpenApiWebSocketAdapter.connect(webSocketUrl);
				
				
				snapshotPanel = new SnapshotPanel(clientSessionId);
			    frame.getContentPane().removeAll();
			    frame.getContentPane().add(snapshotPanel, BorderLayout.CENTER);
				
			    getSnapshots(clientSessionId);
				
			    logoutButton = new JButton("Logout");
			    logoutButton.addActionListener(this);
			    logoutPanel = new JPanel();
			    logoutPanel.add(logoutButton);
			    frame.getContentPane().add(logoutPanel, BorderLayout.SOUTH);
			
			} catch (OpenApiException ex) {
				System.out.println("Error : "+ex.getMessage());
			} catch (Exception ex) {
				ex.printStackTrace();
			}
		} else if (e.getSource() == logoutButton) {
			frame.getContentPane().remove(snapshotPanel);
		    frame.getContentPane().remove(logoutPanel);
		    frame.getContentPane().add(centerPanel, BorderLayout.CENTER);
			try {
				SessionOpenApiRestAdapter.logout(clientSessionId);
			} catch (Exception ex) {
				ex.printStackTrace();
			}
			
		}
	}
	
	public static void main(String[] arg) {
		new OpenApiSampleAdapterClientUI();
	}
	
	
	public void getSnapshots(String clientSessionId) throws Exception {
		
		UserLoginResponse userSessionInfo = SessionDataStore.getSessionDataStore(clientSessionId).getUserSessionInfo();
		String device = userSessionInfo.getUserExtension();
		String subdomain = userSessionInfo.getUserSwitchDevice();
		

		try {
			PresenceState xmppPresence = PresenceOpenApiRestAdapter.getXmppPresence(clientSessionId);
			SessionDataStore.getSessionDataStore(clientSessionId).getXmppPresenceDataStore().add(xmppPresence);
		} catch (Exception e) {
			e.printStackTrace();
		}
		
		try {
			CallControlOpenApiRestAdapter.getCallSnapshot(clientSessionId, subdomain, device);
		} catch (Exception e) {
			e.printStackTrace();
		}

		try {
			VoicemailOpenApiRestAdapter.getVoicemailSnapshot(clientSessionId, device, subdomain);
		} catch (Exception e) {
			e.printStackTrace();
		}
		
		try {
			List<DirectoryContact> contactList = DirectoryOpenApiRestAdapter.getSystemDirectory(clientSessionId);
			SessionDataStore.getSessionDataStore(clientSessionId).getContactDataStore().add(contactList);
		} catch (Exception ex) {
			ex.printStackTrace();
		}
		
		try {
			List<CallLogEntry> callLogList = CallLogOpenApiRestAdapter.getCallLogs(clientSessionId);
			SessionDataStore.getSessionDataStore(clientSessionId).getCallLogDataStore().add(callLogList);		
		} catch (Exception ex) {
			ex.printStackTrace();
		}
	}	
}
