﻿function ipoConnectionManager() {
    var webSocketConn;
    var isWebSocketOpen = false;
    var needToTrackWebSocket = false;
    var webSocketCloseRequested = false;
    var serverPortNumber = "9443";
    var ipAddress = "148.147.175.153";
    var serverIPAddress = ipAddress;
    var primaryServerIPAddress = ipAddress;
    var secondaryServerIPAddress = ipAddress;
    var lastIPAddrAttempted = '';
    var heartBeatTime = 20;
    var heartBeatWebsocketTime = 20;
    var clientSessionId = "";
    var userSwitchDevice = "";
    var userName = "";
    var userExtension = "";
    var serverWebSocketURL = "";
    var ipoJsonStringsObject;
    var confPrimaryID = "";
    var usernameCached = "";
    var passwordCached = "";
    var conferencesCleared = [null, null];
    var loginEvent;
    var incomingCallEvent;
    var alertingCallEvent;
    var failedCallEvent;
    var connectedCallEvent;
    var consultedCallEvent;
    var clearedCallEvent;
    var heldCallEvent;
    var muteUnmuteCallEvent;
    var transferEvent;
    var conferenceEvent;
    var logoffEvent;
    var dndEvent;
    var serverErrorsEvent;
    var debugPrintEvent;
    var heartBeatTimer;
    var heartBeatWebsocketTimer;
    var hbRetryCount = 0;
	var secureMode = false;
	var httpUrlPrefix = "http";
    this.heartBeatTime = heartBeatTime;
    this.init = init;
    this.login = login;
    this.logout = logout;
    this.Relogin = Relogin;
    this.MakeCall = MakeCall;
    this.AnswerCall = AnswerCall;
    this.DropCall = DropCall;
    this.Transfer = Transfer;
    this.ConsultationTransfer = ConsultationTransfer;
    this.TransferComplete = TransferComplete;
    this.Hold = Hold;
    this.UnHold = UnHold;
    this.Conference = Conference;
    this.MuteUnmute = MuteUnmute;
    this.setServerIpAddress = setServerIpAddress;
    this.getServerIpAddress = getServerIpAddress;
    this.getPrimaryServerIpAddress = getPrimaryServerIpAddress;
    this.getSecondaryServerIpAddress = getSecondaryServerIpAddress;
    this.setServerPort = setServerPort;
    this.getUserExtension = getUserExtension;
    this.getLastLogedinUserName = getLastLogedinUserName;
    this.SendDTMFDigit = SendDTMFDigit;
    this.GetDirectory = GetDirectory;

    function init(callbackList)
    {
        ipoJsonStringsObject = new ipoJsonStrings();
        loginEvent = callbackList.loginCallback;
        incomingCallEvent = callbackList.incomingCallCallback;
        alertingCallEvent = callbackList.alertingCallCallback;
        failedCallEvent = callbackList.failedCallCallback;
        connectedCallEvent = callbackList.connectedCallCallback;
        consultedCallEvent = callbackList.consultedCallCallback;
        clearedCallEvent = callbackList.clearedCallCallback;
        heldCallEvent = callbackList.heldCallback;
        muteUnmuteCallEvent = callbackList.muteUnmuteCallback;
        transferEvent = callbackList.transferCallback;
        conferenceEvent = callbackList.conferenceCallback;
        logoffEvent = callbackList.logoffCallback;
        dndEvent = callbackList.dndCallback;
        serverErrorsEvent = callbackList.serverErrorsCallback;
        debugPrintEvent = callbackList.debugPrintCallback;
        showMessageEvent = callbackList.showMessageCallback;
		getDirectoryContactsCallback = callbackList.getDirectoryContactsCallback;
    }

    function createWebSocketConnection(hostIP, portNumber, sessionId) {
        try {
            var wsURL = "ws://" + hostIP + ":" + portNumber + "/inyama/openapiwebsocket/" + sessionId;
            createWebSocketConnectionByURL(wsURL);
        }
        catch (e) {
            logErrorWarnings("ERROR_createWebSocketConnection: " + e);
        }
    }

    function setServerIpAddress(serverIp) {
        if (serverIPAddress == '') {
            primaryServerIPAddress = serverIp;
            secondaryServerIPAddress = serverIp;
        }
        serverIPAddress = serverIp;
    }

    function getServerIpAddress() {
        return serverIPAddress;
    }

    function getPrimaryServerIpAddress() {
        return primaryServerIPAddress;
    }

    function getSecondaryServerIpAddress() {
        return secondaryServerIPAddress;
    }

    function setServerPort(serverPort) {
        serverPortNumber = serverPort;
		if (serverPort == 9443) {
			secureMode = true;
			httpUrlPrefix = "https";
		}
		if (serverPort == 8080) {
			secureMode = false;
			httpUrlPrefix = "http";
		}
		//alert(serverPortNumber+httpUrlPrefix+secureMode);
    }

    function getUserExtension() {
        return userExtension;
    }
    
    function getLastLogedinUserName() {
        return usernameCached;
    }

    function Relogin() {
        if (lastIPAddrAttempted == serverIPAddress) {
            if (lastIPAddrAttempted == primaryServerIPAddress) {
                serverIPAddress = secondaryServerIPAddress;
            }
            else {
                serverIPAddress = primaryServerIPAddress;
            }
        }
        login(usernameCached, passwordCached);
    }

    function login(username, password) {
        try {
            usernameCached = username;
            passwordCached = password;
            lastIPAddrAttempted = serverIPAddress;
            var loginRequestPayload = ipoJsonStringsObject.getLoginPayload(username, password);
            clientSessionId = "";
            jQuery.ajax({
                //url: "http://" + serverIPAddress + ":" + serverPortNumber + "/inyama/service/session",
                url: httpUrlPrefix+"://" + serverIPAddress + ":" + serverPortNumber + "/inyama/service/session",
                type: "POST",
                data: loginRequestPayload,
                dataType: "json",
                //crossDomain: true,
                timeout: 15000,
				
                contentType: "text/json;charset=UTF-8"
				
				/*
                contentType: "text/json;charset=UTF-8",
                beforeSend: function (request) {
                    request.setRequestHeader('Access-Control-Allow-Origin', '*');
                    //request.setRequestHeader("X-User-Agent", "SalesForce");
                }
				*/
				
				
				/*
                contentType: "text/json;charset=UTF-8",
                beforeSend: function (request) {
                    request.setRequestHeader('Access-Control-Allow-Origin', '*');
                    request.setRequestHeader("X-User-Agent", "SalesForce");
                }
				*/
            })
            .done(function (data, textStatus, jqXHR) {
                try {
                    confPrimaryID = '';
                    debugPrintEvent(jqXHR.responseText);
                    var objJson = jQuery.parseJSON(jqXHR.responseText);
                    if (objJson != null) {
                        var loginFailureCode = objJson.UserLoginResponse.loginFailureCode;
                        var requestStatus = jqXHR.statusText;
                        if (requestStatus == "Accepted" || requestStatus == "OK") {
                            if (loginFailureCode == "NONE") {
								if (secureMode) {
									serverWebSocketURL = objJson.UserLoginResponse.webSocketWssUrl;
								} else {
									serverWebSocketURL = objJson.UserLoginResponse.webSocketWsUrl;
								}
								//serverWebSocketURL = serverWebSocketURL + "?clientName=JSSampleClient&clientVersion=1.0";
								serverWebSocketURL = serverWebSocketURL + "?heartbeat=true";
                                clientSessionId = objJson.UserLoginResponse.clientSessionID;
                                userSwitchDevice = objJson.UserLoginResponse.userSwitchDevice;
                                ipoJsonStringsObject.setSwitchDevice(userSwitchDevice);
                                userName = objJson.UserLoginResponse.userName;
                                userExtension = objJson.UserLoginResponse.userExtension;
                                createWebSocketConnectionByURL(serverWebSocketURL);
                                try {
                                    primaryServerIPAddress = objJson.UserLoginResponse.haConfiguration.primaryServer;
                                    secondaryServerIPAddress = objJson.UserLoginResponse.haConfiguration.secondaryServer;
                                } catch (e) {
                                    primaryServerIPAddress = serverIPAddress;
                                    secondaryServerIPAddress = serverIPAddress;
                                }
                            }
                            else {//Login Failure.
                                HandleLoginFailure(requestStatus, loginFailureCode, null);
                            }
                        }
                    }
                } catch (e) {
                    logErrorWarnings("ERROR_login_Success: " + e);
                }
            })
            .fail(function (jqXHR, textStatus, errorThrown) {
                try {
                    if (jqXHR.responseText != null) {
                        var objJson = jQuery.parseJSON(jqXHR.responseText);
                        if (objJson != null) {
                            var requestStatus = jqXHR.statusText;
                            HandleLoginFailure(requestStatus, "", jqXHR.responseJSON);
                        }
                    }
                    else {//textStatus == "error"//
                        loginEvent({ "Status": "Error Occurred." });
                    }
                } catch (e) {
                    logErrorWarnings("ERROR_login_Error: " + e);
                }
            })
            .always(function (jqXHROrData, textStatus, jqXHROrErrorThrown) {
                
            });
        } catch (e) {
            logErrorWarnings("ERROR_login: " + e);
        }
    }

    function HandleLoginFailure(requestStatus, loginFailureCode, responseJSON) {
        logErrorWarnings("ERROR_HandleLoginFailure: " + requestStatus);

        if (requestStatus == "Unauthorized" ||
                requestStatus == "InternalServerError" || requestStatus == "Internal Server Error" ||
                requestStatus == "ServiceUnavailable" || requestStatus == "Service Unavailable" || requestStatus == "Moved Permanently") {
            if (responseJSON != null && responseJSON.Error != null) {
                loginFailureCode = responseJSON.Error.errorCode;
                if (responseJSON.Error.errorCode == "UNSUPPORTED_APPLICATION_VERSION") {
                    loginEvent({ "Status": "Unsupported Application Version : " + responseJSON.Error.errorValue});
                }
                else if (responseJSON.Error.errorCode =="INVALID_CREDENTIALS"){
                    loginEvent({ "Status": "Invalid Credentials Entered." });
                }
                else if (responseJSON.Error.errorCode == "SYSTEM_STARTUP_IN_PROGRESS") {
                    loginEvent({ "Status": "Service Unavailable. Please try after some time." });
                }
                else if (responseJSON.Error.errorCode == "CSTA_PROVIDER_DOWN" || responseJSON.Error.errorCode == "SYSTEM_UNPROVISIONED") {
                    loginEvent({ "Status": "Service Unavailable. Please contact System Administrator." });
                }
                else if (responseJSON.Error.errorCode == "SERVICE_REDIRECTED") {//if connecting to secondary while primary is already up and running. So reconnect to Primary.
                    secondaryServerIPAddress = serverIPAddress;
                    serverIPAddress = responseJSON.Error.errorValue;//Primary IP Address.
                    primaryServerIPAddress = serverIPAddress;
                    logoffEvent({ "Reason": "SERVICE_REDIRECTED" });
                }
                else {
                    loginEvent({ "Status": "Login Error Occurred " + responseJSON.Error.errorCode });
                }
            }
            else {
                if (requestStatus == "Unauthorized") {
                    loginEvent({ "Status": "Unauthorized Login Request." });
                }
                else if (requestStatus == "InternalServerError" || requestStatus == "Internal Server Error") {
                    loginEvent({ "Status": "Internal Server Error Occured." });
                }
                else if (requestStatus == "ServiceUnavailable" || requestStatus == "Service Unavailable") {
                    loginEvent({ "Status": "Service Unavailable. Please ensure 1xPortal server is up and running." });
                }
            }
        }
        else {
            loginEvent({ "Status": "Login failed with failure code :" + loginFailureCode });
        }
    }

    function logout() {
        try {
            webSocketCloseRequested = true;
            jQuery.ajax({
                //url: "http://" + serverIPAddress + ":" + serverPortNumber + "/inyama/service/session",
                url: httpUrlPrefix+"://" + serverIPAddress + ":" + serverPortNumber + "/inyama/service/session",
				
                type: "DELETE",
                beforeSend: function (request) {
                    request.setRequestHeader("ClientSessionId", clientSessionId);
                }
				
				/*
                type: "DELETE",
                beforeSend: function (request) {
                    request.setRequestHeader('Access-Control-Allow-Origin', '*');
                    //request.setRequestHeader("X-User-Agent", "SalesForce");
                    request.setRequestHeader("ClientSessionId", clientSessionId);
                }
				*/
            })
            .done(function (data, textStatus, jqXHR) {
                try {
                    debugPrintEvent("Logout Successful.");
                    heartBeatClearTimer();
                    clientSessionId = "";
                    closeWebSocket();
                    logoffEvent({ "Reason": "Success" });
                    confPrimaryID = "";

                } catch (e) {
                    logErrorWarnings("ERROR_logout_Success: " + e);
                }
            })
            .fail(function (jqXHR, textStatus, errorThrown) {
                try {
                    debugPrintEvent("Logout Failed.");
                    logErrorWarnings("ERROR_logout_ErrorThrown: " + errorThrown);
                } catch (e) {
                    logErrorWarnings("ERROR_logout_Error: " + e);
                }
            });
        } catch (e) {
            webSocketCloseRequested = false;
            logErrorWarnings("ERROR_logout: " + e);
        }
    }

    function GetDirectory() {
        try {
            jQuery.ajax({
                //url: "https://" + serverIPAddress + ":" + serverPortNumber + "/inyama/service/directory/system",
                //url: "http://" + serverIPAddress + ":" + serverPortNumber + "/inyama/service/directory/personal",
                url: httpUrlPrefix+"://" + serverIPAddress + ":" + serverPortNumber + "/inyama/service/directory/system",
                //Surl: httpUrlPrefix+"://" + serverIPAddress + ":" + serverPortNumber + "/inyama/service/directory/personal",
                type: "GET",
                data: null,
                dataType: "json",
                //crossDomain: false,
                timeout: 15000,
                contentType: "text/json;charset=UTF-8",
                beforeSend: function (request) {
                    request.setRequestHeader("ClientSessionId", clientSessionId);
                }
				

				/*
                contentType: "text/json;charset=UTF-8",
                beforeSend: function (request) {
                    request.setRequestHeader('Access-Control-Allow-Origin', '*');
                    //request.setRequestHeader("X-User-Agent", "SalesForce");
                    request.setRequestHeader("ClientSessionId", clientSessionId);
               }
			   */
				
            })
            .done(function (data, textStatus, jqXHR) {
                try {
                    confPrimaryID = '';
                    debugPrintEvent(jqXHR.responseText);
                    var objJson = jQuery.parseJSON(jqXHR.responseText);
                    if (objJson != null) {
                        var requestStatus = jqXHR.statusText;
                        if (requestStatus == "Accepted" || requestStatus == "OK") {
                            getDirectoryContactsCallback(jqXHR.responseText);                           
                        }
                    }
                } catch (e) {
                    logErrorWarnings("ERROR_GetDirectory_Success: " + e);
                }
            })
            .fail(function (jqXHR, textStatus, errorThrown) {
                try {
                    if (jqXHR.responseText != null) {
                        var objJson = jQuery.parseJSON(jqXHR.responseText);
                        if (objJson != null) {
                            var requestStatus = jqXHR.statusText;
                            logErrorWarnings(requestStatus.toString());
                             getDirectoryContactsCallback(jqXHR.responseText);
                       }
                    }
                    else {
                        logErrorWarnings("Error Occurred..." + textStatus.toString());
                    }
                } catch (e) {
                    logErrorWarnings("ERROR_GetDirectory_Error: " + e);
                }
            })
            .always(function (jqXHROrData, textStatus, jqXHROrErrorThrown) {

            });
        } catch (e) {
            logErrorWarnings("ERROR_GetDirectory: " + e);
        }
    }

    function MakeCall(number) {
        var jsonMakeCallPayload = ipoJsonStringsObject.getMakeCallPayload(userExtension, number);
        callControlRequest("MakeCall", jsonMakeCallPayload);
    }

    function AnswerCall(call_session_data) {
        var jsonAnswerCallPayload = ipoJsonStringsObject.getAnswerCallPayload(call_session_data.connection_id);
        callControlRequest("AnswerCall", jsonAnswerCallPayload);
    }

    function DropCall(call_session_data) {
        var jsonDropCallPayload = ipoJsonStringsObject.getDropCallPayload(call_session_data.connection_id);
        callControlRequest("ClearConnection", jsonDropCallPayload);
    }

    function Hold(call_session_data) {
        var jsonHoldCallPayload = ipoJsonStringsObject.getHoldCallPayload(call_session_data.connection_id);
        callControlRequest("HoldCall", jsonHoldCallPayload);
    }

    function UnHold(call_session_data, other_call_session_data) {
        if (other_call_session_data == null) {
            var jsonRetrieveCallPayload = ipoJsonStringsObject.getUnHoldCallPayload(call_session_data.connection_id);
            callControlRequest("RetrieveCall", jsonRetrieveCallPayload);
        }
        else {
            if (call_session_data.isHeld && other_call_session_data.isHeld) {
                var jsonRetrieveCallPayload = ipoJsonStringsObject.getUnHoldCallPayload(call_session_data.connection_id);
                callControlRequest("RetrieveCall", jsonRetrieveCallPayload);
            }
            else {
                var jsonAlternateCallPayload = ipoJsonStringsObject.getAlternateCallPayload(call_session_data.connection_id, other_call_session_data.connection_id);
                callControlRequest("AlternateCall", jsonAlternateCallPayload);
            }
        }
    }

    function Conference(active_call_session_data, held_call_session_data) {
        var jsonConferenceCallPayload = ipoJsonStringsObject.getConferenceCallPayload(held_call_session_data.connection_id, active_call_session_data.connection_id);
        callControlRequest("ConferenceCall", jsonConferenceCallPayload);
    }

    function MuteUnmute(call_session_data) {
        var jsonPayload = ipoJsonStringsObject.getMuteUnmuteCallPayload(call_session_data.connection_id, call_session_data.isMuted);
        callMuteUnMuteRequest("SetMicrophoneMute", jsonPayload);
    }

    function Transfer(call_session_data, toNumber) {
        var jsonTransferCallPayload = ipoJsonStringsObject.getTransferCallPayload(call_session_data.connection_id, toNumber);
        callControlRequest("SingleStepTransferCall", jsonTransferCallPayload);
    }

    function ConsultationTransfer(call_session_data, consultNumber) {
        var jsonConsultationTransferCallPayload = ipoJsonStringsObject.getConsultationCallPayload(call_session_data.connection_id, consultNumber);
        callControlRequest("ConsultationCall", jsonConsultationTransferCallPayload);
    }

    function TransferComplete(held_call_session_data, active_call_session_data) {
        var jsonCompleteTransferCallPayload = ipoJsonStringsObject.getTransferCompleteCallPayload(held_call_session_data.connection_id, active_call_session_data.connection_id);
        callControlRequest("TransferCall", jsonCompleteTransferCallPayload);
    }

    function SendDTMFDigit(call_session_data, digits) {
        var jsonDtmfPayload = ipoJsonStringsObject.getJsonDtmfPayload(call_session_data.connection_id, digits);
        callControlRequest("generatedtmf", jsonDtmfPayload);
    }

    function RequestDeviceSnapshot() {
        var jsonSnapshotPayload = ipoJsonStringsObject.getJsonSnapshotPayload(userExtension);
        getDeviceSnapshot(jsonSnapshotPayload);
    }

    function callControlRequest(requestType, jsonMessage) {
        try {
            jQuery.ajax({
                //url: "http://" + serverIPAddress + ":" + serverPortNumber + "/inyama/service/callcontrol/" + requestType,
                url: httpUrlPrefix+"://" + serverIPAddress + ":" + serverPortNumber + "/inyama/service/callcontrol/" + requestType,
                type: "POST",
                data: jsonMessage,
                dataType: "json",
                contentType: "text/json;charset=UTF-8",
                beforeSend: function (request) {
                    request.setRequestHeader("ClientSessionId", clientSessionId);
                }
				
				/*
                contentType: "text/json;charset=UTF-8",
                beforeSend: function (request) {
                    request.setRequestHeader('Access-Control-Allow-Origin', '*');
                    //request.setRequestHeader("X-User-Agent", "SalesForce");
                    request.setRequestHeader("ClientSessionId", clientSessionId);
                }
				*/
            })
            .done(function (data, textStatus, jqXHR) {
                try {

                    debugPrintEvent(jqXHR.responseText);
                    var jsonString = jqXHR.responseText;
                } catch (e) {
                    logErrorWarnings("ERROR_callControlRequest_Success: " + e);
                }
            })
            .fail(function (jqXHR, textStatus, errorThrown) {
                try {

                    logErrorWarnings("ERROR_callControlRequest_ErrorThrown: " + errorThrown);
                } catch (e) {
                    logErrorWarnings("ERROR_callControlRequest_Error: " + e);
                }
            });
        } catch (e) {
            logErrorWarnings("ERROR_callControlRequest: " + e);
        }
        return null;
    }

    function callMuteUnMuteRequest(requestType, jsonMessage) {
        try {
            jQuery.ajax({
                //url: "http://" + serverIPAddress + ":" + serverPortNumber + "/inyama/service/physicaldevice/" + requestType,
                url: httpUrlPrefix+"://" + serverIPAddress + ":" + serverPortNumber + "/inyama/service/physicaldevice/" + requestType,
                type: "POST",
                data: jsonMessage,
                dataType: "json",
                contentType: "text/json;charset=UTF-8",
                beforeSend: function (request) {
                    request.setRequestHeader("ClientSessionId", clientSessionId);
                }
				
				/*
                contentType: "text/json;charset=UTF-8",
                beforeSend: function (request) {
                    request.setRequestHeader('Access-Control-Allow-Origin', '*');
                    //request.setRequestHeader("X-User-Agent", "SalesForce");
                    request.setRequestHeader("ClientSessionId", clientSessionId);
                }
				*/
            })
            .done(function (data, textStatus, jqXHR) {
                try {

                    debugPrintEvent(jqXHR.responseText);
                    var jsonString = jqXHR.responseText;
                } catch (e) {
                    logErrorWarnings("ERROR_callMuteUnMuteRequest_Success: " + e);
                }
            })
            .fail(function (jqXHR, textStatus, errorThrown) {
                try {

                    logErrorWarnings("ERROR_callMuteUnMuteRequest_ErrorThrown: " + errorThrown);
                } catch (e) {
                    logErrorWarnings("ERROR_callMuteUnMuteRequest_Error: " + e);
                }
            });
        } catch (e) {
            logErrorWarnings("ERROR_callMuteUnMuteRequest: " + e);
        }
        return null;
    }

    function sendHeartBeat() {
        try {
            jQuery.ajax({
                //url: "http://" + serverIPAddress + ":" + serverPortNumber + "/inyama/service/session/heartbeat",
                url: httpUrlPrefix+"://" + serverIPAddress + ":" + serverPortNumber + "/inyama/service/session/heartbeat",
                type: "POST",
                data: null,
                dataType: "json",
                contentType: "text/json;charset=UTF-8",
                beforeSend: function (request) {
                    request.setRequestHeader("ClientSessionId", clientSessionId);
                }
				
				/*
                contentType: "text/json;charset=UTF-8",
                beforeSend: function (request) {
                    request.setRequestHeader('Access-Control-Allow-Origin', '*');
                    //request.setRequestHeader("X-User-Agent", "SalesForce");
                    request.setRequestHeader("ClientSessionId", clientSessionId);
                }
				*/
            })
            .done(function (data, textStatus, jqXHR) {
                try {
                    handleHeartBeatResponse(jqXHR.statusText);
                } catch (e) {
                    logErrorWarnings("ERROR_sendHeartBeat_Success: " + e);
                }
            })
            .fail(function (jqXHR, textStatus, errorThrown) {
                try {
                    handleHeartBeatResponse(jqXHR.statusText);
                } catch (e) {
                    logErrorWarnings("ERROR_sendHeartBeat_Error: " + e);
                }
            });
        } catch (e) {
            logErrorWarnings("ERROR_sendHeartBeat: " + e);
        }
        return null;
    }

    function sendWebsocketHeartBeat() {
        try {
			var msg = "Websocket Heartbeat";
			sendWebSocketMessage(msg);
        } catch (e) {
            logErrorWarnings("ERROR_sendWebsocketHeartBeat: " + e);
        }
        return null;
    }
	
    function getDeviceSnapshot(jsonMessage) {
        try {
            jQuery.ajax({
                //url: "http://" + serverIPAddress + ":" + serverPortNumber + "/inyama/service/snapshot",
                url: httpUrlPrefix+"://" + serverIPAddress + ":" + serverPortNumber + "/inyama/service/snapshot",
                type: "GET",
                data: null,
                dataType: "json",
                contentType: "text/json;charset=UTF-8",
                beforeSend: function (request) {
                    request.setRequestHeader("ClientSessionId", clientSessionId);
                }
				/*
                contentType: "text/json;charset=UTF-8",
                beforeSend: function (request) {
                    request.setRequestHeader('Access-Control-Allow-Origin', '*');
                    //request.setRequestHeader("X-User-Agent", "SalesForce");
                    request.setRequestHeader("ClientSessionId", clientSessionId);
                }
				*/
            })
            .done(function (data, textStatus, jqXHR) {
                try {
                    debugPrintEvent(jqXHR.responseText);
                    var jsonString = jqXHR.responseText;
                } catch (e) {
                    logErrorWarnings("ERROR_getDeviceSnapshot_Success: " + e);
                }
            })
            .fail(function (jqXHR, textStatus, errorThrown) {
                try {
                    logErrorWarnings("ERROR_getDeviceSnapshot_ErrorThrown: " + errorThrown);
                } catch (e) {
                    logErrorWarnings("ERROR_getDeviceSnapshot_Error: " + e);
                }
            });
        } catch (e) {
            logErrorWarnings("ERROR_getDeviceSnapshot: " + e);
        }
        return null;
    }

    function createWebSocketConnectionByURL(wsURL) {
        try {
            console.log(wsURL);
            needToTrackWebSocket = true;
            webSocketCloseRequested = false;
            webSocketConn = new WebSocket(wsURL);
            webSocketConn.onopen = onSocketOpen;
            webSocketConn.onclose = onSocketClose;
            webSocketConn.onmessage = handleServerResponse;
            webSocketConn.onerror = onSocketError;
        }
        catch (e) {
            needToTrackWebSocket = false;
            logErrorWarnings("ERROR_createWebSocketConnection: " + e);
        }
    }

	function sendWebSocketMessage(msg) {
        try {
            console.log("sending to websocket "+msg);
            webSocketConn.send(msg);
        }
        catch (e) {
            logErrorWarnings("ERROR_sendWebSocketMessage: " + e);
        }
		
	}
	
    var onSocketOpen = function (ev) {
        try {
            needToTrackWebSocket = false;
            if (webSocketConn && webSocketConn.readyState == 1) {
                isWebSocketOpen = true;
                heartBeatStartTimer();
                heartBeatWebsocketStartTimer();
                loginEvent({ "Status": "Success" });
                logErrorWarnings('WebSocket Opened');
                RequestDeviceSnapshot();
            }
            else {
                loginEvent({ "Status": "Failed - WebSocket Not Opened." });
            }
        }
        catch (e) {
            logErrorWarnings("ERROR_onSocketOpen: " + e);
        }
    }

    var onSocketClose = function (ev) {
        try {
            isWebSocketOpen = false;
            logErrorWarnings('WebSocket Closed');
            if (needToTrackWebSocket == true) {
                needToTrackWebSocket = false;
                logErrorWarnings('WebSocket Closed Before Opening... WebSocket ERROR.');
                logoffEvent({ "Reason": "WEB_SOCKET_FAILED" });
            }
            else if (webSocketCloseRequested == false) {
                logErrorWarnings('WebSocket got closed due to unknown reason... WebSocket ERROR.');
                logoffEvent({ "Reason": "WEB_SOCKET_CLOSED" });
            }
            webSocketCloseRequested = false;
            heartBeatClearTimer();
        }
        catch (e) {
            webSocketCloseRequested = false;
            logErrorWarnings("ERROR_onSocketClose: " + e);
        }
    }

    function closeWebSocket() {
        try {
            needToTrackWebSocket = false;
            webSocketCloseRequested = true;
            webSocketConn.close();
        } catch (e) {
            webSocketCloseRequested = false;
            logErrorWarnings("ERROR_closeWebSocket: " + e);
        }
    }

    var onSocketError = function (ev) {
        try {
            logErrorWarnings('WebSocket ERROR: ' + ev.data);
        }
        catch (e) {
            logErrorWarnings("ERROR_onSocketError: " + e);
        }
    }

    var handleServerResponse = function (ev) {
        try {
            var callSessionData;
            debugPrintEvent(ev.data);
            var data = jQuery.parseJSON(ev.data);
            var eventType = Object.keys(data)[0];

            switch (eventType) {
                case "CommonDeliveredEvent": {
                    var callId = data.CommonDeliveredEvent.connection.callID;
                    var calling = data.CommonDeliveredEvent.callingDevice.deviceIdentifier.value;
                    var called = data.CommonDeliveredEvent.calledDevice.deviceIdentifier.value;
                    var callingPartyName ='';
                    var calledPartyName ='';
                    var additionalCallInfo = data.CommonDeliveredEvent.extensions.privateData.private.any[0];
                    if (additionalCallInfo != null) {
                        callingPartyName = additionalCallInfo.any.callingPartyInfo.callerName;
                        calledPartyName = additionalCallInfo.any.calledPartyInfo.callerName;
                    }
                    if (data.CommonDeliveredEvent.callLinkageData.globalCallData.globalCallLinkageID.globallyUniqueCallLinkageID == callId) {
                        callSessionData = getCallSessionData(callId, true);
                        if (callSessionData != null) {
                            callSessionData.connection_id = callId;
                            if (data.CommonDeliveredEvent.localConnectionInfo == 'ALERTING') {
                                if (calling == '' && calling == userExtension) {
                                    callSessionData.setNameNumber(calledPartyName, called);
                                    callSessionData.call_direction = callSessionData.direction_outgoing;
                                    alertingCallEvent(callSessionData);
                                }
                                else {
                                    callSessionData.setNameNumber(callingPartyName, calling);
                                    callSessionData.call_direction = callSessionData.direction_incoming;
                                    incomingCallEvent(callSessionData);
                                }
                            }
                            else {//'CONNECTED'//
                                callSessionData.setNameNumber(calledPartyName, called);
                                callSessionData.call_direction = callSessionData.direction_outgoing;
                                alertingCallEvent(callSessionData);
                            }
                        }
                    }
                    else {//Consulted Call
                        call_3_session_data = new CallSessionData();
                        call_3_session_data.connection_id = callId;
                        call_1_session_data.callAppearanceNo = 3;
                        call_3_session_data.isConsultationCall = true;
                        call_3_session_data.setNameNumber(calledPartyName, called);
                        call_3_session_data.call_direction = call_3_session_data.direction_outgoing;
                        consultedCallEvent(call_3_session_data);
                    }
                    break;
                }
                case "CommonEstablishedEvent": {
                    var callingPartyName = '';
                    var calledPartyName = '';
                    var callId = data.CommonEstablishedEvent.establishedConnection.callID;
                    if (data.CommonEstablishedEvent.callLinkageData.globalCallData.globalCallLinkageID.globallyUniqueCallLinkageID == callId) {
                        callSessionData = getCallSessionData(callId, true);
                        if (callSessionData != null) {
                            callSessionData.connection_id = callId;
                            callSessionData.isAnswered = true;
                            try {
                                var calling = data.CommonEstablishedEvent.callingDevice.deviceIdentifier.value;
                                var called = data.CommonEstablishedEvent.calledDevice.deviceIdentifier.value;
                                var lastRedirected = data.CommonEstablishedEvent.lastRedirectionDevice.numberDialed.value;

                                var additionalCallInfo = data.CommonEstablishedEvent.extensions.privateData.private.any[3];
                                if (additionalCallInfo != null) {
                                    callingPartyName = additionalCallInfo.any.callingPartyInfo.callerName;
                                    calledPartyName = additionalCallInfo.any.calledPartyInfo.callerName;
                                }
                                if (lastRedirected !== '') {//To handle call pickup case (Shortcode:*30)
                                    callSessionData.setNameNumber(called + ">" + calledPartyName, called);
                                }
                                if (called.toString().charCodeAt(0) == 35 || called == 'Voicemail') {
                                    callSessionData.name = called;
                                    if (called == 'Voicemail') {
                                        callSessionData.number = called;
                                    }
                                }
                                else {
                                    if (callSessionData.number == '') {//Patch-Handle established after auto answer in ACW.
                                        callSessionData.setNameNumber(callingPartyName, calling);
                                    }
                                }
                            } catch (e) {
                            }
                            var additionalCallInfo = data.CommonEstablishedEvent.extensions.privateData.private.any[2];
                            if (additionalCallInfo != null && additionalCallInfo.intValue == 3 && additionalCallInfo.booleanFlag == true) {
                                confPrimaryID = callId;
                            }
                            connectedCallEvent(callSessionData);
                        }
                    }
                    else {//Consulted Call
                        if (call_3_session_data != null) {
                            call_3_session_data.isAnswered = true;
                            consultedCallEvent(call_3_session_data);
                        }
                    }
                    break;
                }
                case "CommonConnectionClearedEvent": {
                    var callId = data.CommonConnectionClearedEvent.droppedConnection.callID;
                    callSessionData = getCallSessionData(callId, false);
                    if (callSessionData != null) {
                        callSessionData.connection_id = callId;
                        callSessionData.isAnswered = false;
                        if (callSessionData.isConference == true) {
                            if (callSessionData.callAppearanceNo == 1) {
                                conferencesCleared[0] = callId;
                            }
                            else if (callSessionData.callAppearanceNo == 2) {
                                conferencesCleared[1] = callId;
                            }
                        }
                        clearedCallEvent(callSessionData);
                    }
                    break;
                }
                case "CommonFailedEvent": {
                    var callId = data.CommonFailedEvent.failedConnection.callID;
                    var calling = data.CommonFailedEvent.callingDevice.deviceIdentifier.value;
                    var called = data.CommonFailedEvent.calledDevice.deviceIdentifier.value;

                    callSessionData = getCallSessionData(callId, true);
                    if (callSessionData != null) {
                        callSessionData.connection_id = callId;
                        callSessionData.name = called;
                        callSessionData.number = 'Call Failed';
                        callSessionData.call_direction = callSessionData.direction_outgoing;
                        callSessionData.isFailed = true;
                        failedCallEvent(callSessionData);
                    }
                    break;
                }
                case "CommonHeldEvent": {
                    var callId = data.CommonHeldEvent.heldConnection.callID;
                    callSessionData = getCallSessionData(callId, false);
                    if (callSessionData != null) {
                        callSessionData.isHeld = true;
                        heldCallEvent(callSessionData);
                    }
                    break;
                }
                case "CommonRetrievedEvent": {
                    var callId = data.CommonRetrievedEvent.retrievedConnection.callID;
                    callSessionData = getCallSessionData(callId, false);
                    if (callSessionData != null) {
                        callSessionData.isHeld = false;
                        heldCallEvent(callSessionData);
                    }
                    break;
                }
                case "CommonMicrophoneMuteEvent": {
                    var callId = data.CommonMicrophoneMuteEvent.invokingDevice.deviceIdentifier.value;
                    callSessionData = getCallSessionData(callId, false);
                    if (callSessionData != null) {
                        if (data.CommonMicrophoneMuteEvent.microphoneMuteOn) {
                            callSessionData.isMuted = true;
                        }
                        else {
                            callSessionData.isMuted = false;
                        }
                        muteUnmuteCallEvent(callSessionData);
                    }
                    break;
                }
                case "LogoutEvent": {
                    heartBeatClearTimer();
                    closeWebSocket();
                    logoffEvent({ "Reason": data.LogoutEvent.logoutReason });
                    break;
                }
                case "CommonOutOfServiceEvent":{
                    heartBeatClearTimer();
                    closeWebSocket();
                    logoffEvent({ "Reason": "OutOfService" });
                    break;
                }
                case "HASwitchEvent": {
                    heartBeatClearTimer();
                    closeWebSocket();
                    logoffEvent({ "Reason": "PrimaryServerUp" });
                    break;
                }
                case "CommonConferencedEvent": {
                    var confId = ipoJsonStringsObject.Base64Decode(data.CommonConferencedEvent.correlatorData.string);
                    var confName = ipoJsonStringsObject.Base64Decode(data.CommonConferencedEvent.userData.string);
                    if (data.CommonConferencedEvent.conferenceConnections != null && data.CommonConferencedEvent.conferenceConnections.connectionListItem.length > 0) {
                        if (confPrimaryID == conferencesCleared[0]) {
                            conferencesCleared[0] = null;
                            break;
                        }
                        if (confPrimaryID == conferencesCleared[1]) {
                            conferencesCleared[1] = null;
                            break;
                        }
                        if (confId == conferencesCleared[0]) {
                            conferencesCleared[0] = null;
                            break;
                        }
                        if (confId == conferencesCleared[1]) {
                            conferencesCleared[1] = null;
                            break;
                        }
                        if (confPrimaryID == '') {//confPrimaryID is blank after login. Required when conf event comes after immediately login.
                            var confPrimaryOldCallId = data.CommonConferencedEvent.primaryOldCall.callID;
                            if (confPrimaryOldCallId != null && confPrimaryOldCallId !== '') {
                                confPrimaryID = confPrimaryOldCallId;
                                logErrorWarnings("Conferenced Primary: " + confPrimaryID);
                            }
                        }
                        callSessionData = getCallSessionData(confPrimaryID, false);
                        if (callSessionData === null) {
                            callSessionData = getCallSessionData(confId, true);
                            if (callSessionData != null) {
                                if (confPrimaryID == '') {
                                    callSessionData.connection_id = confId;
                                }
                                else {
                                    callSessionData.connection_id = confPrimaryID;
                                }
                            }
                        }
                        if (callSessionData != null) {
                            callSessionData.name = confName;
                            callSessionData.number = confName.split(" ")[1];
                            callSessionData.isConference = true;
                            conferenceEvent(callSessionData);
                        }
                    }
                    else {// Conference is already ended.
                        callSessionData = getCallSessionData(confPrimaryID, false);
                        if (callSessionData === null) {
                            callSessionData = getCallSessionData(confId, false);
                        }
                        if (callSessionData != null) {
                            clearedCallEvent(callSessionData);
                        }
                    }
                    break;
                }
                case "TelephonyPresenceEvent": {
                    var extn_no = data.TelephonyPresenceEvent.telephonyPresence.forDevice;
                    if (userExtension == extn_no) {
                        var dnd = data.TelephonyPresenceEvent.telephonyPresence.dndon;
                        dndEvent(dnd);
                    }
                    break;
                }
                case "CommonCallInformationEvent": {
                    var callId = data.CommonCallInformationEvent.connection.callID;
                    var calling = data.CommonCallInformationEvent.callingDevice.deviceIdentifier.value;
                    var device = data.CommonCallInformationEvent.deviceInfo.value;
                    var callingPartyName = '';
                    var calledPartyName = '';
                    var additionalCallInfo = data.CommonCallInformationEvent.extensions.privateData.private.any[3];
                    if (additionalCallInfo != null) {
                        callingPartyName = additionalCallInfo.any.callingPartyInfo.callerName;
                        calledPartyName = additionalCallInfo.any.calledPartyInfo.callerName;
                    }
                    //if (data.CommonCallInformationEvent.callLinkageDataList.newCallLinkageData.globalCallData.globalCallLinkageID.globallyUniqueCallLinkageID == callId) {
                    callSessionData = getCallSessionData(callId, true);
                    if (callSessionData != null) {
                        callSessionData.connection_id = callId;
                        if (calling == userExtension) {
                            callSessionData.setNameNumber(calledPartyName, device);
                            callSessionData.call_direction = callSessionData.direction_outgoing;
                        }
                        else if (device == userExtension) {
                            callSessionData.setNameNumber(callingPartyName, calling);
                            callSessionData.call_direction = callSessionData.direction_incoming;
                        }
                        if (data.CommonCallInformationEvent.servicesPermitted.callControlServices != null) {
                            var isAnswered = !data.CommonCallInformationEvent.servicesPermitted.callControlServices.answerCall;
                            var isHeld = !data.CommonCallInformationEvent.servicesPermitted.callControlServices.holdCall && isAnswered;
                            if (isAnswered == false) {
                                incomingCallEvent(callSessionData);
                            }
                            else {
                                if (callSessionData.call_direction == callSessionData.direction_outgoing && isAnswered == true && isHeld == true) {
                                    alertingCallEvent(callSessionData);
                                }
                                else if (isHeld == true) {
                                    callSessionData.isHeld = true;
                                    heldCallEvent(callSessionData);
                                }
                                else {
                                    callSessionData.isAnswered = true;
                                    connectedCallEvent(callSessionData);
                                }
                            }
                        }
                        else {//Call control services null. UNEXPECTED. Showing call as connected might not be correct.
                            connectedCallEvent(callSessionData);
                        }
                        var additionalCallInfo = data.CommonCallInformationEvent.extensions.privateData.private.any[2];
                        if (additionalCallInfo != null && additionalCallInfo.intValue == 3 && additionalCallInfo.booleanFlag == true) {
                            confPrimaryID = callId;
                        }
                    }
                    //}
                    break;
                }
                default:
                    break;
            }
        }
        catch (e) {
            logErrorWarnings("ERROR_handleServerResponse: " + e);
        }
    }

    function getCallSessionData(callId, createNew) {
        var callSessionData = null;;
        if (call_1_session_data != null){
            if (callId == call_1_session_data.connection_id) {
                call_1_session_data.callAppearanceNo = 1;
                callSessionData = call_1_session_data;
            }
        }
        if (call_2_session_data != null && callSessionData == null) {
            if (callId == call_2_session_data.connection_id) {
                call_2_session_data.callAppearanceNo = 2;
                callSessionData = call_2_session_data;
            }
        }
        if(callSessionData === null && createNew == true){
            if (call_1_session_data === null){
                call_1_session_data = new CallSessionData();
                call_1_session_data.callAppearanceNo = 1;
                callSessionData = call_1_session_data;
            }
            else if (call_2_session_data === null){
                call_2_session_data = new CallSessionData();
                call_2_session_data.callAppearanceNo = 2;
                callSessionData = call_2_session_data;
            }
        }
        if (createNew == true && callSessionData === null) {
            try {
                if (call_1_session_data != null && call_2_session_data != null) {
                    showMessageEvent("Active Sessions", call_1_session_data.connection_id + "(" + call_1_session_data.number + ") And " + call_2_session_data.connection_id + "(" + call_2_session_data.number + ")");
                }
            } catch (e) {}
        }
        return callSessionData;
    }

    function heartBeatStartTimer() {
        if (heartBeatTimer !== null) {
            heartBeatClearTimer();
        }
        heartBeatTimer = setInterval(function () { return heartBeatTimerElapsed(); }, heartBeatTime * 1000);
    }

    function heartBeatClearTimer() {
        if (heartBeatTimer != null) {
            clearInterval(heartBeatTimer);
            heartBeatTimer = null;
        }
    }

    function heartBeatTimerElapsed() {
        sendHeartBeat();
    }

    function heartBeatWebsocketStartTimer() {
        if (heartBeatWebsocketTimer !== null) {
            heartBeatWebsocketClearTimer();
        }
        heartBeatWebsocketTimer = setInterval(function () { return heartBeatWebsocketTimerElapsed(); }, heartBeatWebsocketTime * 1000);
    }

    function heartBeatWebsocketClearTimer() {
        if (heartBeatWebsocketTimer != null) {
            clearInterval(heartBeatWebsocketTimer);
            heartBeatWebsocketTimer = null;
        }
    }

    function heartBeatWebsocketTimerElapsed() {
        sendWebsocketHeartBeat();
    }

    function handleHeartBeatResponse(statusText) {
        if (statusText == "Accepted" || statusText == "OK") {
            hbRetryCount = 0;
        }
        else {
            hbRetryCount++;
            logErrorWarnings("Heart Beat Fail Count : " + hbRetryCount.toString());
            if (hbRetryCount > 3) {
                heartBeatClearTimer();
                closeWebSocket();
                logoffEvent({ "Reason": "ServerNotResponding" });
                hbRetryCount = 0;
            }
        }
    }

    function logErrorWarnings(message) {
        try {
            debugPrintEvent(message);
        } catch (e) {
            alert("ERROR_logErrorWarnings: " + e);
        }
    }
}