﻿function ipoDialingRules() {
    var apply_dialing_rules = false;
    var no_to_dial_outside_line = "";
    var my_country_code = "";
    var my_area_code = "";
    var no_to_dial_longdistance_call = "";
    var no_to_dial_international_call = "";
    var internal_xtn_len = 0;
    var national_phone_no_len = 0;
    var include_area_code_for_call = false;

    this.init = init;
    this.applyDialingRules = applyDialingRules;

    function init(applyDialingRules,
                    noToDialOutsideLine,
                    myCountryCode,
                    myAreaCode,
                    noToDialLongdistanceCall,
                    noToDialInternationalCall,
                    internalXtnLen,
                    nationalPhoneNoLen,
                    includeAreaCodeForCall) {
        apply_dialing_rules = applyDialingRules;
        no_to_dial_outside_line = noToDialOutsideLine;
        my_country_code = myCountryCode;
        my_area_code = myAreaCode;
        no_to_dial_longdistance_call = noToDialLongdistanceCall
        no_to_dial_international_call = noToDialInternationalCall;
        internal_xtn_len = internalXtnLen;
        national_phone_no_len = nationalPhoneNoLen;
        include_area_code_for_call = includeAreaCodeForCall;
    }

    function applyDialingRules(rawPhNo) {
        //Do not apply rules when not selected.
        if (!apply_dialing_rules)
            return CleanTheNo(rawPhNo);

        if (!my_country_code.startsWith("+"))
            my_country_code = "+" + my_country_code;

        var area_code_in_no = null;

        var raw_no = rawPhNo;
        if (raw_no.indexOf("(") > -1 && raw_no.indexOf(")") > -1)
            area_code_in_no = raw_no.substr(raw_no.indexOf("(") + 1, raw_no.indexOf(")") - (raw_no.indexOf("(") + 1));
        else
            if (raw_no.indexOf("-") > -1)
                area_code_in_no = raw_no.substr(raw_no.indexOf("-") + 1, raw_no.lastIndexOf("-") - (raw_no.indexOf("-") + 1));
        var clean_no = CleanTheNo(raw_no);

        //Special case handling.
        if (clean_no.startsWith("1800"))
            return no_to_dial_outside_line + clean_no;

        if (clean_no.startsWith("+")) {
            //Check if is international or national.
           if (clean_no.startsWith(my_country_code)) {
                //Remove +91 and check rest of no with area code.
                var no_without_plus_country_code = clean_no.substr(my_country_code.length);
                //Check for city/area code.
                if (no_without_plus_country_code.startsWith(my_area_code)) {
                    if (include_area_code_for_call) {
                        //Make call with area code.
                        return no_to_dial_outside_line + no_without_plus_country_code;
                    }
                    else {
                        //Make call without area code.
                        var no_without_area_code = no_without_plus_country_code.substr(my_area_code.length);
                        return no_to_dial_outside_line + no_without_area_code;
                    }
                }
                else {
                    return no_to_dial_outside_line + no_to_dial_longdistance_call + no_without_plus_country_code;
                }
            }
            else {
                return no_to_dial_outside_line + no_to_dial_international_call + clean_no.substr(1);
            }
        }
        else {
            if (internal_xtn_len == clean_no.length) {
                //Its an xtn call.
                return clean_no;
            }
            else {
                var no_without_country_code = String.Empty;
                var national_no = false;

                if (clean_no.startsWith(trimStart("+", my_country_code))) {
                    if (clean_no.length == trimStart("+", my_country_code).length + national_phone_no_len) {
                        national_no = true;
                        no_without_country_code = clean_no.substr(my_country_code.substr(1).length);
                    }
                }
                else {
                    if (clean_no.startsWith("0")) {
                        national_no = true;

                        no_without_country_code = clean_no;
                    }
                    else {
                        if (clean_no.length <= national_phone_no_len) {
                            national_no = true;

                            if (clean_no.startsWith(trimStart("+", my_country_code))) {
                                no_without_country_code = clean_no.substr(trimStart("+", my_country_code).length);
                            }
                            else
                                no_without_country_code = clean_no;
                        }
                    }
                }

                if (national_no) {
                    //Check for city/area code
                    if (no_without_country_code.startsWith(my_area_code)) {
                        //Local No.
                        if (include_area_code_for_call) {
                            return no_to_dial_outside_line + clean_no;
                        }
                        else {
                            return no_to_dial_outside_line + clean_no.substr(my_area_code.length);
                        }
                    }
                    else {
                        //STD Mobile
                        if (clean_no.startsWith("0" + my_area_code)) {
                            return no_to_dial_outside_line + clean_no.substr(1);
                        }
                        else {
                            //Diff std no or mobile.
                            if (clean_no.startsWith(my_country_code.substr(1)))
                                return no_to_dial_outside_line + no_to_dial_longdistance_call + no_without_country_code;
                            else
                                return no_to_dial_outside_line + no_to_dial_longdistance_call + clean_no;
                        }
                    }
                }
                else {
                    return no_to_dial_outside_line + no_to_dial_international_call + clean_no;
                }
            }
        }
        return no_to_dial_outside_line + clean_no;
    }

    function trimStart(character, string) {
        var startIndex = 0;

        while (string[startIndex] === character) {
            startIndex++;
        }

        return string.substr(startIndex);
    }

    function CleanTheNo(number) {
        return number.toString().replace(/ /g, "").replace(/\./g, "").replace(/\(/g, "").replace(/\)/g, "").replace(/-/g, "").replace(/@/g, "");
    }
}