package com.avaya.ipoffice.openapi.samples.adapter.presence;

import java.util.List;

import com.avaya.ipoffice.openapi.samples.adapter.jaxb.AVMMessageStateChangedEvent;
import com.avaya.ipoffice.openapi.samples.adapter.jaxb.AVMNewMessageEvent;
import com.avaya.ipoffice.openapi.samples.adapter.jaxb.AVMSnapshotEvent;
import com.avaya.ipoffice.openapi.samples.adapter.jaxb.CallLogEvent;
import com.avaya.ipoffice.openapi.samples.adapter.jaxb.CallLogEventType;
import com.avaya.ipoffice.openapi.samples.adapter.jaxb.ChangeType;
import com.avaya.ipoffice.openapi.samples.adapter.jaxb.ContactType;
import com.avaya.ipoffice.openapi.samples.adapter.jaxb.DirectoryContact;
import com.avaya.ipoffice.openapi.samples.adapter.jaxb.DirectoryEvent;
import com.avaya.ipoffice.openapi.samples.adapter.jaxb.PresenceState;
import com.avaya.ipoffice.openapi.samples.adapter.jaxb.PresenceStates;
import com.avaya.ipoffice.openapi.samples.adapter.jaxb.TelephonyPresence;
import com.avaya.ipoffice.openapi.samples.adapter.jaxb.TelephonyPresenceEvent;
import com.avaya.ipoffice.openapi.samples.adapter.ui.data.SessionDataStore;
import com.avaya.ipoffice.openapi.samples.adapter.websocket.OpenApiEventNotifier;

public class PresenceOpenApiEventAdapter implements OpenApiEventNotifier {
	
	private String clientSessionId;
	
	public PresenceOpenApiEventAdapter(String clientSessionId) {
		this.clientSessionId = clientSessionId;
	}

	@Override
	public void notifyEvent(Object eventObject) {
		
		if (eventObject instanceof TelephonyPresenceEvent) {
			TelephonyPresenceEvent telephonyPresenceEvent = (TelephonyPresenceEvent)eventObject;
			SessionDataStore.getSessionDataStore(clientSessionId).getTelephonyPresenceDataStore().getDataList().clear();
			SessionDataStore.getSessionDataStore(clientSessionId).getTelephonyPresenceDataStore().add(telephonyPresenceEvent.getTelephonyPresence());
		} else if (eventObject instanceof PresenceStates) {
			String sessionUsername = SessionDataStore.getSessionDataStore(clientSessionId).getUserSessionInfo().getUserName();
			PresenceStates presenceStates = (PresenceStates)eventObject;
			List<PresenceState> states = presenceStates.getPresenceState();
			for (PresenceState presence : states) {
				String username = presence.getJid().substring(0, presence.getJid().indexOf("@"));
				if (username.equalsIgnoreCase(sessionUsername)) {
					SessionDataStore.getSessionDataStore(clientSessionId).getXmppPresenceDataStore().getDataList().clear();
					SessionDataStore.getSessionDataStore(clientSessionId).getXmppPresenceDataStore().add(presence);
				}
			}			
		}
	}
}
