package com.avaya.ipoffice.openapi.samples.adapter.ui;

import java.awt.BorderLayout;
import java.awt.GridLayout;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;

import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;

import com.avaya.ipoffice.openapi.samples.adapter.jaxb.AVMSnapshotData;
import com.avaya.ipoffice.openapi.samples.adapter.jaxb.Call;
import com.avaya.ipoffice.openapi.samples.adapter.jaxb.CallLogEntry;
import com.avaya.ipoffice.openapi.samples.adapter.jaxb.DirectoryContact;
import com.avaya.ipoffice.openapi.samples.adapter.jaxb.PresenceState;
import com.avaya.ipoffice.openapi.samples.adapter.jaxb.TelephonyPresence;
import com.avaya.ipoffice.openapi.samples.adapter.jaxb.UserLoginResponse;
import com.avaya.ipoffice.openapi.samples.adapter.ui.data.CallDataStore;
import com.avaya.ipoffice.openapi.samples.adapter.ui.data.CallLogDataStore;
import com.avaya.ipoffice.openapi.samples.adapter.ui.data.ContactDataStore;
import com.avaya.ipoffice.openapi.samples.adapter.ui.data.DataChangeListener;
import com.avaya.ipoffice.openapi.samples.adapter.ui.data.DataStore;
import com.avaya.ipoffice.openapi.samples.adapter.ui.data.SessionDataStore;
import com.avaya.ipoffice.openapi.samples.adapter.ui.data.TelephonyPresenceDataStore;
import com.avaya.ipoffice.openapi.samples.adapter.ui.data.UserDataStore;
import com.avaya.ipoffice.openapi.samples.adapter.ui.data.VoicemailDataStore;
import com.avaya.ipoffice.openapi.samples.adapter.ui.data.XmppPresenceDataStore;


public class SnapshotPanel extends JPanel {
	
	private JTable directoryTable;
	private JTable callLogTable;
	private JTable voicemailTable;
	private JTable callControlTable;
	
	private UserPanel userPanel;
	private CallPanel callPanel;
	private XmppPresencePanel xmppPresencePanel;
	private TelephonyPresencePanel telephonyPresencePanel;
	
	private String clientSessionId;

	public SnapshotPanel(String clientSessionId) {
		this.clientSessionId = clientSessionId;
		SessionDataStore sessionDataStore = SessionDataStore.getSessionDataStore(clientSessionId);
		directoryTable = new JTable(new ContactDataStoreTableModel(sessionDataStore.getContactDataStore()));
		callLogTable = new JTable(new CallLogDataStoreTableModel(sessionDataStore.getCallLogDataStore()));
		voicemailTable = new JTable(new VoicemailDataStoreTableModel(sessionDataStore.getVoicemailDataStore()));;
		callControlTable = new JTable(new CallDataStoreTableModel(sessionDataStore.getCallDataStore()));;

		directoryTable.setAutoResizeMode(JTable.AUTO_RESIZE_ALL_COLUMNS);
		callLogTable.setAutoResizeMode(JTable.AUTO_RESIZE_ALL_COLUMNS);
		directoryTable.setAutoResizeMode(JTable.AUTO_RESIZE_ALL_COLUMNS);
		voicemailTable.setAutoResizeMode(JTable.AUTO_RESIZE_ALL_COLUMNS);
		
		callControlTable.getSelectionModel().addListSelectionListener(new ListSelectionListener() {
			
			@Override
			public void valueChanged(ListSelectionEvent e) {
				String callId = (String)callControlTable.getValueAt(e.getFirstIndex(), 0);
				callPanel.setNumber(callId);
			}
		});
		
		setLayout(new BorderLayout());

		JPanel topPanel = new JPanel();
		topPanel.setLayout(new GridLayout(2,2));

		userPanel = new UserPanel();
		userPanel.setBorder(BorderFactory.createTitledBorder("Session Details"));
		userPanel.setClientSessionId(clientSessionId);
		topPanel.add(userPanel);

		xmppPresencePanel = new XmppPresencePanel();
		xmppPresencePanel.setClientSessionId(clientSessionId);
		xmppPresencePanel.setBorder(BorderFactory.createTitledBorder("Xmpp Presence"));
		topPanel.add(xmppPresencePanel);
		
		callPanel = new CallPanel();
		callPanel.setClientSessionId(clientSessionId);
		callPanel.setBorder(BorderFactory.createTitledBorder("Call Activity"));
		topPanel.add(callPanel);
		
		telephonyPresencePanel = new TelephonyPresencePanel();
		telephonyPresencePanel.setClientSessionId(clientSessionId);
		telephonyPresencePanel.setBorder(BorderFactory.createTitledBorder("Telephony Presence"));
		topPanel.add(telephonyPresencePanel);
		
		JPanel centerPanel = new JPanel();
		
		centerPanel.setLayout(new GridLayout(2,2));
		
		JScrollPane pane1 = new JScrollPane(callControlTable);
		pane1.setBorder(BorderFactory.createTitledBorder("Call Status"));
		centerPanel.add(pane1);
		

		JScrollPane pane2 = new JScrollPane(directoryTable);
		pane2.setBorder(BorderFactory.createTitledBorder("Directory"));
		centerPanel.add(pane2);

		
		JScrollPane pane3 = new JScrollPane(voicemailTable);
		pane3.setBorder(BorderFactory.createTitledBorder("Voicemail"));
		centerPanel.add(pane3);

		
		JScrollPane pane4 = new JScrollPane(callLogTable);
		pane4.setBorder(BorderFactory.createTitledBorder("Call Logs"));
		centerPanel.add(pane4);
		
		
		
		add(topPanel, BorderLayout.NORTH);
		add(centerPanel, BorderLayout.CENTER);
		setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
	}
	
}

abstract class DataStoreTableModel<T extends DataStore<D>, D> extends AbstractTableModel implements DataChangeListener {

	protected T dataStore;
	
	public DataStoreTableModel(T store) {
		this.dataStore = store;
		this.dataStore.addDataChangeListener(this);
	}
	
	protected abstract String[] getColumnNames();

	public String getColumnName(int column) {
		return getColumnNames()[column].toString();
	}

	public int getRowCount() {
		return this.dataStore.size();
	}

	public int getColumnCount() {
		return getColumnNames().length;
	}

	@Override
	public void notifyDataAdded(List obj) {
		this.fireTableRowsUpdated(0, this.dataStore.size()-1);
	}

	@Override
	public void notifyDataAdded(Object obj) {
		this.fireTableRowsInserted(this.dataStore.size() - 1, this.dataStore.size() - 1);
	}

	@Override
	public void notifyDataUpdated(Object obj) {
		int row = this.dataStore.getIndex((D)obj);
		this.fireTableRowsUpdated(row, row);
	}

	@Override
	public void notifyDataRemoved(Object obj) {
		int row = this.dataStore.getIndex((D)obj);
		this.fireTableRowsDeleted(row, row);
		
	}

}

class CallDataStoreTableModel extends DataStoreTableModel<CallDataStore, Call> {

	protected String[] columnNames = new String[]{"CallId","Calling Number", "Called Number", "State"};
	
	public CallDataStoreTableModel(CallDataStore store) {
		super(store);
	}
	
	protected String[] getColumnNames() {
		return this.columnNames;
	}

	public Object getValueAt(int row, int col) {
		List<Call> callList = this.dataStore.getDataList();
		switch (col) {
		case (0) :
			return callList.get(row).getCallId();
		case (1) :
			return callList.get(row).getCallingNumber();
		case (2) :
			return callList.get(row).getCalledNumber();
		case (3) :
			return callList.get(row).getState();
		}
		return null;
	}

}

class ContactDataStoreTableModel extends DataStoreTableModel<ContactDataStore, DirectoryContact> {

	protected String[] columnNames = new String[]{"Name", "Number"};
	
	public ContactDataStoreTableModel(ContactDataStore store) {
		super(store);
	}

	protected String[] getColumnNames() {
		return this.columnNames;
	}
	public Object getValueAt(int row, int col) {
		List<DirectoryContact> contactList = this.dataStore.getDataList();
		switch (col) {
			case (0) :
				return contactList.get(row).getFirstName() + " " + contactList.get(row).getLastName();
			case (1) :
				return contactList.get(row).getWorkPhone();
		}
		return null;
	}

}


class CallLogDataStoreTableModel extends DataStoreTableModel<CallLogDataStore, CallLogEntry> {

	protected static String[] columnNames = new String[]{"Number", "Name", "Type", "Count", "Time", "Duration"};
	
	public CallLogDataStoreTableModel(CallLogDataStore store) {
		super(store);
	}

	protected String[] getColumnNames() {
		return this.columnNames;
	}

	public Object getValueAt(int row, int col) {
		List<CallLogEntry> callLogList = this.dataStore.getDataList();
		switch (col) {
			case (0) :
				return callLogList.get(row).getDialbackNumber();
			case (1) :
				return callLogList.get(row).getDialbackName();
			case (2) :
				return callLogList.get(row).getCallType();
			case (3) :
				return callLogList.get(row).getNumberOfCalls();
			case (4) :
				return callLogList.get(row).getCallTimestamp();
			case (5) :
				return callLogList.get(row).getDuration();
		}
		return null;
	}

}

class VoicemailDataStoreTableModel extends DataStoreTableModel<VoicemailDataStore, AVMSnapshotData> {

	protected String[] columnNames = new String[]{"Number", "Name", "Time", "Duration", "State"};
	
	public VoicemailDataStoreTableModel(VoicemailDataStore store) {
		super(store);
	}

	protected String[] getColumnNames() {
		return this.columnNames;
	}
	
	public Object getValueAt(int row, int col) {
		List<AVMSnapshotData> voicemailList = this.dataStore.getDataList();
		switch (col) {
		case (0) :
			return voicemailList.get(row).getSenderDevice().getValue();
		case (1) :
			return voicemailList.get(row).getSenderName();
		case (2) :
			return voicemailList.get(row).getUtcDateTime();
		case (3) :
			return voicemailList.get(row).getLength();
		case (4) :
			return voicemailList.get(row).getNewState();
		}
		return null;
	}

}

