package com.avaya.ipoffice.openapi.samples.adapter.ui;

import java.awt.BorderLayout;
import java.util.List;

import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

import com.avaya.ipoffice.openapi.samples.adapter.jaxb.PresenceState;
import com.avaya.ipoffice.openapi.samples.adapter.jaxb.TelephonyPresence;
import com.avaya.ipoffice.openapi.samples.adapter.ui.data.SessionDataStore;
import com.avaya.ipoffice.openapi.samples.adapter.ui.data.TelephonyPresenceDataStore;
import com.avaya.ipoffice.openapi.samples.adapter.ui.data.XmppPresenceDataStore;

public class TelephonyPresencePanel extends JPanel {
	
	private JTable telephonyPresenceTable;
	
	private String clientSessionId;
	

	public void setClientSessionId(String clientSessionId) {
		this.clientSessionId = clientSessionId;
		SessionDataStore sessionDataStore = SessionDataStore.getSessionDataStore(clientSessionId);
		telephonyPresenceTable = new JTable(new TelephonyPresenceDataStoreTableModel(sessionDataStore.getTelephonyPresenceDataStore()));		add(telephonyPresenceTable);
		telephonyPresenceTable.setAutoResizeMode(JTable.AUTO_RESIZE_ALL_COLUMNS);

		setLayout(new BorderLayout());		
		add(telephonyPresenceTable.getTableHeader(), BorderLayout.NORTH);
		add(telephonyPresenceTable, BorderLayout.CENTER);
	}

}
class TelephonyPresenceDataStoreTableModel extends DataStoreTableModel<TelephonyPresenceDataStore, TelephonyPresence> {

	protected String[] columnNames = new String[]{"DnD", "OnHook", "Fwd"};
	
	public TelephonyPresenceDataStoreTableModel(TelephonyPresenceDataStore store) {
		super(store);
	}

	protected String[] getColumnNames() {
		return this.columnNames;
	}
	
	public Object getValueAt(int row, int col) {
		List<TelephonyPresence> telephonyPresenceList = this.dataStore.getDataList();
		switch (col) {
		case (0) :
			return telephonyPresenceList.get(row).isDndon() ? "On" : "Off";
		case (1) :
			return telephonyPresenceList.get(row).isOnhook() ? "OnHook" : "OffHook";
		case (2) :
			return telephonyPresenceList.get(row).isFwdon() ? "Yes" : "No";
		}
		return null;
	}
}
