package com.avaya.ipoffice.openapi.samples.adapter.ui;

import java.awt.BorderLayout;
import java.util.List;

import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

import com.avaya.ipoffice.openapi.samples.adapter.jaxb.PresenceState;
import com.avaya.ipoffice.openapi.samples.adapter.jaxb.TelephonyPresence;
import com.avaya.ipoffice.openapi.samples.adapter.ui.data.SessionDataStore;
import com.avaya.ipoffice.openapi.samples.adapter.ui.data.TelephonyPresenceDataStore;
import com.avaya.ipoffice.openapi.samples.adapter.ui.data.XmppPresenceDataStore;

public class XmppPresencePanel extends JPanel {
	
	private JTable xmppPresenceTable;
	private JTable telephonyPresenceTable;
	
	private String clientSessionId;
	

	public void setClientSessionId(String clientSessionId) {
		this.clientSessionId = clientSessionId;
		SessionDataStore sessionDataStore = SessionDataStore.getSessionDataStore(clientSessionId);
		xmppPresenceTable = new JTable(new XmppPresenceDataStoreTableModel(sessionDataStore.getXmppPresenceDataStore()));
		xmppPresenceTable.setAutoResizeMode(JTable.AUTO_RESIZE_ALL_COLUMNS);

		setLayout(new BorderLayout());		
		add(xmppPresenceTable.getTableHeader(), BorderLayout.NORTH);
		add(xmppPresenceTable, BorderLayout.CENTER);
	}

}
class XmppPresenceDataStoreTableModel extends DataStoreTableModel<XmppPresenceDataStore, PresenceState> {

	protected String[] columnNames = new String[]{"Mode", "Status", "Type"};
	
	public XmppPresenceDataStoreTableModel(XmppPresenceDataStore store) {
		super(store);
	}

	protected String[] getColumnNames() {
		return this.columnNames;
	}
	
	public Object getValueAt(int row, int col) {
		List<PresenceState> xmppPresenceList = this.dataStore.getDataList();
		switch (col) {
		case (0) :
			return xmppPresenceList.get(row).getMode();
		case (1) :
			return xmppPresenceList.get(row).getStatus();
		case (2) :
			return xmppPresenceList.get(row).getType();
		}
		return null;
	}
}
