package com.avaya.ipoffice.openapi.samples.adapter.directory;

import java.util.List;

import com.avaya.ipoffice.openapi.samples.adapter.jaxb.AVMMessageStateChangedEvent;
import com.avaya.ipoffice.openapi.samples.adapter.jaxb.AVMNewMessageEvent;
import com.avaya.ipoffice.openapi.samples.adapter.jaxb.AVMSnapshotEvent;
import com.avaya.ipoffice.openapi.samples.adapter.jaxb.CallLogEvent;
import com.avaya.ipoffice.openapi.samples.adapter.jaxb.CallLogEventType;
import com.avaya.ipoffice.openapi.samples.adapter.jaxb.ChangeType;
import com.avaya.ipoffice.openapi.samples.adapter.jaxb.ContactType;
import com.avaya.ipoffice.openapi.samples.adapter.jaxb.DirectoryContact;
import com.avaya.ipoffice.openapi.samples.adapter.jaxb.DirectoryEvent;
import com.avaya.ipoffice.openapi.samples.adapter.ui.data.SessionDataStore;
import com.avaya.ipoffice.openapi.samples.adapter.websocket.OpenApiEventNotifier;

public class DirectoryOpenApiEventAdapter implements OpenApiEventNotifier {
	
	private String clientSessionId;
	
	public DirectoryOpenApiEventAdapter(String clientSessionId) {
		this.clientSessionId = clientSessionId;
	}

	@Override
	public void notifyEvent(Object eventObject) {
		
		if (eventObject instanceof DirectoryEvent) {
			DirectoryEvent directoryEvent = (DirectoryEvent)eventObject;
			if (directoryEvent.getDirTypeChanged() == ContactType.GLOBAL) {
				List<DirectoryContact> contactList = directoryEvent.getContacts();
				for (DirectoryContact contact : contactList) {
					if (contact.getChangeType() == ChangeType.ADD) {
						SessionDataStore.getSessionDataStore(clientSessionId).getContactDataStore().add(contact);
					}
				}
			}
		} 
	}
}
