package com.avaya.ipoffice.openapi.samples.adapter.ui;

import java.awt.BorderLayout;
import java.util.List;

import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

import com.avaya.ipoffice.openapi.samples.adapter.jaxb.PresenceState;
import com.avaya.ipoffice.openapi.samples.adapter.jaxb.UserLoginResponse;
import com.avaya.ipoffice.openapi.samples.adapter.ui.data.SessionDataStore;
import com.avaya.ipoffice.openapi.samples.adapter.ui.data.UserDataStore;

public class UserPanel extends JPanel {
	
	private JTable userTable;
	private String clientSessionId;

	
	public void setClientSessionId(String clientSessionId) {
		this.clientSessionId = clientSessionId;
		SessionDataStore sessionDataStore = SessionDataStore.getSessionDataStore(clientSessionId);
		userTable = new JTable(new UserDataStoreTableModel(sessionDataStore.getUserDataStore()));
		userTable.setAutoResizeMode(JTable.AUTO_RESIZE_ALL_COLUMNS);

		setLayout(new BorderLayout());		
		add(userTable.getTableHeader(), BorderLayout.NORTH);
		add(userTable, BorderLayout.CENTER);
		
	}


}
class UserDataStoreTableModel extends DataStoreTableModel<UserDataStore, UserLoginResponse> {

	protected String[] columnNames = new String[]{"User", "ClientSessionId", "Extn", "Subdomain"};
	
	public UserDataStoreTableModel(UserDataStore store) {
		super(store);
	}

	protected String[] getColumnNames() {
		return this.columnNames;
	}
	
	public Object getValueAt(int row, int col) {
		List<UserLoginResponse> userList = this.dataStore.getDataList();
		switch (col) {
		case (0) :
			return userList.get(row).getUserName();
		case (1) :
			return userList.get(row).getClientSessionID();
		case (2) :
			return userList.get(row).getUserExtension();
		case (3) :
			return userList.get(row).getUserSwitchDevice();
		}
		return null;
	}
}
