package com.avaya.ipoffice.openapi.samples.adapter;

import java.util.List;

import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

import com.avaya.ipoffice.openapi.samples.adapter.directory.DirectoryOpenApiRestAdapter;
import com.avaya.ipoffice.openapi.samples.adapter.exception.OpenApiException;
import com.avaya.ipoffice.openapi.samples.adapter.jaxb.DirectoryContact;
import com.avaya.ipoffice.openapi.samples.adapter.jaxb.DirectorySearchResponse;
import com.avaya.ipoffice.openapi.samples.adapter.jaxb.Error;
import com.avaya.ipoffice.openapi.samples.adapter.jaxb.UserLoginResponse;
import com.avaya.ipoffice.openapi.samples.adapter.session.SessionOpenApiRestAdapter;

public class DirectorySample {

	public static void main(String arg[]) {
		
		OpenApiRestServiceConfig.setServer("148.147.216.234");
		OpenApiRestServiceConfig.setPort("8080");
		OpenApiRestServiceConfig.setServiceUrl("/inyama/service/");
		OpenApiRestServiceConfig.setSecure(false);

		
		try {
			
			UserLoginResponse loginResponse = SessionOpenApiRestAdapter.login("Extn111", "1234", "App");
			String clientSessionId = loginResponse.getClientSessionID();
			System.out.println("clientSessionId "+loginResponse.getClientSessionID());
			
			List<DirectoryContact> DirectorySearchResponse = DirectoryOpenApiRestAdapter.getSystemDirectory(clientSessionId);
		} catch (OpenApiException e) {
			System.out.println("Error : "+e.getMessage());
		}
	}
}
