package com.avaya.ipoffice.openapi.samples.adapter.callcontrol;

import com.avaya.ipoffice.openapi.samples.adapter.jaxb.Call;
import com.avaya.ipoffice.openapi.samples.adapter.jaxb.CallInformationEvent;
import com.avaya.ipoffice.openapi.samples.adapter.jaxb.ConnectionClearedEvent;
import com.avaya.ipoffice.openapi.samples.adapter.jaxb.DeliveredEvent;
import com.avaya.ipoffice.openapi.samples.adapter.jaxb.EstablishedEvent;
import com.avaya.ipoffice.openapi.samples.adapter.jaxb.HeldEvent;
import com.avaya.ipoffice.openapi.samples.adapter.jaxb.RetrievedEvent;
import com.avaya.ipoffice.openapi.samples.adapter.ui.data.SessionDataStore;
import com.avaya.ipoffice.openapi.samples.adapter.websocket.OpenApiEventNotifier;

public class CallControlOpenApiEventAdapter implements OpenApiEventNotifier {

	private String clientSessionId;
	
	public CallControlOpenApiEventAdapter(String clientSessionId) {
		this.clientSessionId = clientSessionId;
	}
	
	@Override
	public void notifyEvent(Object eventObject) {
		if (eventObject instanceof CallInformationEvent) {
			CallInformationEvent CallInformationEvent = (CallInformationEvent)eventObject;
			String callId = CallInformationEvent.getConnection().getCallID();			
			String calledNumber = SessionDataStore.getSessionDataStore(clientSessionId).getUserSessionInfo().getUserExtension();;
			String callingNumber = CallInformationEvent.getCallingDevice().getDeviceIdentifier().getValue();
			Call call = new Call(callId, calledNumber, callingNumber);
			//SessionDataStore.getSessionDataStore(clientSessionId).getCallDataStore().add();
			call.setState("CONNECTED");
			SessionDataStore.getSessionDataStore(clientSessionId).getCallDataStore().add(call);

		} else if (eventObject instanceof DeliveredEvent) {
			DeliveredEvent deliveredEvent = (DeliveredEvent)eventObject;
			String callId = deliveredEvent.getConnection().getCallID();
			String callingNumber = deliveredEvent.getCalledDevice().getDeviceIdentifier().getValue();
			String calledNumber = deliveredEvent.getCallingDevice().getDeviceIdentifier().getValue();
			Call call = new Call(callId, calledNumber, callingNumber);
			call.setState("RINGING");
			SessionDataStore.getSessionDataStore(clientSessionId).getCallDataStore().add(call);
		} else if (eventObject instanceof EstablishedEvent) {
			EstablishedEvent establishedEvent = (EstablishedEvent)eventObject;
			String callId = establishedEvent.getEstablishedConnection().getCallID();
			Call call = SessionDataStore.getSessionDataStore(clientSessionId).getCallDataStore().getCallByCallId(callId);
			if (call != null) {
				call.setState("ESTABLISHED");
				SessionDataStore.getSessionDataStore(clientSessionId).getCallDataStore().update(call);
			}
		} else if (eventObject instanceof ConnectionClearedEvent) {
			ConnectionClearedEvent connectionClearedEvent = (ConnectionClearedEvent)eventObject;
			String callId = connectionClearedEvent.getDroppedConnection().getCallID();
			Call call = SessionDataStore.getSessionDataStore(clientSessionId).getCallDataStore().getCallByCallId(callId);
			if (call != null) {
				call.setState("DISCONNECTED");
				SessionDataStore.getSessionDataStore(clientSessionId).getCallDataStore().update(call);
			}
		} else if (eventObject instanceof HeldEvent) {
			HeldEvent heldEvent = (HeldEvent)eventObject;
			String callId = heldEvent.getHeldConnection().getCallID();
			Call call = SessionDataStore.getSessionDataStore(clientSessionId).getCallDataStore().getCallByCallId(callId);
			if (call != null) {
				call.setState("ONHOLD");
				SessionDataStore.getSessionDataStore(clientSessionId).getCallDataStore().update(call);
			}
		} else if (eventObject instanceof RetrievedEvent) {
			RetrievedEvent retrievedEvent = (RetrievedEvent)eventObject;
			String callId = retrievedEvent.getRetrievedConnection().getCallID();
			Call call = SessionDataStore.getSessionDataStore(clientSessionId).getCallDataStore().getCallByCallId(callId);
			if (call != null) {
				call.setState("CONNECTED");
				SessionDataStore.getSessionDataStore(clientSessionId).getCallDataStore().update(call);
			}
		}
	}

}
