package com.avaya.ipoffice.openapi.samples.adapter.directory;

import java.util.List;

import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

import com.avaya.ipoffice.openapi.samples.adapter.OpenApiRestServiceConfig;
import com.avaya.ipoffice.openapi.samples.adapter.exception.OpenApiException;
import com.avaya.ipoffice.openapi.samples.adapter.jaxb.DirectoryContact;
import com.avaya.ipoffice.openapi.samples.adapter.jaxb.DirectorySearchResponse;
import com.avaya.ipoffice.openapi.samples.adapter.jaxb.Error;

public class DirectoryOpenApiRestAdapter {
	
	public static List<DirectoryContact> getSystemDirectory(String clientSessionId) throws OpenApiException {

		Client client = ClientBuilder.newClient();
		WebTarget webTarget = client.target(OpenApiRestServiceConfig.getOpenApiRestServiceUrl()).path("directory");
		
	
		Invocation.Builder invocationBuilder =	webTarget.request(MediaType.APPLICATION_XML).header("ClientSessionId", clientSessionId);

		Response response = invocationBuilder.get();
		if (response.getStatus() == 200) {
			DirectorySearchResponse directoryResponse = response.readEntity(DirectorySearchResponse.class);
			return directoryResponse.getList().getContact();
		} else {
			Error error = response.readEntity(Error.class);
			throw new OpenApiException(error);
		}
	}
}
