package com.avaya.ipoffice.openapi.websocket;

import java.io.IOException;
import java.net.URI;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

import javax.xml.bind.JAXBException;

import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.StatusCode;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketClose;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketConnect;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketMessage;
import org.eclipse.jetty.websocket.api.annotations.WebSocket;
import org.eclipse.jetty.websocket.client.ClientUpgradeRequest;
import org.eclipse.jetty.websocket.client.WebSocketClient;
 
/**
 * Basic Echo Client Socket
 */
@WebSocket(maxTextMessageSize = 1024 * 1024)
public class OpenApiJettyWebSocketClient {
 
    private CountDownLatch closeLatch;
	private WebSocketClient client;
    protected WebSocketEventMessageListener eventListener = null;
    protected String webSocketUrl;


    private Session session;
 
    public OpenApiJettyWebSocketClient(final String webSocketUrl, final WebSocketEventMessageListener listener ) {
    	this.webSocketUrl = webSocketUrl;
    	this.eventListener = listener;
    	this.startConnection(this);
    }
    
    private void startConnection(final OpenApiJettyWebSocketClient websocket) {
        client = new WebSocketClient();
        this.closeLatch = new CountDownLatch(1);
        Thread t = new Thread() {
        	public void run() {
		        try {
		            client.start();
		            URI echoUri = new URI(webSocketUrl);
		            ClientUpgradeRequest request = new ClientUpgradeRequest();
		            client.connect(websocket, echoUri, request);
		            //System.out.printf("Connecting to : %s%n", echoUri);
		            closeLatch.await();
		        } catch (Throwable t) {
		            t.printStackTrace();
		        } finally {
		            try {
		                //client.stop();
		            } catch (Exception e) {
		                e.printStackTrace();
		            }
		        }
        	}
        };
        t.start();
        startHeartbeat();
    }
    
    private void startHeartbeat() {
        Thread t = new Thread() {
        	public void run() {
        		while (session != null) {
			        try {
			        	Thread.sleep(5000);
			        	sendMessage("Heartbeat");
			        } catch (Exception e) {
			        	e.printStackTrace();
			        }
        		}
        	}
        };
        t.start();    	
    }
  
    @OnWebSocketClose
    public void onClose(int statusCode, String reason) {
        this.session = null;
        this.closeLatch.countDown();
    }
 
    @OnWebSocketConnect
    public void onConnect(Session session) {
        this.session = session;
    }
    @OnWebSocketMessage
    public void onMessage(Session session, String msg) {
        try {
			eventListener.notifyEventMessageReceived(msg);
		} catch (JAXBException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
    }
    public void sendMessage(String msg) throws IOException {
    	this.session.getRemote().sendString(msg);
    }
    
   public static void main(String[] arg) throws Exception {
    	
    	final WebSocketEventMessageListener listener = new WebSocketEventMessageListener() {
			@Override
			public void notifyEventMessageReceived(String message) {
			}
    	};
    	
    	OpenApiJettyWebSocketClient client = new OpenApiJettyWebSocketClient("ws://echo.websocket.org/", listener);    }    
}