package com.avaya.ipoffice.openapi.samples.adapter.ui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

import com.avaya.ipoffice.openapi.samples.adapter.callcontrol.CallControlOpenApiRestAdapter;
import com.avaya.ipoffice.openapi.samples.adapter.exception.OpenApiException;
import com.avaya.ipoffice.openapi.samples.adapter.jaxb.UserLoginResponse;
import com.avaya.ipoffice.openapi.samples.adapter.ui.data.SessionDataStore;

public class CallPanel extends JPanel {
	
	private JTextField numberTextField = new JTextField(15);
	private JButton callButton = new JButton("Call");
	private JButton endButton = new JButton("End");
	
	private String clientSessionId;
	
	public CallPanel() {
		JLabel label = new JLabel("Enter Number");
		add(label);;
		add(numberTextField);
		add(callButton);
		add(endButton);
		
		callButton.addActionListener(new ActionListener() {
			
			@Override
			public void actionPerformed(ActionEvent arg0) {
				UserLoginResponse sessionInfo = SessionDataStore.getSessionDataStore(clientSessionId).getUserSessionInfo(); 
				String subdomain = sessionInfo.getUserSwitchDevice();
				String callingNumber = sessionInfo.getUserExtension();
				String calledNumber = numberTextField.getText();
				try {
					CallControlOpenApiRestAdapter.makeCall(clientSessionId, subdomain, callingNumber, calledNumber);
				} catch (OpenApiException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
			}
		});
		endButton.addActionListener(new ActionListener() {
			
			@Override
			public void actionPerformed(ActionEvent arg0) {
				String callId = numberTextField.getText();
				try {
					CallControlOpenApiRestAdapter.endCall(clientSessionId, callId);
				} catch (OpenApiException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
			}
		});

	}

	public void setClientSessionId(String clientSessionId) {
		this.clientSessionId = clientSessionId;
	}
	
	public void setNumber(String number) {
		this.numberTextField.setText(number);
	}
}
