package com.avaya.ipoffice.openapi.samples.javafx;


import java.io.StringReader;
import java.io.StringWriter;

import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

import com.avaya.ipoffice.openapi.samples.data.*;
import com.avaya.ipoffice.openapi.samples.data.Error;
import com.avaya.ipoffice.openapi.samples.VoiceMail;
import com.avaya.ipoffice.openapi.websocket.OpenApiJettyWebSocketClient;
import com.avaya.ipoffice.openapi.websocket.WebSocketEventHandler;

import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.AnchorPane;
import javafx.stage.Stage;

import javax.xml.transform.*;
import javax.xml.transform.stream.*;

public class controllerVoiceMail 
{
	@FXML TextField usernameTextVoicemail;
	@FXML TextField passwordTextVoicemail;
	@FXML TextField portTextVoicemail;
	@FXML TextField serverTextVoicemail;
	@FXML AnchorPane rootVoicemail;
	
	@FXML TextArea xmlResponseVoicemail;
	
	@FXML Button close;
	public String name;
	public String password;
	public String serverIP;
	public String port;
	public String clientSesionId = "";
	
	@FXML TableView<AVMSnapshotData> voicemails;
	@FXML TableColumn<AVMSnapshotData, String> voicemailName;						
	@FXML TableColumn<AVMSnapshotData, String> voicemailDateTime;
	@FXML TableColumn<AVMSnapshotData, String> voicemailDuration;

	ObservableList<AVMSnapshotData> voiceMailsList = FXCollections.observableArrayList();
	
	public void mainVoicemails()
	{
		Object obj = (Object)this;
		this.name = usernameTextVoicemail.getText();	
		this.password = passwordTextVoicemail.getText();
		this.serverIP = serverTextVoicemail.getText();
		this.port = portTextVoicemail.getText();
		
		voicemailName.setCellValueFactory(new PropertyValueFactory<AVMSnapshotData, String>("senderName"));
		voicemailDateTime.setCellValueFactory(new PropertyValueFactory<AVMSnapshotData, String>("dateTime"));
		voicemailDuration.setCellValueFactory(new PropertyValueFactory<AVMSnapshotData, String>("length"));		
		
		VoiceMail vm = new VoiceMail(this.name, this.password, this.serverIP, this.port);
		this.clientSesionId = vm.user1.clientSessionID;
		WebSocketEventHandler handler = new WebSocketEventHandler(obj, "controllerVoiceMail");
		OpenApiJettyWebSocketClient client = new OpenApiJettyWebSocketClient(vm.user1.webSocketUrl,handler.listener);
		vm.getVoicemails();
	}
	
	public void VoiceMailTable(AVMSnapshotEvent avms, controllerVoiceMail cv)
	{
		ObservableList<AVMSnapshotData> voiceMailsList = FXCollections.observableArrayList();
		
		for(int i=0;i<avms.getSnapshotDataList().size();i++)
		{
			voiceMailsList.add(avms.getSnapshotDataList().get(i));
		}
		
		cv.voicemails.setItems(voiceMailsList);
	}
	
	public void xmlVoicemails(String event, controllerVoiceMail cv)
	{
		try{
			Source xmlInput = new StreamSource(new StringReader(event));
	        StringWriter stringWriter = new StringWriter();
	        StreamResult xmlOutput = new StreamResult(stringWriter);
	        TransformerFactory transformerFactory = TransformerFactory.newInstance();
	        transformerFactory.setAttribute("indent-number", 10);
	        Transformer transformer = transformerFactory.newTransformer(); 
	        transformer.setOutputProperty(OutputKeys.INDENT, "yes");
	        transformer.transform(xmlInput, xmlOutput);
	        
	        cv.xmlResponseVoicemail.setWrapText(true);
	        cv.xmlResponseVoicemail.setStyle("-fx-text-fill: green;");
	        cv.xmlResponseVoicemail.setText(xmlOutput.getWriter().toString());
			
		}
		catch(Exception e)
		{
			System.out.println(e);
		}
	}
	public void closeVoicemail()
	{
		
		Stage stage = (Stage)rootVoicemail.getScene().getWindow();
		
		if(this.clientSesionId.equals(""))
			stage.close();
		else
		{
			Client client = ClientBuilder.newClient();
			WebTarget webTarget = client.target("http://"+serverIP+":"+port+"/inyama/service").path("session");
			Invocation.Builder invocationBuilder =	webTarget.request(MediaType.APPLICATION_XML).header("ClientSessionId", this.clientSesionId);
			Response response = invocationBuilder.delete();
			stage.close();
		}
	}
	
}
