﻿$(document).ready(function () {
    uiController.init();

    logoutdialog = $("#logout-dialog-form").dialog({
        autoOpen: false,
        height: 150,
        width: 170,
        modal: true,
        resizable: false,
        position: 'center',
        dialogClass: "noclose",
        buttons: {
            "Logout": uiController.DoLogout,
            Cancel: function () {
                $(this).dialog("close");
            }
        },
        close: function () { }
    });

    loginretrydialog = $("#retry-dialog-form").dialog({
        autoOpen: false,
        height: 150,
        width: 180,
        modal: true,
        resizable: false,
        position: 'center',
        dialogClass: "noclose",
        buttons: {
            Cancel: function () { uiController.reloginRetryCancel(); $(this).dialog("close"); }
        },
        close: function () { }
    });

    transferdialog = $("#transfer-dialog-form").dialog({
        autoOpen: false,
        height: 220,
        width: 170,
        modal: true,
        resizable: false,
        position: 'center',
        dialogClass: "noclose",
        buttons: {
            "Transfer": function () {
                uiController.DoInitiateTransfer();
            },
            "Complete":function(){
                uiController.DoTransferComplete();
            },
            Cancel: function () { uiController.DoCancelTransfer(); }
        },
        close: function () { }
    });

    dialpad = $("#dialpad-dialog-form").dialog({
        autoOpen: false,
        height: 250,
        width: 170,
        modal: false,
        resizable: false,
        position: 'center',
        close: function () {
            $("#number2dial").val('');
            $("#chkDtmfDialing").prop("checked", false);
        }
    });

    messagedialog = $('<div id="ipo_msgBox" class="ipoDialog"></div>').dialog({
        width: 180,
        height: 'auto',
        autoOpen: false,
        modal: true,
        draggable: true,
        resizable: false,
        bgiframe: true,
        close: function () { },
        buttons: [
            {
                text: 'OK',
                click: function () { $(this).dialog('close'); }
            }
        ]
    });

    var icons = {
        header: "ui-icon-plus",
        activeHeader: "ui-icon-minus"
    };

    $("#accordion_tab_contacts").accordion({
        collapsible: true,
        icons: icons,
        heightStyle: "fill"
    });

    initializeUI();
    initCallButtonsIcons();
    KeyPadActions();

    $('#non-console-div').hide();
    $('#main-div').css({ "visibility": "visible" });
    uiController.initializeTransferList();
    $('#name').focus();
});

$(document).keypress(function (e) {
    var key = e.which;//String.fromCharCode(key)
});

function initializeUI() {
    $('#active-call-details').hide();
    $('#active-call-details-2').hide();
    uiController.HideAccordionTabs();
    $('#btn_dialpad').hide();
    $('#server_ip_address').hide();
    $('#btn_directory').hide();
    $('#btn_logout').hide();
    $('#login_extension').hide();
    $('#login-form').show();
    $('#login_progress_img').hide();
}

function initCallButtonsIcons() {
    $('#btn_retrivecall').button({
        icons: { primary: 'icon_answer' },
        text: false
    });
    $('#btn_dropcall').button({
        icons: { primary: 'icon_end' },
        text: false
    });
    $('#btn_hold').button({
        icons: { primary: 'icon_hold' },
        text: false
    });
    $('#btn_mute_unmute').button({
        icons: { primary: 'icon_mute' },
        text: false
    });
    $('#btn_initiate_transfer').button({
        icons: { primary: 'icon_transfer' },
        text: false
    });
    $('#btn_retrivecall_2').button({
        icons: { primary: 'icon_answer' },
        text: false
    });
    $('#btn_dropcall_2').button({
        icons: { primary: 'icon_end' },
        text: false
    });
    $('#btn_hold_2').button({
        icons: { primary: 'icon_hold' },
        text: false
    });
    $('#btn_mute_unmute_2').button({
        icons: { primary: 'icon_mute' },
        text: false
    });
    $('#btn_initiate_transfer_2').button({
        icons: { primary: 'icon_transfer' },
        text: false
    });
    $('#btn_transfer').button({
        icons: { primary: 'icon_transfer' },
        text: false
    });
    $('#btn_rejectcall').button({
        icons: { primary: 'icon_end' },
        text: false
    });
    $('#btn_rejectcall_2').button({
        icons: { primary: 'icon_end' },
        text: false
    });
};

function KeyPadActions() {
    var number = $("#number2dial");
    var total;
    $(".keypad_digit").click(function () {
        if ($('#chkDtmfDialing').is(":not(:checked)")) {
            if ($(this).data("dialvalue") == 'CLR') {
                number.val('');
            }
            else if ($(this).data("dialvalue") == 'Del') {
                total = number.val();
                total = total.slice(0, -1);
                number.val(total);
            }
            else if ($(this).data("dialvalue") == 'Call') {
                uiController.DoMakeCall(number.val());
                number.val('');
            }
            else {
                total = number.val();
                total = total + $(this).data("dialvalue");
                number.val(total);
            }
        }
        else {
            uiController.DoSendDTMF($(this).data("dialvalue"));
        }
    });
}

function displayCallLink(numToDisplay, numToDial) {
    var call = "<a href='#' onclick=onNumberLinkClickInGrid(" + numToDial + ") style='text-decoration: none;color:blue'>" + numToDisplay + "</a> ";
    return call;
}

function onNumberLinkClickInGrid(number) {
    uiController.DoMakeCall(number);
}

var directoryContacts = [];

function ipoUIController() {
    var connectionManager;
    var dialingRules;
    var showDirectory = true;
    var showCallLog = false;
    var isDirectoryOpen = false;
    this.init = init;
    this.DoLogin = DoLogin;
    this.DoLogout = DoLogout;
    this.DoInitiateTransfer = DoInitiateTransfer;
    this.DoTransfer = DoTransfer;
    this.DoConsultationTransfer = DoConsultationTransfer;
    this.DoTransferComplete = DoTransferComplete;
    this.DoCancelTransfer = DoCancelTransfer;
    this.DoLogoutPrompt = DoLogoutPrompt;
    this.DoMakeCall = DoMakeCall;
    this.DoSendDTMF = DoSendDTMF;
    this.getDirectory = getDirectory;
    this.HideAccordionTabs = HideAccordionTabs;
    this.initializeTransferList = initializeTransferList;
    this.reloginRetryCancel = reloginRetryCancel;

    var firstCallStartTime = null;
    var firstCallTimer = null;
    var secondCallStartTime = null;
    var secondCallTimer = null;
    var loginRetryTimer = null;
    var loginRetryTime = null;
    var transferAppearanceNo = 1;

    function init() {
        connectionManager = new ipoConnectionManager();
        dialingRules = new ipoDialingRules();

        var callbackList = {
            "loginCallback": loginCallback,
            "incomingCallCallback": incomingCallCallback,
            "alertingCallCallback": alertingCallCallback,
            "failedCallCallback" : failedCallCallback,
            "connectedCallCallback": connectedCallCallback,
            "consultedCallCallback":consultedCallCallback,
            "clearedCallCallback":clearedCallCallback,
            "heldCallback": heldCallback,
            "muteUnmuteCallback": muteUnmuteCallback,
            "transferCallback": transferCallback,
            "conferenceCallback": conferenceCallback,
            "logoffCallback": logoffCallback,
            "dndCallback": dndCallback,
            "serverErrorsCallback": serverErrorsCallback,
            "debugPrintCallback": debugPrintCallback,
            "showMessageCallback": showMessageCallback,
			"getDirectoryContactsCallback": getDirectoryContactsCallback
        };
        connectionManager.init(callbackList);
        registerClickEvents();
        $("#btn_dial_dtmf").text('CALL');
        $("#btn_dial_del").text('Del');
        $("#btn_dial_clr").text('CLR');
        $("#chkDtmfDialing").prop("checked", false);
        $('#name').val(localStorage.getItem("loginuser"));
        $('#serverip').val(localStorage.getItem("serverip"));
        $('#port').val(localStorage.getItem("port"));
    }
    
    function ShowContactDirectoryOption() {
        if (showDirectory == true) {
            $('#btn_directory').show();
        }
        else {
            $('#btn_directory').hide();
        }
    }

    function initializeTransferList() {
        $("#txtTransferNumber").autocomplete({
            minLength: 0,
            source: directoryContacts,
            focus: function (event, ui) {
                $("#txtTransferNumber").val(ui.item.value);
                return false;
            },
            select: function (event, ui) {
                $("#txtTransferNumber").val(ui.item.value);
                return false;
            }
        })
        .data("ui-autocomplete")._renderItem = function (ul, item) {
            return $("<li>")
            .append("<a>" + item.label + " (" + item.value + ")</a>")
            .appendTo(ul);
        };
    }

     function updateUICallback(status, callAppearanceNo) {
        if (callAppearanceNo === undefined) { callAppearanceNo = 1; }

        if(status=="LOGIN_SUCCESSFUL"){
            $('#btn_dialpad').show();
            $('#server_ip_address').show();
            ShowContactDirectoryOption();
            $('#btn_logout').show();
            $('#login_extension').show();
            $('#login-form').hide();
            $('#login_progress_img').hide();
            HideAccordionTabs();

            firstCallClearTimer();
        }
        else if(status=="LOGOUT_SUCCESSFUL"){
            $('#active-call-details').hide();
            $('#active-call-details-2').hide();
            $('#btn_dialpad').hide();
            $('#server_ip_address').hide();
            $('#btn_directory').hide();
            $('#btn_logout').hide();
            $('#login_extension').hide();
            $('#login-form').effect('slide', '{}', 500, null);
            $('#login_progress_img').hide();
            logoutdialog.dialog("close");
            dialpad.dialog("close");
            HideAccordionTabs();

            firstCallClearTimer();
        }
        else if (status == "INCOMING") {
            if (callAppearanceNo == 1) {
                $('#active-call-details').effect('highlight', '{}', 500, null);
                $('#btn_answercall').show();
                $('#btn_rejectcall').show();
                $('#btn_dropcall').hide();
                $('#btn_hold').hide();
                $('#btn_retrivecall').hide();
                $('#btn_mute_unmute').hide();
                $('#btn_initiate_transfer').hide();
                $('#active-call-status').text('Incoming');
                $('#active-call-status').css({ color: 'blue' });

                firstCallStartTimer();
            }
            else {
                $('#active-call-details-2').effect('highlight', '{}', 500, null);
                $('#btn_answercall_2').show();
                $('#btn_rejectcall_2').show();
                $('#btn_dropcall_2').hide();
                $('#btn_hold_2').hide();
                $('#btn_retrivecall_2').hide();
                $('#btn_mute_unmute_2').hide();
                $('#btn_initiate_transfer_2').hide();

                $('#active-call-status-2').text('Incoming');
                $('#active-call-status-2').css({ color: 'blue' });

                secondCallStartTimer();
            }
        }
        else if (status == "ALERTING") {
            if (callAppearanceNo == 1) {
                $('#active-call-details').effect('highlight', '{}', 500, null);
                $('#btn_answercall').hide();
                $('#btn_rejectcall').hide();
                $('#btn_dropcall').show();
                $('#btn_hold').hide();
                $('#btn_retrivecall').hide();
                $('#btn_mute_unmute').hide();
                $('#btn_initiate_transfer').hide();

                $('#active-call-status').text('Alerting');
                $('#active-call-status').css({ color: 'darkorange' });

                firstCallStartTimer();
            }
            else {
                $('#active-call-details-2').effect('highlight', '{}', 500, null);
                $('#btn_answercall_2').hide();
                $('#btn_rejectcall_2').hide();
                $('#btn_dropcall_2').show();
                $('#btn_hold_2').hide();
                $('#btn_retrivecall_2').hide();
                $('#btn_mute_unmute_2').hide();
                $('#btn_initiate_transfer_2').hide();

                $('#active-call-status-2').text('Alerting');
                $('#active-call-status-2').css({ color: 'darkorange' });

                secondCallStartTimer();
            }
        }
        else if (status == "CONNECTED") {
            if (callAppearanceNo == 1) {
                $('#active-call-details').show();
                $('#btn_answercall').hide();
                $('#btn_rejectcall').hide();
                $('#btn_dropcall').show();
                $('#btn_hold').show();
                $('#btn_retrivecall').hide();
                $('#btn_mute_unmute').show();
                $('#btn_initiate_transfer').show();

                if ($("#caller_name").text().toString().charCodeAt(0) == 35) {
                    $('#active-call-status').text('On Voicemail');
                }
                else {
                    $('#active-call-status').text('Connected');
                }
                $('#active-call-status').css({ color: 'green' });

                firstCallStartTimer();
            }
            else {
                $('#active-call-details-2').show();
                $('#btn_answercall_2').hide();
                $('#btn_rejectcall_2').hide();
                $('#btn_dropcall_2').show();
                $('#btn_hold_2').show();
                $('#btn_retrivecall_2').hide();
                $('#btn_mute_unmute_2').show();
                $('#btn_initiate_transfer_2').show();

                $('#active-call-status-2').text('Connected');
                $('#active-call-status-2').css({ color: 'green' });

                secondCallStartTimer();
            }
        }
        else if (status == "DROPED") {
            if (callAppearanceNo == 1) {
                $('#active-call-details').hide();
                $('#active-call-status').text('Droped');
                firstCallClearTimer();
            }
            else {
                $('#active-call-details-2').hide();
                $('#active-call-status-2').text('Droped');
                secondCallClearTimer();
            }
        }
        else if (status == "TRANSFER_SUCCESSFUL") {
            if (callAppearanceNo == 1) {
                $('#active-call-details').hide();
                transferdialog.dialog("close");
                firstCallClearTimer();
            }
            else {
                $('#active-call-details-2').hide();
                transferdialog.dialog("close");
                secondCallClearTimer();
            }
        }
        else if (status == "MUTE_SUCCESSFUL") {
            if (callAppearanceNo == 1) {
                $('#active-call-status').text('On Mute');
                $('#active-call-status').css({ color: 'darkorange' });
                $('#btn_mute_unmute').button({
                    icons: { primary: 'icon_unmute' },
                    text: false
                });
                $("#btn_mute_unmute").prop('title', "Un Mute");
            }
            else {
                $('#active-call-status-2').text('On Mute');
                $('#active-call-status-2').css({ color: 'darkorange' });
                $('#btn_mute_unmute_2').button({
                    icons: { primary: 'icon_unmute' },
                    text: false
                });
                $("#btn_mute_unmute_2").prop('title', "Un Mute");
            }
        }
        else if (status == "UNMUTE_SUCCESSFUL") {
            if (callAppearanceNo == 1) {
                $('#active-call-status').text('Connected');
                $('#active-call-status').css({ color: 'green' });
                $('#btn_mute_unmute').button({
                    icons: { primary: 'icon_mute' },
                    text: false
                });
                $("#btn_mute_unmute").prop('title', "Mute");
            }
            else {
                $('#active-call-status-2').text('Connected');
                $('#active-call-status-2').css({ color: 'green' });
                $('#btn_mute_unmute_2').button({
                    icons: { primary: 'icon_mute' },
                    text: false
                });
                $("#btn_mute_unmute_2").prop('title', "Mute");
            }
        }
        else if (status == "HOLD_SUCCESSFUL") {
            if (callAppearanceNo == 1) {
                $('#active-call-details').show();
                $('#btn_answercall').hide();
                $('#btn_rejectcall').hide();
                $('#btn_dropcall').show();
                $('#btn_hold').hide();
                $('#btn_retrivecall').show();
                $('#btn_mute_unmute').hide();
                $('#btn_initiate_transfer').hide();

                $('#active-call-status').text('On Hold');
                $('#active-call-status').css({ color: 'darkorange' });
            }
            else {
                $('#active-call-details-2').show();
                $('#btn_answercall_2').hide();
                $('#btn_rejectcall_2').hide();
                $('#btn_dropcall_2').show();
                $('#btn_hold_2').hide();
                $('#btn_retrivecall_2').show();
                $('#btn_mute_unmute_2').hide();
                $('#btn_initiate_transfer_2').hide();
                $('#active-call-status-2').text('On Hold');
                $('#active-call-status-2').css({ color: 'darkorange' });
            }
        }
        else if (status == "UNHOLD_SUCCESSFUL") {
            if (callAppearanceNo == 1) {
                $('#active-call-details').show();
                $('#btn_answercall').hide();
                $('#btn_rejectcall').hide();
                $('#btn_dropcall').show();
                $('#btn_hold').show();
                $('#btn_retrivecall').hide();
                $('#btn_mute_unmute').show();
                $('#btn_initiate_transfer').show();

                $('#active-call-status').text('Connected');
                $('#active-call-status').css({ color: 'green' });
            }
            else {
                $('#active-call-details-2').show();
                $('#btn_answercall_2').hide();
                $('#btn_rejectcall_2').hide();
                $('#btn_dropcall_2').show();
                $('#btn_hold_2').show();
                $('#btn_retrivecall_2').hide();
                $('#btn_mute_unmute_2').show();
                $('#btn_initiate_transfer_2').show();

                $('#active-call-status-2').text('Connected');
                $('#active-call-status-2').css({ color: 'green' });
            }
        }
        else {
            firstCallClearTimer();
            secondCallClearTimer();
        }
    }
    
    function clickToDialCallback(response) {
        try {
            var json = JSON.parse(response.result);
            if (json) {
                var number = json.number;
                if (number) {
                    DoMakeCall(number);
                }
            }
        } catch (e) {
            logErrorWarnings("ERROR_clickToDialCallback: " + e);
        }
    }

    function validateIp(ipAddress) {
        return (/^(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$/i.test(ipAddress));
    }

    function loginCallback(info) {
        if (info.Status == "Success") {
            updateUICallback('LOGIN_SUCCESSFUL');
            if (loginretrydialog.dialog("isOpen") === true) {
                loginretrydialog.dialog("close");
            }
            $("#login_extension").text(connectionManager.getUserExtension());
            $('#server_ip_address').text(connectionManager.getServerIpAddress());
            getDirectory();
            localStorage.setItem("loginuser", connectionManager.getLastLogedinUserName());
        }
        else {
            if (loginretrydialog.dialog("isOpen") === true) {
                loginRetryTimerStart();
            }
            else {
                $('#password').focus();
                $('#password').val('');
                showMessage("Login Error", info.Status);
                $('#login_progress_img').hide();
            }
        }
    }

    function incomingCallCallback(callSessionData) {
        if (callSessionData.callAppearanceNo == 1) {
            $("#caller_name").text(callSessionData.name);
            $("#caller_number").text(callSessionData.number);
            $("#callDirection").attr('src', img_incoming);
            updateUICallback('INCOMING');
        }
        else if (callSessionData.callAppearanceNo == 2) {
            $("#caller_name_2").text(callSessionData.name);
            $("#caller_number_2").text(callSessionData.number);
            $("#callDirection_2").attr('src', img_incoming);
            updateUICallback('INCOMING', 2);
        }
    }

    function alertingCallCallback(callSessionData) {
        if (callSessionData.callAppearanceNo == 1) {
            $("#caller_name").text(callSessionData.name);
            $("#caller_number").text(callSessionData.number);
            $("#callDirection").attr('src', img_outgoing);
            updateUICallback('ALERTING');
        }
        else if (callSessionData.callAppearanceNo == 2) {
            $("#caller_name_2").text(callSessionData.name);
            $("#caller_number_2").text(callSessionData.number);
            $("#callDirection_2").attr('src', img_outgoing);
            updateUICallback('ALERTING', 2);
        }
    }

    function failedCallCallback(callSessionData) {
        if (callSessionData.callAppearanceNo == 1) {
            $("#caller_name").text(callSessionData.name);
            $("#caller_number").text(callSessionData.number);
            $("#callDirection").attr('src', img_outgoing);
            updateUICallback('ALERTING');
            $('#active-call-status').text('Failed');
            $('#active-call-status').css({ color: 'red' });
            setTimeout(DropFailedCall, 1000);
        }
        else if (callSessionData.callAppearanceNo == 2) {
            $("#caller_name_2").text(callSessionData.name);
            $("#caller_number_2").text(callSessionData.number);
            $("#callDirection_2").attr('src', img_outgoing);
            updateUICallback('ALERTING', 2);
            $('#active-call-status-2').text('Failed');
            $('#active-call-status-2').css({ color: 'red' });
            setTimeout(DropFailedCall, 1000);
        }
    }

    function DropFailedCall() {
        if (call_1_session_data != null && call_1_session_data.isFailed == true) {
            DoDropCall(1);
        }
        if (call_2_session_data != null && call_2_session_data.isFailed == true) {
            DoDropCall(2);
        }
    }

    function connectedCallCallback(callSessionData) {
        if (callSessionData.callAppearanceNo == 1) {
            $("#caller_name").text(callSessionData.name);
            $("#caller_number").text(callSessionData.number);
            updateUICallback('CONNECTED');
        }
        else if (callSessionData.callAppearanceNo == 2) {
            $("#caller_name_2").text(callSessionData.name);
            $("#caller_number_2").text(callSessionData.number);
            updateUICallback('CONNECTED', 2);
        }
    }

    function consultedCallCallback(callSessionData) {
        $("#txtTransferNumber").prop('disabled', true);
        if (callSessionData.isAnswered == true) {
            $("#transfer-dialog-form").siblings('.ui-dialog-buttonpane').find('button:first').hide();
            $("#transfer-dialog-form").siblings('.ui-dialog-buttonpane').find('button').eq(1).show();
        }
        if(callSessionData.isConsultationCall == true){
            if (callSessionData.isAnswered == true) {
                $('#consult-call-status').text('Connected');
                $('#consult-call-status').css({ color: 'green' });
            }
            else {
                $('#consult-call-status').text('Alerting...');
                $('#consult-call-status').css({ color: 'darkorange' });
            }
        }
    }
    
    function clearedCallCallback(callSessionData) {
        if (callSessionData.callAppearanceNo == 1) {
            $("#caller_name").text(callSessionData.name);
            $("#caller_number").text(callSessionData.number);
            updateUICallback('DROPED');
            call_1_session_data = null;
        }
        else if (callSessionData.callAppearanceNo == 2) {
            $("#caller_name_2").text(callSessionData.name);
            $("#caller_number_2").text(callSessionData.number);
            updateUICallback('DROPED', 2);
            call_2_session_data = null;
        }
        if (call_3_session_data != null) {
            if (callSessionData.connection_id == call_3_session_data.connection_id && call_3_session_data.isConsultationCall == true) {
                call_3_session_data = null;
            }
        }
    }

    function heldCallback(callSessionData) {
        if (callSessionData.isHeld == true) {
            if (callSessionData.callAppearanceNo == 1) {
                $("#caller_name").text(callSessionData.name);
                $("#caller_number").text(callSessionData.number);
                updateUICallback('HOLD_SUCCESSFUL');
            }
            else if (callSessionData.callAppearanceNo == 2) {
                $("#caller_name_2").text(callSessionData.name);
                $("#caller_number_2").text(callSessionData.number);
                updateUICallback('HOLD_SUCCESSFUL', 2);
            }
        }
        else {
            if (callSessionData.callAppearanceNo == 1) {
                $("#caller_name").text(callSessionData.name);
                $("#caller_number").text(callSessionData.number);
                updateUICallback('UNHOLD_SUCCESSFUL');
            }
            else if (callSessionData.callAppearanceNo == 2) {
                $("#caller_name_2").text(callSessionData.name);
                $("#caller_number_2").text(callSessionData.number);
                updateUICallback('UNHOLD_SUCCESSFUL', 2);
            }
        }
    }

    function muteUnmuteCallback(callSessionData) {
        if (callSessionData.isMuted == true) {
            if (callSessionData.callAppearanceNo == 1) {
                $("#caller_name").text(callSessionData.name);
                $("#caller_number").text(callSessionData.number);
                updateUICallback('MUTE_SUCCESSFUL');
            }
            else if (callSessionData.callAppearanceNo == 2) {
                $("#caller_name_2").text(callSessionData.name);
                $("#caller_number_2").text(callSessionData.number);
                updateUICallback('MUTE_SUCCESSFUL', 2);
            }
        }
        else {
            if (callSessionData.callAppearanceNo == 1) {
                $("#caller_name").text(callSessionData.name);
                $("#caller_number").text(callSessionData.number);
                updateUICallback('UNMUTE_SUCCESSFUL');
            }
            else if (callSessionData.callAppearanceNo == 2) {
                $("#caller_name_2").text(callSessionData.name);
                $("#caller_number_2").text(callSessionData.number);
                updateUICallback('UNMUTE_SUCCESSFUL', 2);
            }
        }
    }

    function transferCallback() {

    }

    function conferenceCallback(callSessionData) {
        if (callSessionData.callAppearanceNo == 1) {
            $("#caller_name").text(callSessionData.name);
            $("#caller_number").text(callSessionData.number);
            $("#callDirection").attr('src', img_conference);
            updateUICallback('CONNECTED');
        }
        else if (callSessionData.callAppearanceNo == 2) {
            $("#caller_name_2").text(callSessionData.name);
            $("#caller_number_2").text(callSessionData.number);
            $("#callDirection_2").attr('src', img_conference);
            updateUICallback('CONNECTED', 2);
        }
    }

    function logoffCallback(info) {
        var reloginRequired = false;
        updateUICallback('LOGOUT_SUCCESSFUL');
        call_1_session_data = null;
        call_2_session_data = null;
        call_3_session_data = null;
        $("#login_extension").text('');
        $("#password").val('');
        directoryContacts.splice(0, directoryContacts.length)
        while (directoryContacts.length > 0) {
            directoryContacts.pop();
        }
        directoryContacts.length = 0;

        if (info.Reason == "LOGIN_DIFFERENT_LOCATION") {
            showMessage("Logout", "Someone is logged in from other location.");
        }
        else if (info.Reason == "SESSION_DESTROYED") {
            showMessage("Logout", "Session destroyed from server.");
        }
        else if (info.Reason == "SESSION_TIMEOUT") {
            showMessage("Logout", "Session timed out.");
        }
        else if (info.Reason == "SERVER_PROBLEM") {
            showMessage("Logout", "Server problem.");
        }
        else if (info.Reason == "UNKNOWN") {
            showMessage("Logout", "Unknown error occured at server.");
        }
        else if (info.Reason == "WEB_SOCKET_FAILED") {
            showMessage("WebSocket Error", "Unable to open WebSocket connection.");
        }
        else if (info.Reason == "WEB_SOCKET_CLOSED") {
            showMessage("WebSocket Error", "WebSocket got closed due to unknown reason.");
        }
        else if (info.Reason == "SERVER_REDIRECT") {//Server switchover occured.

        }
        else if (info.Reason == "SERVICE_REDIRECTED") {//Need to connect Primary.
            reloginRequired = true;
        }
        else if (info.Reason == "OutOfService") {
            showMessage("Out Of Service", "Server is currently unavailable.");
            reloginRequired = true;
        }
        else if (info.Reason == "ServerNotResponding") {
            showMessage("Heart Beat", "Server is not responding.");
            reloginRequired = true;
        }
        else if (info.Reason == "PrimaryServerUp") {//Event from 1xPortal, to connect primary server.
            reloginRequired = true;
        }

        if (reloginRequired == true) {
            loginretrydialog.dialog("open");
            loginRetryTimerStart();
        }
    }

    function reloginOnFallback() {
        if ($("#ipo_msgBox").dialog("isOpen") === true) {
            messagedialog.dialog("close");
        }
        connectionManager.Relogin();
    }

    function reloginRetryCancel() {
        loginRetryTimerClear();
    }

    function loginRetryTimerStart() {
        if (loginRetryTimer !== null) {
            loginRetryTimerClear();
        }
        loginRetryTime = 180;
        loginRetryTimer = setInterval(function () { return loginRetryUpdateTime(); }, 1000);
    }

    function loginRetryTimerClear() {
        if (loginRetryTimer != null) {
            clearInterval(loginRetryTimer);
            loginRetryTimer = null;
            loginRetryTime = null;
        }
    }

    function loginRetryUpdateTime() {
        loginRetryTime = loginRetryTime - 1;
        var secondsRemaining = loginRetryTime % 60;
        var minutesRemaining = Math.floor(loginRetryTime / 60);
        if (minutesRemaining <= 0 && secondsRemaining <= 0) {
            loginRetryTimerClear();
            $('#retry_time').text("Retrying...");
            reloginOnFallback();
        }
        else {
            secondsRemaining = secondsRemaining >= 10 ? secondsRemaining : '0' + secondsRemaining;
            $('#retry_time').text("Retrying in " + minutesRemaining + ":" + secondsRemaining);
        }
    }

    function serverErrorsCallback() {

    }

    function dndCallback(status) {
        if (status == true) {
            $("#login_extension").text(connectionManager.getUserExtension() +' ( DND )');
        }
        else {
            $("#login_extension").text(connectionManager.getUserExtension());
        }
    }

    function debugPrintCallback(message)
    {
        console.log(message);
        console.log('\n');
        $("#span_Error").text(message);
    }

    function showMessageCallback(title, message) {
        console.log(title + "~" + message);
    }

    function registerClickEvents() {
        $('#btn_login').click(DoLogin);
        $('#btn_logout').click(DoLogoutPrompt);
        $('#btn_dialpad').click(DoShowDialPad);
        $('#btn_directory').click(DoShowDirectory);

        $('#btn_answercall').click(function () {
            DoAnswerCall(1);
        });
        $('#btn_dropcall').click(function () {
            DoDropCall(1);
        });
        $('#btn_initiate_transfer').click(function () {
            InitiateTransferDialog(1);
        });
        $('#btn_hold').click(function () {
            DoHold(1);
        });
        $('#btn_retrivecall').click(function () {
            DoUnHold(1);
        });
        $('#btn_mute_unmute').click(function () {
            DoMuteUnmute(1);
        });
        $('#btn_rejectcall').click(function () {
            DoDropCall(1);
        });

        $('#btn_answercall_2').click(function () {
            DoAnswerCall(2);
        });
        $('#btn_dropcall_2').click(function () {
            DoDropCall(2);
        });
        $('#btn_initiate_transfer_2').click(function () {
            InitiateTransferDialog(2);
        });
        $('#btn_hold_2').click(function () {
            DoHold(2);
        });
        $('#btn_retrivecall_2').click(function () {
            DoUnHold(2);
        });
        $('#btn_mute_unmute_2').click(function () {
            DoMuteUnmute(2);
        });
        $('#btn_rejectcall_2').click(function () {
            DoDropCall(2);
        });
        $("#name").keydown(function (event) {
            if (event.keyCode == 13) {
                $("#btn_login").click();
            }
        });
        $("#password").keydown(function (event) {
            if (event.keyCode == 13) {
                $("#btn_login").click();
            }
        });
        $("#txtTransferNumber").keydown(function (event) {
            if (event.keyCode == 13) {
                event.preventDefault();
                DoInitiateTransfer();
            }
        });
        $("#chkDtmfDialing").click(function () {
            if ($(this).is(":checked")) {
                SetDialpadUI(true);
            }
            else if ($(this).is(":not(:checked)")) {
                SetDialpadUI(false);
            }
        });
        $("#number2dial").keydown(function (e) {
            if ($.inArray(e.keyCode, [46, 8, 9, 27, 13, 110]) !== -1 ||
                (e.keyCode == 65 && (e.ctrlKey === true || e.metaKey === true)) ||
                (e.keyCode >= 35 && e.keyCode <= 40)) {
                if (e.keyCode == 13 && $("#number2dial").val() !=='') {
                    DoMakeCall($("#number2dial").val());
                }
                return;
            }
            if ((e.shiftKey || (e.keyCode < 48 || e.keyCode > 57)) && (e.keyCode < 96 || e.keyCode > 105)) {
                e.preventDefault();
            }
        });
    }

    function DoShowDialPad() {
        if ($("#dialpad-dialog-form").dialog("isOpen") === true) {
            dialpad.dialog("close");
            $("#chkDtmfDialing").prop("checked", true);
            SetDialpadUI(true);
        } else {
            dialpad.dialog("open");
            $("#chkDtmfDialing").prop("checked", false);
            SetDialpadUI(false);
        }
    }

    function SetDialpadUI(isDtmf) {
        if (isDtmf == true) {
            $("#number2dial").hide();
            $("#btn_dial_clr").hide();
            $("#btn_dial_del").hide();
            $("#btn_dial_dtmf").hide();
            $("#dialpad-dialog-form").dialog("option", "height", 190);
        }
        else {
            $("#number2dial").show();
            $("#btn_dial_clr").show();
            $("#btn_dial_del").show();
            $("#btn_dial_dtmf").show();
            $("#dialpad-dialog-form").dialog("option", "height", 250);
        }
    }

    function DoShowDirectory() {
        if (isDirectoryOpen == false) {
            $('#accordion_tab_contacts').show();
            isDirectoryOpen = true;
        }
        else {
            $('#accordion_tab_contacts').hide();
            isDirectoryOpen = false;
        }
    }

    function HideAccordionTabs() {
        $('#accordion_tab_contacts').hide();
    }

    function getDirectory() {
        var callCenterName = 'SalesforceAdapter';
        $("#directory_contacts").children().remove();
        connectionManager.GetDirectory();
    }

    var getDirectoryContactsCallback = function (response) {
        var json = JSON.parse(response);
        if (json) {
            var len = json.DirectorySearchResponse.list.contact.length;
            var txt = "";
            var num = "";
            if (len > 0) {
                for (var i = 0; i < len; i++) {
                    if (json.DirectorySearchResponse.list.contact[i].workPhone !== undefined && json.DirectorySearchResponse.list.contact[i].workPhone !== null) {
                        num = CleanTheNumber(json.DirectorySearchResponse.list.contact[i].workPhone);
                        txt += "<tr><td class='Table_cells'>" + json.DirectorySearchResponse.list.contact[i].workPhone + "</td><td class='Table_cells'>" + displayCallLink(json.DirectorySearchResponse.list.contact[i].workPhone, num) + "</td></tr>";
                        directoryContacts.push({ value: json.DirectorySearchResponse.list.contact[i].workPhone, label: json.DirectorySearchResponse.list.contact[i].firstName });
                    }
                }
                if (txt != "") {
                    $("#directory_contacts").append(txt);
                }
            }
        }
    };

   function DoLogin() {
        if ($("#name").val() !== "") {
            $('#login_progress_img').show();
            localStorage.setItem("serverip", $("#serverip").val());
            localStorage.setItem("port", $("#port").val());
            connectionManager.setServerIpAddress($("#serverip").val());
            connectionManager.setServerPort($("#port").val());
            connectionManager.login($("#name").val(), $("#password").val());
        }
        else {
            loginCallback({ "Status": "Please Enter Agent Name." })
        }
    }

    function DoLogoutPrompt() {
        logoutdialog.dialog("open");
    }

    function DoLogout() {
        connectionManager.logout();
    }

    function DoMakeCall(number) {
        if (number !== '') {
            connectionManager.MakeCall(dialingRules.applyDialingRules(number));
            $("#number2dial").val('');
            dialpad.dialog("close");
        }
    }

    function DoSendDTMF(digit) {
        if (call_1_session_data != null && call_1_session_data.isHeld == false) {
            DoSendDTMFDigit(1, digit);
        }
        else if (call_2_session_data != null && call_2_session_data.isHeld == false) {
            DoSendDTMFDigit(2, digit);
        }
    }

    function DoAnswerCall(callAppearanceNo) {
        if (callAppearanceNo == 1) {
            connectionManager.AnswerCall(call_1_session_data);
        }
        else {
            connectionManager.AnswerCall(call_2_session_data);
        }
    }

    function DoDropCall(callAppearanceNo) {
        if (callAppearanceNo == 1) {
            connectionManager.DropCall(call_1_session_data);
            if (call_1_session_data != null && call_1_session_data.isFailed == true) {
                clearedCallCallback(call_1_session_data);
            }
        }
        else {
            connectionManager.DropCall(call_2_session_data);
            if (call_2_session_data != null && call_2_session_data.isFailed == true) {
                clearedCallCallback(call_2_session_data);
            }
        }
    }

    function InitiateTransferDialog(callAppearanceNo) {
        transferAppearanceNo = callAppearanceNo;
        $("#rbtn_singlestep").prop('checked', true);
        $("#txtTransferNumber").val('');
        $("#transfer-dialog-form").siblings('.ui-dialog-buttonpane').find('button:first').show();
        $("#transfer-dialog-form").siblings('.ui-dialog-buttonpane').find('button').eq(1).hide();
        $('#consult-call-status').text('');
        if (transferAppearanceNo == 1) {
            transferdialog.dialog('option', 'title', "Transfer - " + call_1_session_data.number);
        }
        else {
            transferdialog.dialog('option', 'title', "Transfer - " + call_2_session_data.number);
        }
        transferdialog.dialog("open");
        $("#txtTransferNumber").prop('disabled', false);
        $("#txtTransferNumber").focus();
    }

    function DoInitiateTransfer() {
        var checked_radio = $('input:radio[name=transfer]:checked').val();
        if ($("#txtTransferNumber").val() !== "") {
            if (checked_radio == 'singlestep') {
                DoTransfer($("#txtTransferNumber").val());
            }
            else if (checked_radio == 'consultative') {
                if (call_3_session_data == null) {
                    DoConsultationTransfer($("#txtTransferNumber").val());
                }
            }
        }
        else {
            $("#txtTransferNumber").focus();
        }
    }

    function DoTransfer(number) {
        if (transferAppearanceNo == 1) {
            connectionManager.Transfer(call_1_session_data, CleanTheNumber(number));
            updateUICallback('TRANSFER_SUCCESSFUL');//for testing purpose.
        }
        else {
            connectionManager.Transfer(call_2_session_data, CleanTheNumber(number));
            updateUICallback('TRANSFER_SUCCESSFUL', 2);//for testing purpose.
        }
    }

    function DoConsultationTransfer(number) {
        if (transferAppearanceNo == 1) {
            connectionManager.ConsultationTransfer(call_1_session_data, CleanTheNumber(number));
        }
        else {
            connectionManager.ConsultationTransfer(call_2_session_data, CleanTheNumber(number));
        }
    }
    
    function DoTransferComplete() {
        if (transferAppearanceNo == 1) {
            connectionManager.TransferComplete(call_1_session_data, call_3_session_data);
            updateUICallback('TRANSFER_SUCCESSFUL');//for testing purpose.
        }
        else {
            connectionManager.TransferComplete(call_2_session_data, call_3_session_data);
            updateUICallback('TRANSFER_SUCCESSFUL', 2);//for testing purpose.
        }
    }

    function DoCancelTransfer(callAppearanceNo) {
        if (call_3_session_data != null) {
            connectionManager.DropCall(call_3_session_data);
        }
        transferdialog.dialog("close");
    }

    function DoHold(callAppearanceNo) {
        if (callAppearanceNo == 1) {
            connectionManager.Hold(call_1_session_data);
        }
        else {
            connectionManager.Hold(call_2_session_data);
        }
    }

    function DoUnHold(callAppearanceNo) {
        if (callAppearanceNo == 1) {
            connectionManager.UnHold(call_1_session_data, call_2_session_data);
        }
        else {
            connectionManager.UnHold(call_2_session_data, call_1_session_data);
        }
    }

    function DoMuteUnmute(callAppearanceNo) {
        if (callAppearanceNo == 1) {
            connectionManager.MuteUnmute(call_1_session_data);
        }
        else {
            connectionManager.MuteUnmute(call_2_session_data);
        }
    }

    function DoSendDTMFDigit(callAppearanceNo, digits) {
        if (callAppearanceNo == 1) {
            connectionManager.SendDTMFDigit(call_1_session_data, digits);
        }
        else {
            connectionManager.SendDTMFDigit(call_2_session_data, digits);
        }
    }

    function CleanTheNumber(number) {
        return number.toString().replace(/ /g, "").replace(/\./g, "").replace(/\(/g, "").replace(/\)/g, "").replace(/-/g, "").replace(/@/g, "");
    }

    function logErrorWarnings(message) {
        try {
            debugPrintCallback(message);
        } catch (e) {
            alert("ERROR_logErrorWarnings: " + e);
        }
    }

    function firstCallStartTimer(timeVal) {
        if (firstCallTimer !== null) {
            firstCallClearTimer();
        }

        if (timeVal !== undefined && timeVal !== null) {
            firstCallStartTime = timeVal;
        }
        else {
            firstCallStartTime = new Date().getTime();
        }

        firstCallTimer = setInterval(function () { return firstCallUpdateTime(); }, 1000);
    }

    function firstCallClearTimer() {
        if (firstCallTimer != null) {
            clearInterval(firstCallTimer);
            firstCallTimer = null;
            firstCallStartTime = null;
        }
    }

    function firstCallUpdateTime() {
        var elapsed = new Date().getTime() - firstCallStartTime;
        var timeElapsed = Math.floor(elapsed / 1000);
        var secondsElapsed = timeElapsed % 60;
        var minutesElapsed = Math.floor((timeElapsed % 3600) / 60);
        var hoursElapsed = Math.floor(timeElapsed / 3600);
        secondsElapsed = secondsElapsed >= 10 ? secondsElapsed : '0' + secondsElapsed;
        minutesElapsed = minutesElapsed >= 10 ? minutesElapsed : '0' + minutesElapsed;
        hoursElapsed = hoursElapsed >= 10 ? hoursElapsed : '0' + hoursElapsed;
        if (hoursElapsed == 0) {
            $('#active-call-time').text(minutesElapsed + ":" + secondsElapsed);
        }
        else {
            $('#active-call-time').text(hoursElapsed + ":" + minutesElapsed + ":" + secondsElapsed);
        }
    }

    function secondCallStartTimer(timeVal) {
        if (secondCallTimer !== null) {
            secondCallClearTimer();
        }

        if (timeVal !== undefined && timeVal !== null) {
            secondCallStartTime = timeVal;
        }
        else {
            secondCallStartTime = new Date().getTime();
        }

        secondCallTimer = setInterval(function () { return secondCallUpdateTime(); }, 1000);
    }

    function secondCallClearTimer() {
        if (secondCallTimer != null) {
            clearInterval(secondCallTimer);
            secondCallTimer = null;
            secondCallStartTime = null;
        }
    }

    function secondCallUpdateTime() {
        var elapsed = new Date().getTime() - secondCallStartTime;
        var timeElapsed = Math.floor(elapsed / 1000);
        var secondsElapsed = timeElapsed % 60;
        var minutesElapsed = Math.floor((timeElapsed % 3600) / 60);
        var hoursElapsed = Math.floor(timeElapsed / 3600);
        secondsElapsed = secondsElapsed >= 10 ? secondsElapsed : '0' + secondsElapsed;
        minutesElapsed = minutesElapsed >= 10 ? minutesElapsed : '0' + minutesElapsed;
        hoursElapsed = hoursElapsed >= 10 ? hoursElapsed : '0' + hoursElapsed;
        if (hoursElapsed == 0) {
            $('#active-call-time-2').text(minutesElapsed + ":" + secondsElapsed);
        }
        else {
            $('#active-call-time-2').text(hoursElapsed + ":" + minutesElapsed + ":" + secondsElapsed);
        }
    }

    function showMessage(title, msg) {
        $('#ipo_msgBox').text(msg);
        messagedialog.dialog('option', 'title', title);
        messagedialog.dialog("open");
    }
}