﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Diagnostics;
using System.Drawing;
using System.Linq;
using System.Net;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using System.Xml;

namespace OneXOpenAPISample
{
    public partial class CallLogForm : Form
    {
        private ServerSettings sampleSettings;
        private LoginResponseDetails responseDetails;
        private RESTRequest RequestREST = new RESTRequest();
        private WebSocketService service;
        private DataTable dt;

        public CallLogForm(ServerSettings SampleSettings)
        {
            InitializeComponent();
            this.sampleSettings = SampleSettings;
            txtServer.Text = this.sampleSettings.Server;
            txtPort.Text = this.sampleSettings.Port + " (" + (this.sampleSettings.Secure ? "Secure" : "UnSecure") + ")";
            txtUserId.Text = this.sampleSettings.UserId;
            txtPassword.Text = this.sampleSettings.Password;
            lblWait.Visible = false;
        }

        private void BtnGetCallLogs_Click(object sender, EventArgs e)
        {
            lblWait.Visible = true;
            if (Login() == true)
            {
                service = new WebSocketService(responseDetails.sessionId, true);
                service.Events.CollectionChanged -= new System.Collections.Specialized.NotifyCollectionChangedEventHandler(Events_CollectionChanged);
                service.Events.CollectionChanged += new System.Collections.Specialized.NotifyCollectionChangedEventHandler(Events_CollectionChanged);
                bool IsEventDeliveryServiceStarted = service.Start(responseDetails.webSocketWssUrl, string.Empty);
                if (IsEventDeliveryServiceStarted)
                {
                    SendStoredCallLog obj = new SendStoredCallLog();
                    byte[] byteArray = Encoding.UTF8.GetBytes(this.responseDetails.switchDevice);
                    DeviceID callingDev = new DeviceID() { Value = this.responseDetails.userExtension };
                    callingDev.typeOfNumber = typeOfNumberEnum.deviceNumber;
                    callingDev.switchingSubDomainInformationElements = byteArray;
                    MediaClassComponents[] mediaClassArray = new MediaClassComponents[] { MediaClassComponents.voice };
                    callingDev.mediaClass = mediaClassArray;
                    obj.device = callingDev;
                    Serializer serializer = new Serializer();
                    String postData = serializer.Serialize(obj);

                    HttpStatusCode requestStatus = HttpStatusCode.Continue;
                    string response = RequestREST.Send(this.sampleSettings, "/inyama/service/calllog", postData, HTTPMethod.GET, this.responseDetails.sessionId, out requestStatus);
                    responseDetails.serverResponse = response;
                    txtServerResponse.Text = response;

                    if (requestStatus == HttpStatusCode.OK || requestStatus == HttpStatusCode.Accepted)
                    {
                        XmlDocument doc = new XmlDocument();
                        doc.LoadXml(response);
                        Deserilizer deserializer = new Deserilizer();
                        Object responseObj = deserializer.Deserlize("SendStoredCallLogResponse", doc.InnerXml);
                        dt = new DataTable();
                        dt.Columns.Add(new DataColumn() { ColumnName = "Type", ReadOnly = true });
                        dt.Columns.Add(new DataColumn() { ColumnName = "Name", ReadOnly = true });
                        dt.Columns.Add(new DataColumn() { ColumnName = "Number", ReadOnly = true });
                        dt.Columns.Add(new DataColumn() { ColumnName = "DateTime", ReadOnly = true });
                        dt.Columns.Add(new DataColumn() { ColumnName = "Duration", ReadOnly = true });
                        if (responseObj != null)
                        {
                            foreach (callLogEntry entry in ((SendStoredCallLogResponse)responseObj).@return)
                            {
                                DataRow dr = dt.NewRow();
                                dr["Type"] = entry.call_type.ToString();
                                dr["Name"] = string.IsNullOrEmpty(entry.calling_party_name) ? entry.dialback_number : entry.calling_party_name;
                                dr["Number"] = entry.dialback_number;
                                dr["DateTime"] = entry.call_timestamp.ToString("dd-MM-yyyy hh:mm:ss");
                                dr["Duration"] = entry.duration;
                                dt.Rows.Add(dr);
                            }
                            dt.AcceptChanges();
                        }
                        DisplayCallLogs(dt);
                    }
                }
            }
            lblWait.Visible = false;
        }

        private void DisplayCallLogs(DataTable dt)
        {
            if (this.listView1.InvokeRequired)
            {
                this.listView1.BeginInvoke((MethodInvoker)delegate() { DisplayCallLogs(dt); });
            }
            else
            {
                listView1.Items.Clear();

                ListViewGroup[] lvGroups = { new ListViewGroup("Incoming", "Incoming"), new ListViewGroup("Outgoing", "Outgoing"), new ListViewGroup("MissedLost", "MissedLost") };
                listView1.Groups.AddRange(lvGroups);
                foreach (DataRow dr in dt.Rows)
                {
                    ListViewItem lvItem = listView1.Items.Add(dr["Name"].ToString());
                    lvItem.SubItems.Add(dr["Number"].ToString());
                    lvItem.SubItems.Add(dr["DateTime"].ToString());
                    lvItem.SubItems.Add(dr["Duration"].ToString());
                    lvItem.Group = listView1.Groups[dr["Type"].ToString()];
                }
            }
        }

        private void Events_CollectionChanged(object sender, System.Collections.Specialized.NotifyCollectionChangedEventArgs e)
        {
            foreach (var _event in e.NewItems)
            {
                Debug.Print(_event.ToString());
                switch (_event.ToString())
                {
                    case "CallLogEvent":
                        {
                            callLogEntry evtData = ((CallLogEvent)_event).entry;
                             if (evtData != null)
                             {
                                 if (dt != null)
                                 {
                                     DataRow dr = dt.NewRow();
                                     dr["Type"] = evtData.call_type.ToString();
                                     dr["Name"] = string.IsNullOrEmpty(evtData.calling_party_name) ? evtData.dialback_number : evtData.calling_party_name;
                                     dr["Number"] = evtData.dialback_number;
                                     dr["DateTime"] = evtData.call_timestamp.ToString("dd-MM-yyyy hh:mm:ss");
                                     dr["Duration"] = evtData.duration;
                                     dt.Rows.Add(dr);
                                     dt.AcceptChanges();

                                     DisplayCallLogs(dt);
                                 }
                             }
                        }
                        break;
                }
            }
        }

        private bool Login()
        {
            responseDetails = new LoginResponseDetails();

            userLoginRequest obj = new userLoginRequest();
            LoginSubscriptionRequest req = new LoginSubscriptionRequest();
            req.eventTypes = new EventType[] { EventType.CallControlFeaturesEvents, EventType.CallLogEvents, EventType.PhysicalDeviceFeaturesEvents, EventType.DeviceMaintenanceEvents, EventType.VoicemailServicesEvents, EventType.CapabilityExchangeServicesCallbackEvents, EventType.SystemServicesCallbackEvents, EventType.MonitoringServicesCallbackEvents, EventType.IOServicesFeaturesCallbackEvents, EventType.LogicalDeviceFeaturesEvents, EventType.SnapshotServicesCallbackEvents, EventType.CallAssociatedFeaturesEvents, EventType.LogoutEvents, EventType.PresenceEvents, EventType.DirectoryEvents, EventType.RecordingServicesEvents, EventType.ImEvents, EventType.PhotoChangeEvents, EventType.IPOConfigChangeEvents };

            req.httpMethod = HttpMethod.WEBSOCKET;
            req.httpMethodSpecified = true;

            obj.loginSubscriptionRequest = req;
            obj.applicationName = "AvayaIPOfficePlugin";
            obj.userName = this.sampleSettings.UserId;
            obj.userPassword = this.sampleSettings.Password;
            obj.applicationVersion = this.sampleSettings.AppVersion;

            Serializer serializer = new Serializer();

            HttpStatusCode requestStatus = HttpStatusCode.Continue;
            String postData = serializer.Serialize(obj);
            string response = RequestREST.Send(this.sampleSettings, "/inyama/service/session?debug=true", postData, HTTPMethod.POST, "", out requestStatus);
            responseDetails.serverResponse = response;

            if (requestStatus == HttpStatusCode.OK || requestStatus == HttpStatusCode.Accepted)
            {
                XmlDocument doc = new XmlDocument();
                doc.LoadXml(response);
                Deserilizer deserializer = new Deserilizer();
                Object responseObj = deserializer.Deserlize("userLoginResponse", doc.InnerXml);

                if (responseObj != null)
                {
                    userLoginResponse loginResponse = (userLoginResponse)responseObj;
                    if (loginResponse != null)
                    {
                        if (!string.IsNullOrEmpty(loginResponse.clientSessionID))
                        {
                            responseDetails.sessionId = loginResponse.clientSessionID;
                            responseDetails.serverVersion = loginResponse.applicationVersion;
                            responseDetails.loginFailureCode = loginResponse.loginFailureCode;
                            responseDetails.webSocketWssUrl = loginResponse.webSocketWssUrl;
                            responseDetails.webSocketWsUrl = loginResponse.webSocketWsUrl;
                            responseDetails.switchDevice = loginResponse.userSwitchDevice;
                            responseDetails.userExtension = loginResponse.userExtension;
                            responseDetails.isLoggedIn = true;
                        }
                    }
                }
            }

            return responseDetails.isLoggedIn;
        }

        private void Logout()
        {
            if (responseDetails != null && responseDetails.isLoggedIn == true)
            {
                if (service.IsStarted) { service.Stop(); }

                userLoginRequest obj = new userLoginRequest();
                obj.applicationName = "AvayaIPOfficePlugin";
                obj.userName = this.sampleSettings.UserId;
                obj.userPassword = this.sampleSettings.Password;
                Serializer serializer = new Serializer();

                HttpStatusCode requestStatus = HttpStatusCode.Continue;
                String postData = serializer.Serialize(obj);
                string response = RequestREST.Send(this.sampleSettings, "/inyama/service/session", postData, HTTPMethod.DELETE, "", out requestStatus);
                responseDetails.isLoggedIn = false;
            }
        }
        private void BtnClose_Click(object sender, EventArgs e)
        {
            Logout();
            this.Close();
        }

        private class LoginResponseDetails
        {
            public string sessionId { get; set; }
            public string serverVersion { get; set; }
            public userLoginResponseLoginFailureCode loginFailureCode { get; set; }
            public string webSocketWssUrl { get; set; }
            public string webSocketWsUrl { get; set; }
            public string serverResponse { get; set; }
            public bool isLoggedIn { get; set; }
            public string userExtension { get; set; }
            public string switchDevice { get; set; }
        }

        private void CallLogForm_FormClosing(object sender, FormClosingEventArgs e)
        {
            Logout();
        }
    }
}
