﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Diagnostics;
using System.Drawing;
using System.Linq;
using System.Net;
using System.Text;
using System.Threading;
using System.Threading.Tasks;
using System.Windows.Forms;
using System.Xml;

namespace OneXOpenAPISample
{
    public partial class DirectoryForm : Form
    {
        private ServerSettings sampleSettings;
        private LoginResponseDetails responseDetails;
        private RESTRequest RequestREST = new RESTRequest();

        public DirectoryForm(ServerSettings SampleSettings)
        {
            InitializeComponent();
            this.sampleSettings = SampleSettings;
            txtServer.Text = this.sampleSettings.Server;
            txtPort.Text = this.sampleSettings.Port + " (" + (this.sampleSettings.Secure ? "Secure" : "UnSecure") + ")";
            txtUserId.Text = this.sampleSettings.UserId;
            txtPassword.Text = this.sampleSettings.Password;
            lblWait.Visible = false;
        }

        private void BtnGetDirectory_Click(object sender, EventArgs e)
        {
            lblWait.Visible = true;
            if(Login() == true)
            {
                HttpStatusCode requestStatus = HttpStatusCode.Continue;
                string response = RequestREST.Send(this.sampleSettings, "/inyama/service/directory/system", "", HTTPMethod.GET, this.responseDetails.sessionId, out requestStatus);
                responseDetails.serverResponse = response;
                txtServerResponse.Text = response;

                if (requestStatus == HttpStatusCode.OK || requestStatus == HttpStatusCode.Accepted)
                {
                    XmlDocument doc = new XmlDocument();
                    doc.LoadXml(response);
                    Deserilizer deserializer = new Deserilizer();
                    Object responseObj = deserializer.Deserlize("directorySearchResponse", doc.InnerXml);
                    DataTable dt = new DataTable();
                    dt.Columns.Add(new DataColumn() { ColumnName = "Contact Name", ReadOnly = true});
                    dt.Columns.Add(new DataColumn() { ColumnName = "Contact Number", ReadOnly = true});
                    if (responseObj != null)
                    {
                        foreach (directoryContact entry in ((directorySearchResponse)responseObj).list)
                        {
                            DataRow dr = dt.NewRow();
                            dr[0] = entry.firstName;
                            dr[1] = entry.workPhone;
                            dt.Rows.Add(dr);
                        }
                        dt.AcceptChanges();
                    }
                    dataGridView1.DataSource = dt.DefaultView;
                    dataGridView1.Columns[0].Width = 160;
                    dataGridView1.Columns[1].Width = 160;
                }
                Logout();
            }
            lblWait.Visible = false;
        }

        private bool Login()
        {
            responseDetails = new LoginResponseDetails();

            userLoginRequest obj = new userLoginRequest();
            LoginSubscriptionRequest req = new LoginSubscriptionRequest();
            req.eventTypes = new EventType[] { EventType.CallControlFeaturesEvents, EventType.CallLogEvents, EventType.PhysicalDeviceFeaturesEvents, EventType.DeviceMaintenanceEvents, EventType.VoicemailServicesEvents, EventType.CapabilityExchangeServicesCallbackEvents, EventType.SystemServicesCallbackEvents, EventType.MonitoringServicesCallbackEvents, EventType.IOServicesFeaturesCallbackEvents, EventType.LogicalDeviceFeaturesEvents, EventType.SnapshotServicesCallbackEvents, EventType.CallAssociatedFeaturesEvents, EventType.LogoutEvents, EventType.PresenceEvents, EventType.DirectoryEvents, EventType.RecordingServicesEvents, EventType.ImEvents, EventType.PhotoChangeEvents, EventType.IPOConfigChangeEvents };

            req.httpMethod = HttpMethod.WEBSOCKET;
            req.httpMethodSpecified = true;

            obj.loginSubscriptionRequest = req;
            obj.applicationName = "AvayaIPOfficePlugin";
            obj.userName = this.sampleSettings.UserId;
            obj.userPassword = this.sampleSettings.Password;
            obj.applicationVersion = this.sampleSettings.AppVersion;

            Serializer serializer = new Serializer();

            HttpStatusCode requestStatus = HttpStatusCode.Continue;
            String postData = serializer.Serialize(obj);
            string response = RequestREST.Send(this.sampleSettings, "/inyama/service/session?debug=true", postData, HTTPMethod.POST, "", out requestStatus);
            responseDetails.serverResponse = response;

            if (requestStatus == HttpStatusCode.OK || requestStatus == HttpStatusCode.Accepted)
            {
                XmlDocument doc = new XmlDocument();
                doc.LoadXml(response);
                Deserilizer deserializer = new Deserilizer();
                Object responseObj = deserializer.Deserlize("userLoginResponse", doc.InnerXml);

                if (responseObj != null)
                {
                    userLoginResponse loginResponse = (userLoginResponse)responseObj;
                    if (loginResponse != null)
                    {
                        if (!string.IsNullOrEmpty(loginResponse.clientSessionID))
                        {
                            responseDetails.sessionId = loginResponse.clientSessionID;
                            responseDetails.serverVersion = loginResponse.applicationVersion;
                            responseDetails.loginFailureCode = loginResponse.loginFailureCode;
                            responseDetails.webSocketWssUrl = loginResponse.webSocketWssUrl;
                            responseDetails.webSocketWsUrl = loginResponse.webSocketWsUrl;
                            responseDetails.isLoggedIn = true;
                        }
                    }
                }
            }

            return responseDetails.isLoggedIn;
        }

        private void Logout()
        {
            if (responseDetails != null && responseDetails.isLoggedIn == true)
            {
                userLoginRequest obj = new userLoginRequest();
                obj.applicationName = "AvayaIPOfficePlugin";
                obj.userName = this.sampleSettings.UserId;
                obj.userPassword = this.sampleSettings.Password;
                Serializer serializer = new Serializer();

                HttpStatusCode requestStatus = HttpStatusCode.Continue;
                String postData = serializer.Serialize(obj);
                string response = RequestREST.Send(this.sampleSettings, "/inyama/service/session", postData, HTTPMethod.DELETE, "", out requestStatus);
                responseDetails.isLoggedIn = false;
            }
        }

        private void BtnClose_Click(object sender, EventArgs e)
        {
            this.Close();
        }

        private class LoginResponseDetails
        {
            public string sessionId { get; set; }
            public string serverVersion { get; set; }
            public userLoginResponseLoginFailureCode loginFailureCode { get; set; }
            public string webSocketWssUrl { get; set; }
            public string webSocketWsUrl { get; set; }
            public string serverResponse { get; set; }
            public bool isLoggedIn { get; set; }
        }

        private void DirectoryForm_FormClosing(object sender, FormClosingEventArgs e)
        {
            Logout();
        }
    }
}
