﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Net;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using System.Xml;

namespace OneXOpenAPISample
{
    public partial class LoginForm : Form
    {
        private ServerSettings sampleSettings;
        private LoginResponseDetails responseDetails;
        private RESTRequest RequestREST = new RESTRequest();

        public LoginForm(ServerSettings SampleSettings)
        {
            InitializeComponent();
            this.sampleSettings = SampleSettings;
            txtServer.Text = this.sampleSettings.Server;
            txtPort.Text = this.sampleSettings.Port + " (" + (this.sampleSettings.Secure ? "Secure" : "UnSecure") + ")";
            txtUserId.Text = this.sampleSettings.UserId;
            txtPassword.Text = this.sampleSettings.Password;
            tlpLoginResponse.Visible = false;
            lblWait.Visible = false;
        }

        private void BtnLogin_Click(object sender, EventArgs e)
        {
            lblWait.Visible = true;
            responseDetails = new LoginResponseDetails();

            userLoginRequest obj = new userLoginRequest();
            LoginSubscriptionRequest req = new LoginSubscriptionRequest();
            req.eventTypes = new EventType[] { EventType.CallControlFeaturesEvents, EventType.CallLogEvents, EventType.PhysicalDeviceFeaturesEvents, EventType.DeviceMaintenanceEvents, EventType.VoicemailServicesEvents, EventType.CapabilityExchangeServicesCallbackEvents, EventType.SystemServicesCallbackEvents, EventType.MonitoringServicesCallbackEvents, EventType.IOServicesFeaturesCallbackEvents, EventType.LogicalDeviceFeaturesEvents, EventType.SnapshotServicesCallbackEvents, EventType.CallAssociatedFeaturesEvents, EventType.LogoutEvents, EventType.PresenceEvents, EventType.DirectoryEvents, EventType.RecordingServicesEvents, EventType.ImEvents, EventType.PhotoChangeEvents, EventType.IPOConfigChangeEvents };

            req.httpMethod = HttpMethod.WEBSOCKET;
            req.httpMethodSpecified = true;

            obj.loginSubscriptionRequest = req;
            obj.applicationName = "AvayaIPOfficePlugin";
            obj.userName = this.sampleSettings.UserId;
            obj.userPassword = this.sampleSettings.Password;
            obj.applicationVersion = this.sampleSettings.AppVersion;

            Serializer serializer = new Serializer();

            HttpStatusCode requestStatus = HttpStatusCode.Continue;
            userLoginResponseLoginFailureCode loginFailureCode = userLoginResponseLoginFailureCode.UNKNOWN;
            String postData = serializer.Serialize(obj);
            string response = RequestREST.Send(this.sampleSettings, "/inyama/service/session", postData, HTTPMethod.POST, "", out requestStatus);
            responseDetails.serverResponse = response;

            if (requestStatus == HttpStatusCode.OK || requestStatus == HttpStatusCode.Accepted)
            {
                XmlDocument doc = new XmlDocument();
                doc.LoadXml(response);
                Deserilizer deserializer = new Deserilizer();
                Object responseObj = deserializer.Deserlize("userLoginResponse", doc.InnerXml);

                if (responseObj != null)
                {
                    userLoginResponse loginResponse = (userLoginResponse)responseObj;
                    if (loginResponse != null)
                    {
                        if (!string.IsNullOrEmpty(loginResponse.clientSessionID))
                        {
                            responseDetails.sessionId = loginResponse.clientSessionID;
                            responseDetails.serverVersion = loginResponse.applicationVersion;
                            responseDetails.loginFailureCode = loginResponse.loginFailureCode;
                            responseDetails.webSocketWssUrl = loginResponse.webSocketWssUrl;
                            responseDetails.webSocketWsUrl = loginResponse.webSocketWsUrl;
                            responseDetails.isLoggedIn = true;
                        }
                    }
                }
            }
            else
            {
                if (requestStatus == HttpStatusCode.Unauthorized || requestStatus == HttpStatusCode.InternalServerError || requestStatus == HttpStatusCode.ServiceUnavailable)
                {
                    Deserilizer deserializer = new Deserilizer();
                    Error error = (Error)deserializer.Deserlize("Error", response);
                    if (error != null)
                    {
                        loginFailureCode = GetFailureCode(error.errorCode);
                        if (error.errorCode == OpenApiErrorCode.UNSUPPORTED_APPLICATION_VERSION)
                            responseDetails.serverVersion = error.errorValue;
                    }
                    else
                    {
                        switch (requestStatus)
                        {
                            case HttpStatusCode.Unauthorized:
                                loginFailureCode = userLoginResponseLoginFailureCode.UNAUTHORIZED;
                                break;
                            case HttpStatusCode.ServiceUnavailable:
                                loginFailureCode = userLoginResponseLoginFailureCode.SERVICE_UNAVAILABLE;
                                break;
                            case HttpStatusCode.InternalServerError:
                                loginFailureCode = userLoginResponseLoginFailureCode.SERVER_PROBLEM;
                                break;
                        }
                    }
                    responseDetails.loginFailureCode = loginFailureCode;
                }
                else
                {
                    loginFailureCode = userLoginResponseLoginFailureCode.UNKNOWN;
                    responseDetails.loginFailureCode = loginFailureCode;
                }
            }
            DisplayLoginResponse(responseDetails);

            if (responseDetails.isLoggedIn) { Logout();}
            lblWait.Visible = false;
        }

        private void DisplayLoginResponse(LoginResponseDetails responseDetails)
        {
            lblFailureCode.Text = responseDetails.loginFailureCode.ToString();
            lblSessionId.Text = responseDetails.sessionId;
            lblServerVersion.Text = responseDetails.serverVersion;
            lblWebSocketUrl1.Text = responseDetails.webSocketWssUrl;
            lblWebSocketUrl2.Text = responseDetails.webSocketWsUrl;
            txtServerResponse.Text = responseDetails.serverResponse;
            
            tlpLoginResponse.Visible = true;
        }

        private userLoginResponseLoginFailureCode GetFailureCode(OpenApiErrorCode errorValue)
        {
            switch (errorValue)
            {
                case OpenApiErrorCode.NONE:
                    return userLoginResponseLoginFailureCode.NONE;

                case OpenApiErrorCode.INVALID_CREDENTIALS:
                    return userLoginResponseLoginFailureCode.INVALID_CREDENTIALS;

                case OpenApiErrorCode.ALREADY_LOGED_IN:
                    return userLoginResponseLoginFailureCode.ALREADY_LOGED_IN;

                case OpenApiErrorCode.LICENSE_NOT_AVAILABLE:
                    return userLoginResponseLoginFailureCode.LICENSE_NOT_AVAILABLE;

                case OpenApiErrorCode.SERVER_PROBLEM:
                    return userLoginResponseLoginFailureCode.SERVER_PROBLEM;

                case OpenApiErrorCode.UNKNOWN:
                    return userLoginResponseLoginFailureCode.UNKNOWN;

                case OpenApiErrorCode.SYSTEM_STARTUP_IN_PROGRESS:
                    return userLoginResponseLoginFailureCode.SYSTEM_NOT_UP;

                case OpenApiErrorCode.SYSTEM_DOWN:
                    return userLoginResponseLoginFailureCode.SYSTEM_DOWN;

                case OpenApiErrorCode.USER_CONFIGURATION_PROBLEM:
                    return userLoginResponseLoginFailureCode.USER_CONFIGURATION_PROBLEM;

                case OpenApiErrorCode.CSTA_PROVIDER_NOT_AVAILABLE:
                    return userLoginResponseLoginFailureCode.CSTA_PROVIDER_NOT_AVAILABLE;

                case OpenApiErrorCode.CSTA_RESOURCE_NOT_AVAILABLE:
                    return userLoginResponseLoginFailureCode.CSTA_RESOURCE_NOT_AVAILABLE;

                case OpenApiErrorCode.SESSION_ERROR:
                    return userLoginResponseLoginFailureCode.SESSION_ERROR;

                case OpenApiErrorCode.UNAUTHORIZED:
                    return userLoginResponseLoginFailureCode.UNAUTHORIZED;

                case OpenApiErrorCode.UNSUPPORTED_APPLICATION_VERSION:
                    return userLoginResponseLoginFailureCode.UNAUTHORIZED;

                case OpenApiErrorCode.PREFFERED_EDITION_LICENSE_NOT_AVAILABLE:
                    return userLoginResponseLoginFailureCode.PREFERRED_EDITION_LICENSE_NOT_AVAILABLE;

                case OpenApiErrorCode.FORCE_NEW_PASSWORD:
                    return userLoginResponseLoginFailureCode.FORCE_NEW_PASSWORD;

                default:
                    return userLoginResponseLoginFailureCode.UNKNOWN;
            }
        }

        private void Logout()
        {
            if (responseDetails != null && responseDetails.isLoggedIn == true)
            {
                userLoginRequest obj = new userLoginRequest();
                obj.applicationName = "AvayaIPOfficePlugin";
                obj.userName = this.sampleSettings.UserId;
                obj.userPassword = this.sampleSettings.Password;
                Serializer serializer = new Serializer();

                HttpStatusCode requestStatus = HttpStatusCode.Continue;
                String postData = serializer.Serialize(obj);
                string response = RequestREST.Send(this.sampleSettings, "/inyama/service/session", postData, HTTPMethod.DELETE, "", out requestStatus);
                responseDetails.isLoggedIn = false; 
            }
        }

        private void BtnClose_Click(object sender, EventArgs e)
        {
            this.Close();
        }

        private class LoginResponseDetails
        {
            public string sessionId { get; set; }
            public string serverVersion { get; set; }
            public userLoginResponseLoginFailureCode loginFailureCode { get; set; }
            public string webSocketWssUrl { get; set; }
            public string webSocketWsUrl { get; set; }
            public string serverResponse { get; set; }
            public bool isLoggedIn { get; set; }
        }

        private void LoginForm_FormClosing(object sender, FormClosingEventArgs e)
        {
            Logout();
        }
    }
}
