﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Net.Security;
using System.Text;
using System.Threading.Tasks;

namespace OneXOpenAPISample
{
    public class Utilities
    {
        public static bool CertificateValidationCallback(object sender, System.Security.Cryptography.X509Certificates.X509Certificate certification, System.Security.Cryptography.X509Certificates.X509Chain chain, SslPolicyErrors sslPolicyErrors)
        {
            bool retVal = false;
            bool sslCertError = false;
            try
            {
                if (((sslPolicyErrors & SslPolicyErrors.None) == SslPolicyErrors.None) ||
                            ((sslPolicyErrors & SslPolicyErrors.RemoteCertificateChainErrors) == SslPolicyErrors.RemoteCertificateChainErrors))
                {
                    sslCertError = false;
                }
                DateTime dtEnd = DateTime.Parse(certification.GetExpirationDateString());
                DateTime dtStart = DateTime.Parse(certification.GetEffectiveDateString());

                if (dtStart > DateTime.Now || dtEnd < DateTime.Now)
                {
                    retVal = false;
                    return retVal;
                }

                if (sslCertError == false)
                {
                    retVal = true;
                }
            }
            catch (Exception ex)
            {
                retVal = false;
            }

            return retVal;
        }
    }
}
