/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.alarming.datamgr;

import com.avaya.asm.alarming.PollingAlarm;
import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.exceptions.SMIdentityException;
import com.avaya.common.logging.helper.EventCode;

public class DAOAsmIdentityAlarm
extends PollingAlarm {
    private static final int scaleVal = 3;
    private static final long PRE_ALARM_RETRY_INTERVAL = 60000L;
    private static final long POST_ALARM_RETRY_INTERVAL = 3600000L;
    private static int RETRY_COUNT = 10;

    protected long getPreAlarmRetryInterval() {
        SMIdentityException smIdEx = (SMIdentityException)this.exception;
        if (smIdEx.getInstanceEverResolved()) {
            return 60000L;
        }
        return 180000L;
    }

    @Override
    public Object[] getAlarmEventArgs() {
        SMIdentityException smIdEx = (SMIdentityException)this.exception;
        return new Object[]{this.guiPage, smIdEx.getSMName()};
    }

    @Override
    public EventCode getAlarmEventCode() {
        SMIdentityException smIdEx = (SMIdentityException)this.exception;
        if (smIdEx.getSMName() == null) {
            return AsmLogger.OP_CDAO50011;
        }
        return AsmLogger.OP_CDAO50012;
    }

    @Override
    public Object[] getClearEventArgs() {
        return null;
    }

    @Override
    public EventCode getClearEventCode() {
        RETRY_COUNT = 0;
        SMIdentityException smIdEx = (SMIdentityException)this.exception;
        if (smIdEx.getSMName() == null) {
            return AsmLogger.OP_CDAO50016;
        }
        return AsmLogger.OP_CDAO50015;
    }

    @Override
    public long getPostAlarm_RetryInterval() {
        return 3600000L;
    }

    @Override
    public int getPreAlarm_MaxRetryCount() {
        return RETRY_COUNT;
    }

    @Override
    public long getPreAlarm_RetryInterval() {
        return 60000L;
    }

    @Override
    public Object[] getWarnEventArgs() {
        return null;
    }

    @Override
    public EventCode getWarnEventCode() {
        return null;
    }

    @Override
    public boolean isSingularFailure() {
        return true;
    }
}

