/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr;

import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.DataMgr;
import com.avaya.asm.datamgr.LoadBalancerAPI;
import com.avaya.asm.datamgr.LoadBalancerDM;
import com.avaya.asm.datamgr.SMCallHistoryDM;
import com.avaya.asm.datamgr.dao.ustore.factory.UstoreDAOFactory;
import com.avaya.asm.datamgr.dynamic.DynamicDataMgr;
import com.avaya.asm.datamgr.helpers.CassandraConnectionInfo;
import com.avaya.common.logging.client.Logger;
import com.avaya.ustore.objectapi.LoadBalancerData;
import java.net.InetAddress;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class SMLoadBalancerDM
extends DynamicDataMgr
implements LoadBalancerAPI {
    private final Logger log = AsmLogger.getLogger(SMLoadBalancerDM.class);
    private LoadBalancerDM loadBalancerDM = new LoadBalancerDM(this.getCassandraConnectionInfo());

    public LoadBalancerDM getLoadBalancerDM() {
        return this.loadBalancerDM;
    }

    public void setLoadBalancerDM(LoadBalancerDM loadBalancerDM) {
        this.loadBalancerDM = loadBalancerDM;
    }

    protected CassandraConnectionInfo getCassandraConnectionInfo() {
        return new CassandraConnectionInfo(UstoreDAOFactory.DFLT_HOST, UstoreDAOFactory.DFLT_CQL_PORT, UstoreDAOFactory.DFLT_JMX_PORT, null, CassandraConnectionInfo.ConnectionManagementPolicy.LOCAL_HOST_DC_ROUND_ROBIN);
    }

    @Override
    public String queryResolvedAddress(long loadBalancerId, String key) throws DMException {
        String fcn_name = "queryResolvedAddress";
        boolean isFiner = this.log.isFinerEnabled();
        String resolvedAddress = null;
        if (isFiner) {
            this.log.finer((Object)("queryResolvedAddress: enter with loadbalanerId=" + loadBalancerId + ", key=" + key));
        }
        resolvedAddress = this.loadBalancerDM.queryResolvedAddress(loadBalancerId, key);
        if (isFiner) {
            this.log.finer((Object)("queryResolvedAddress: Leave with resolvedAddress=" + resolvedAddress));
        }
        return resolvedAddress;
    }

    @Override
    public List<String> getAllKeysByResolvedAddress(long loadBalancerId, String addr) throws DMException {
        String fcn_name = "getAllKeysByResolvedAddress";
        boolean isFiner = this.log.isFinerEnabled();
        List<String> resolvedAddrList = null;
        if (isFiner) {
            this.log.finer((Object)("getAllKeysByResolvedAddress: enter with loadBalancerId=" + loadBalancerId + ", addr=" + addr));
        }
        resolvedAddrList = this.loadBalancerDM.getAllKeysByResolvedAddress(loadBalancerId, addr);
        if (isFiner) {
            this.log.finer("getAllKeysByResolvedAddress: Leave with resolvedAddrList.size=" + resolvedAddrList == null ? null : Integer.valueOf(resolvedAddrList.size()));
        }
        return resolvedAddrList;
    }

    @Override
    public String setResolvedAddress(long loadBalancerId, String key, String addr, LoadBalancerAPI.ConsistencyScope cScope) throws DMException {
        String fcn_name = "setResolvedAddress";
        boolean isFiner = this.log.isFinerEnabled();
        String resolved_address = null;
        if (isFiner) {
            this.log.finer((Object)("setResolvedAddress: enter with loadbalanerId=" + loadBalancerId + ", key=" + key + ", addr=" + addr + ", cScope=" + (Object)((Object)cScope)));
        }
        resolved_address = this.loadBalancerDM.setResolvedAddress(loadBalancerId, key, addr, cScope);
        if (isFiner) {
            this.log.finer((Object)("setResolvedAddress: Leave with resolved_address=" + resolved_address));
        }
        return resolved_address;
    }

    @Override
    public String compareAndSetResolvedAddress(long loadBalancerId, String key, String expect, String update, LoadBalancerAPI.ConsistencyScope cScope) throws DMException {
        String fcn_name = "compareAndSetResolvedAddress";
        boolean isFiner = this.log.isFinerEnabled();
        String resolved_address = null;
        if (isFiner) {
            this.log.finer((Object)("compareAndSetResolvedAddress: enter with loadbalanerId=" + loadBalancerId + ", key=" + key + ", expect=" + expect + ", update=" + update + ", cScope=" + (Object)((Object)cScope)));
        }
        resolved_address = this.loadBalancerDM.compareAndSetResolvedAddress(loadBalancerId, key, update, expect, cScope);
        if (isFiner) {
            this.log.finer((Object)("compareAndSetResolvedAddress: Leave with resolved_address=" + resolved_address));
        }
        return resolved_address;
    }

    @Override
    public void init() {
        this.log.info((Object)"Started initializing SMLoadBalancerDM");
        DataMgr.Status status = DataMgr.Status.OKAY;
        for (SMCallHistoryDM.dmTypes dm : SMCallHistoryDM.dmTypes.values()) {
            DataMgr dataMgr = dm.get();
            if (dataMgr.okay()) continue;
            status = DataMgr.Status.FAIL;
            this.log.error((Object)("Failed to init: " + dm));
        }
        this.setStatus(status);
        this.log.info((Object)"Finished initializing SMLoadBalancerDM");
    }

    @Override
    public void deleteByResolvedAddress(long loadBalancerId, String addr) throws DMException {
        String fcn_name = "deleteByResolvedAddress";
        boolean isFiner = this.log.isFinerEnabled();
        if (isFiner) {
            this.log.finer((Object)("deleteByResolvedAddress: enter with loadBalancerId=" + loadBalancerId + " and addr=" + addr));
        }
        this.loadBalancerDM.deleteByResolvedAddress(loadBalancerId, addr);
        if (isFiner) {
            this.log.finer((Object)"deleteByResolvedAddress: Leave ");
        }
    }

    @Override
    public void resolvedAddressByLoadbalancerId(long loadBalancerId, Map<String, String> resolvedAddressesByloadbalancerId) throws DMException {
        String fcn_name = "resolvedAddressByLoadbalacerId";
        boolean isFiner = this.log.isFinerEnabled();
        if (isFiner) {
            this.log.finer((Object)("resolvedAddressByLoadbalacerId: enter with loadBalancerId=" + loadBalancerId + " resolvedAddressByLoadBalancerId.size=" + resolvedAddressesByloadbalancerId.size()));
        }
        this.loadBalancerDM.resolvedAddressByLoadbalancerId(loadBalancerId, resolvedAddressesByloadbalancerId);
        if (isFiner) {
            this.log.finer((Object)"resolvedAddressByLoadbalacerId: Leave ");
        }
    }

    @Override
    public void touch(long loadBalancerId, String key) throws DMException {
        String fcn_name = "touch";
        boolean isFiner = this.log.isFinerEnabled();
        if (isFiner) {
            this.log.finer((Object)("touch: enter with loadBalancerId=" + loadBalancerId + " and key=" + key));
        }
        this.loadBalancerDM.touch(loadBalancerId, key);
        if (isFiner) {
            this.log.finer((Object)"touch: Leave ");
        }
    }

    @Override
    public int getDefaultTimeToLive() throws DMException {
        String fcn_name = "getDefaultTimeToLive";
        boolean isFiner = this.log.isFinerEnabled();
        if (isFiner) {
            this.log.finer((Object)"getDefaultTimeToLive: enter");
        }
        int defaultTimeToLive = this.loadBalancerDM.getDefaultTimeToLive();
        if (isFiner) {
            this.log.finer((Object)("getDefaultTimeToLive: Leave with defaultTimeToLive " + defaultTimeToLive));
        }
        return defaultTimeToLive;
    }

    @Override
    public void getAllRecordsByLocalTokenRanges(List<InetAddress> downNodes, Collection<LoadBalancerData> lbDataRecs, LoadBalancerAPI.DataFilter filter) throws DMException {
        String fcn_name = "getAllRecordsByLocalTokenRanges";
        boolean isFiner = this.log.isFinerEnabled();
        if (isFiner) {
            this.log.finer((Object)("getAllRecordsByLocalTokenRanges: enter, downNodes=" + downNodes));
        }
        this.loadBalancerDM.getAllRecordsByLocalTokenRanges(downNodes, lbDataRecs, filter);
        if (isFiner) {
            this.log.finer((Object)("getAllRecordsByLocalTokenRanges: leave, lbDataRecs.size=" + lbDataRecs.size()));
        }
    }

    @Override
    public void deleteResolvedAddresses(long loadBalancerId, Collection<String> keys) throws DMException {
        String fcn_name = "deleteResolvedAddresses";
        boolean isFiner = this.log.isFinerEnabled();
        if (isFiner) {
            this.log.finer((Object)("deleteResolvedAddresses: enter, keys.size=" + keys.size()));
        }
        this.loadBalancerDM.deleteResolvedAddresses(loadBalancerId, keys);
        if (isFiner) {
            this.log.finer((Object)"deleteResolvedAddresses: leave");
        }
    }

    @Override
    public void deleteResolvedAddresses(Collection<LoadBalancerData> lbDataRecords) throws DMException {
        String fcn_name = "deleteResolvedAddresses";
        boolean isFiner = this.log.isFinerEnabled();
        if (isFiner) {
            this.log.finer((Object)("deleteResolvedAddresses: enter, lbDataRecords.size=" + lbDataRecords.size()));
        }
        this.loadBalancerDM.deleteResolvedAddresses(lbDataRecords);
        if (isFiner) {
            this.log.finer((Object)"deleteResolvedAddresses: leave");
        }
    }
}

