/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.dao;

import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.SMConsole;
import com.avaya.asm.datamgr.DMUtilities;
import com.avaya.asm.datamgr.dao.InstanceDAO;
import com.avaya.asm.datamgr.dao.jdbc.ResultSetMapper;
import com.avaya.asm.datamgr.objectapi.AsmInstance;
import com.avaya.asm.datamgr.objectapi.Instance;
import com.avaya.common.logging.client.Logger;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;

public class AsmInstanceDAO
extends InstanceDAO {
    protected static final Logger log = AsmLogger.getLogger(AsmInstanceDAO.class);
    private static final String getInstances = "SELECT id, sipentity_id, managementaccesspointhostname, sm_type, is_monitoring, monitor_proactive_secs, monitor_reactive_secs, monitor_retries, monitor_okresponses, is_cdr_enabled, cdr_fileformat, cdr_usertouser_calls, cdr_incomplete_calls, err_on_notify_failure, honor_phase_equal_endpoint, adaptation_cm_tg_id, maincm_for_lsp_app_id, maintenance_mode, storage_cluster_id, aads_applicationsystem_id, syslog_server1, syslog_server2,cdr_password, log_rotation_days, compact_id FROM asminstance";
    private static final String getInstance = "SELECT id, sipentity_id, managementaccesspointhostname, sm_type, is_monitoring, monitor_proactive_secs, monitor_reactive_secs, monitor_retries, monitor_okresponses, is_cdr_enabled, cdr_fileformat, cdr_usertouser_calls, cdr_incomplete_calls, err_on_notify_failure, honor_phase_equal_endpoint, adaptation_cm_tg_id, maincm_for_lsp_app_id, maintenance_mode, storage_cluster_id, aads_applicationsystem_id, syslog_server1, syslog_server2,cdr_password, log_rotation_days, compact_id FROM asminstance WHERE id = ?";
    private static final ResultSetMapper instanceMapper = new ResultSetMapper(){

        @Override
        public Object mapResults(ResultSet rs) throws SQLException {
            ConcurrentHashMap<Long, AsmInstance> map = new ConcurrentHashMap<Long, AsmInstance>();
            while (rs.next()) {
                map.put(rs.getLong("id"), new AsmInstance(rs.getLong("id"), rs.getLong("sipentity_id"), rs.getString("managementaccesspointhostname"), !"SM".equalsIgnoreCase(rs.getString("sm_type")), rs.getBoolean("is_monitoring"), rs.getInt("monitor_proactive_secs"), rs.getInt("monitor_reactive_secs"), rs.getInt("monitor_retries"), rs.getInt("monitor_okresponses"), rs.getBoolean("is_cdr_enabled"), rs.getString("cdr_fileformat"), rs.getBoolean("cdr_usertouser_calls"), rs.getBoolean("cdr_incomplete_calls"), rs.getBoolean("err_on_notify_failure"), rs.getBoolean("honor_phase_equal_endpoint"), (Long)rs.getObject("adaptation_cm_tg_id"), (Long)rs.getObject("maincm_for_lsp_app_id"), rs.getBoolean("maintenance_mode"), (Long)rs.getObject("storage_cluster_id"), (Long)rs.getObject("aads_applicationsystem_id"), rs.getString("syslog_server1"), rs.getString("syslog_server2"), rs.getString("cdr_password"), rs.getObject("log_rotation_days", Integer.class), rs.getInt("compact_id")));
            }
            return map;
        }
    };

    @Override
    protected String getInstancesQuery() {
        return getInstances;
    }

    @Override
    protected String getInstanceQuery() {
        return getInstance;
    }

    @Override
    protected ResultSetMapper getMapper() {
        return instanceMapper;
    }

    @Override
    protected boolean tryResolveIdentity() {
        return DMUtilities.isSmInstance();
    }

    @Override
    public List<String> getDependentTables() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("asminstance");
        return list;
    }

    @SMConsole(description="Get the AsmInstance object for this Session Manager instance.")
    public AsmInstance getMyAsmInstance() {
        return (AsmInstance)this.getMyInstance();
    }

    @SMConsole(parameterNames={"asmInstanceId"}, description="Get the AsmInstance object for the given ID.")
    public AsmInstance getAsmInstance(Long asmInstanceId) {
        return (AsmInstance)this.getInstance(asmInstanceId);
    }

    @SMConsole(description="Get all provisioned Session Manager instances.")
    public Map<Long, Instance> getAllAsmInstances() {
        return this.getAllInstances();
    }

    @SMConsole(description="Get all provisioned Session Manager entities.")
    public Map<Long, Instance> getAllAsmEntities() {
        return this.getAllInstanceEntities();
    }

    public Vector<String> getInterClusterMemberIPs() {
        if (this.getMyInstance() == null) {
            return null;
        }
        List<Object> asmInstances = new ArrayList();
        if (!DMUtilities.isBranch()) {
            asmInstances = this.getAllCoreInstanceIPs();
        }
        return new Vector<String>(asmInstances);
    }
}

