/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.dao;

import com.avaya.asm.alarming.GenericAlarmHandler;
import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.SMConsole;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.DataMgr;
import com.avaya.asm.datamgr.dao.DataAccessObject;
import com.avaya.asm.datamgr.dao.jdbc.ResultSetMapper;
import com.avaya.asm.datamgr.dao.replication.DAOReplicationEvent;
import com.avaya.asm.datamgr.dao.replication.DAOTableEvent;
import com.avaya.common.logging.client.Logger;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CsDomainDAO
extends DataAccessObject {
    private static final Logger log = AsmLogger.getLogger(CsDomainDAO.class);
    private Map<Long, String> idMap = new HashMap<Long, String>();
    private Map<String, Long> nameMap = new HashMap<String, Long>();
    protected static final String getCsDomains = "SELECT id, domainname FROM csdomain";
    protected static final String getCsDomain = "SELECT domainname FROM csdomain WHERE id = ?";
    protected static final ResultSetMapper domainsMapper = new ResultSetMapper(){

        @Override
        public Object mapResults(ResultSet rs) throws SQLException {
            ArrayList list = new ArrayList();
            HashMap<Long, String> idMap = new HashMap<Long, String>();
            HashMap<String, Long> nameMap = new HashMap<String, Long>();
            while (rs.next()) {
                long id = rs.getLong("id");
                String name = rs.getString("domainname").toLowerCase();
                idMap.put(id, name);
                nameMap.put(name, id);
            }
            list.add(idMap);
            list.add(nameMap);
            return list;
        }
    };
    protected static final ResultSetMapper domainMapper = new ResultSetMapper(){

        @Override
        public Object mapResults(ResultSet rs) throws SQLException {
            if (rs.next()) {
                return rs.getString("domainname").toLowerCase();
            }
            return null;
        }
    };

    public CsDomainDAO() {
        super(false);
    }

    protected ResultSetMapper getDomainsMapper() {
        return domainsMapper;
    }

    protected ResultSetMapper getDomainMapper() {
        return domainMapper;
    }

    @Override
    protected Object getMainCollection() {
        return this.idMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void init() {
        HashMap nameMapTMP;
        HashMap idMapTMP;
        if (log.isFineEnabled()) {
            log.fine((Object)("Initializing " + CsDomainDAO.class.getSimpleName()));
        }
        Object[] params = new Object[]{};
        try {
            List list = (List)this.dataSource.executeQuery(getCsDomains, params, this.getDomainsMapper());
            idMapTMP = (HashMap)list.get(0);
            nameMapTMP = (HashMap)list.get(1);
            this.setStatus(DataMgr.Status.OKAY);
        }
        catch (DMException e) {
            this.setStatus(DataMgr.Status.FAIL);
            log.error((Object)("Error initializing " + this.getClass().getSimpleName()), (Throwable)e);
            GenericAlarmHandler.handleFailureEvent(this, e);
            return;
        }
        if (this.okay()) {
            try {
                this.lock.acquireWriteLock();
                this.idMap = idMapTMP;
                this.nameMap = nameMapTMP;
            }
            finally {
                this.lock.releaseWriteLock();
            }
        }
    }

    @Override
    public List<String> getDependentTables() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("csdomain");
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateDAO(DAOTableEvent event) {
        DAOReplicationEvent.OperationType operation = event.getOperation();
        String tableName = event.getTableName();
        Long id = event.getKey();
        if (log.isFineEnabled()) {
            log.fine((Object)this.logTag(operation, tableName, id));
        }
        String newDomain = null;
        boolean lockHeld = false;
        try {
            Object[] params;
            if (operation != DAOReplicationEvent.OperationType.DELETE && (newDomain = (String)this.dataSource.executeQuery(getCsDomain, params = new Object[]{id}, this.getDomainMapper())) != null && log.isFinerEnabled()) {
                log.finer((Object)("Retrieved new Domain " + newDomain));
            }
            this.lock.acquireWriteLock();
            lockHeld = true;
            String oldDomain = this.idMap.remove(id);
            if (oldDomain != null) {
                this.nameMap.remove(oldDomain);
            }
            if (newDomain != null) {
                this.idMap.put(id, newDomain);
                this.nameMap.put(newDomain, id);
            }
        }
        catch (Exception e) {
            if (lockHeld) {
                this.lock.releaseWriteLock();
                lockHeld = false;
            }
            log.error((Object)(this.logTag(operation, tableName, id) + "Error updating " + this.getClass().getSimpleName() + " object; re-initializing"), (Throwable)e);
            this.reinit();
            if (!this.okay()) {
                log.error((Object)(this.logTag(operation, tableName, id) + "Reinit NOT successful!"));
                return;
            }
        }
        finally {
            if (lockHeld) {
                this.lock.releaseWriteLock();
            }
        }
        if (log.isFineEnabled()) {
            log.fine((Object)(CsDomainDAO.class.getSimpleName() + " update successful"));
        }
    }

    public String getCsDomain(Long id) {
        try {
            this.lock.acquireReadLock();
            String string = this.idMap.get(id);
            return string;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    public Long getCsDomainId(String domain) {
        if (domain != null) {
            try {
                this.lock.acquireReadLock();
                Long l = this.nameMap.get(domain.toLowerCase());
                return l;
            }
            finally {
                this.lock.releaseReadLock();
            }
        }
        return null;
    }

    public Map<String, Long> getDomainNameMap() {
        try {
            this.lock.acquireReadLock();
            Map<String, Long> map = Collections.unmodifiableMap(this.nameMap);
            return map;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    @SMConsole(description="Get all provisioned CS Domains.")
    public Map<Long, String> getAllCsDomains() {
        try {
            this.lock.acquireReadLock();
            Map<Long, String> map = Collections.unmodifiableMap(this.idMap);
            return map;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }
}

