/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.dao;

import com.avaya.asm.core.SMConsole;
import com.avaya.asm.datamgr.dao.IsDeletedHandler;
import com.avaya.asm.datamgr.dao.LocalSipObjectDAO;
import com.avaya.asm.datamgr.dao.SetCommunityDAO;
import com.avaya.asm.datamgr.dao.replication.DAOTableEvent;
import com.avaya.asm.datamgr.objectapi.LocalCommProfileSet;
import com.avaya.asm.datamgr.objectapi.LocalObject;
import com.avaya.asm.datamgr.objectapi.SetCommunity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public class LocalCommProfileSetDAO
extends LocalSipObjectDAO {
    private String selectBase = "SELECT set.id, asm.id AS asmid FROM cscommprofileset set, cscommprofile cs, asmcommprofile asm, dyn_asmcommprofile dasm";
    private String whereBase = " WHERE cs.cscommprofilesetid = set.id AND asm.id = cs.id AND dasm.id = asm.id";
    private String filterNotDeletedUsers = " AND set.csuserid NOT IN (" + IsDeletedHandler.isDeletedCsUserId + ")";
    private String filterLocalUsers = " AND dasm.is_local = true";
    protected String getLocalIDsQuery = this.selectBase + this.whereBase + this.filterLocalUsers + this.filterNotDeletedUsers;
    protected String getDeletedByUserIdQuery = "SELECT u.isdeleted, set.id, asm.id AS asmid FROM csuser u, cscommprofileset set, cscommprofile cs, asmcommprofile asm, dyn_asmcommprofile dasm WHERE set.csuserid = u.id AND cs.cscommprofilesetid = set.id AND asm.id = cs.id AND dasm.id = asm.id AND dasm.is_local = true AND u.id = ?";
    private String filterNotDeletedUser = " AND set.csuserid = u.id AND u.isdeleted = false";
    protected String isLocalQuery = this.selectBase + ", csuser u" + this.whereBase + this.filterLocalUsers + this.filterNotDeletedUser + " AND asm.id = ?";

    @Override
    public void updateDAO(DAOTableEvent event) {
        if ("csuser".equals(event.getTableName()) || "dyn_asmcommprofile".equals(event.getTableName())) {
            ((SetCommunityDAO)this.getDataMgr(SetCommunityDAO.class)).updateDAO(event);
        }
        super.updateDAO(event);
    }

    @Override
    public void objectChanged(Object oldObject, Object newObject) {
        if (oldObject instanceof SetCommunity || newObject instanceof SetCommunity) {
            return;
        }
        super.objectChanged(oldObject, newObject);
    }

    @Override
    protected LocalObject construct(long id) {
        return new LocalCommProfileSet(id);
    }

    @Override
    protected String getMainTable() {
        return "cscommprofileset";
    }

    public Collection<Long> getLocalCommProfileSetIDsCopy() {
        ArrayList<Long> retVal = new ArrayList<Long>();
        this.lock.acquireReadLock();
        try {
            retVal.addAll(this.mainCollection.values());
        }
        finally {
            this.lock.releaseReadLock();
        }
        return retVal;
    }

    public int getLocalCommProfileSetCount() {
        this.lock.acquireReadLock();
        try {
            int n = this.mainCollection.size();
            return n;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    @SMConsole(description="Print a list of all local CommProfileSet IDs.")
    public Collection<Long> getLocalCommProfileSetIDs() {
        this.lock.acquireReadLock();
        try {
            Collection<Long> collection = Collections.unmodifiableCollection(this.mainCollection.values());
            return collection;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    @Override
    protected String getLocalIDsQuery() {
        return this.getLocalIDsQuery;
    }

    @Override
    protected String isLocalQuery() {
        return this.isLocalQuery;
    }

    @Override
    protected String getDeletedByUserIdQuery() {
        return this.getDeletedByUserIdQuery;
    }

    public static void main(String[] args) {
        LocalCommProfileSetDAO dao = new LocalCommProfileSetDAO();
        dao.printQueries();
    }
}

