/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.dao;

import com.avaya.asm.core.AsmCommon;
import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.DMFactory;
import com.avaya.asm.datamgr.dao.jdbc.DAOResult;
import com.avaya.asm.datamgr.dao.jdbc.JDBCBasedDAO;
import com.avaya.asm.datamgr.dao.jdbc.ResultSetMapper;
import com.avaya.asm.datamgr.objectapi.NameableDBObject;
import com.avaya.asm.datamgr.objectapi.ppm.AsmSipDeviceData;
import com.avaya.common.logging.client.Logger;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class OnDemandDAO {
    public static final String unknownName = "<Not Named>";
    private static final Logger log = AsmLogger.getLogger(OnDemandDAO.class);
    private static JDBCBasedDAO asmDataSource = null;
    private static JDBCBasedDAO asmLocalDataSource = null;
    private static final String NAME = "name";
    protected static final String getSetIdsForESH = "SELECT cscommprofilesetid FROM cscommprofile cs JOIN asmcommprofile asm ON asm.id=cs.id JOIN asmappsetassign appset ON (asm.origappset_id = appset.appset_id OR asm.termappset_id = appset.appset_id) AND appset.application_id = ?";
    protected static final String getSetIdsForAppSetAssign = "SELECT cscommprofilesetid FROM cscommprofile cs JOIN asmcommprofile asm ON asm.id=cs.id WHERE (origappset_id = ? OR termappset_id = ?)";
    protected static final String getAsmInstanceCount = "SELECT count(*) FROM asminstance";
    protected static final String getAnySipDeviceData = "SELECT id, device_id, datacategory, dataname, updatedatetime,  CASE WHEN datavalue_64k IS NULL THEN datavalue ELSE datavalue_64k END AS datavalue FROM asmsipdevicedata WHERE device_id = ?";

    public static void setAsmDataSource(JDBCBasedDAO dataSource) {
        if (!AsmCommon.jUnitEnvironment) {
            throw new IllegalArgumentException("Attempt to set \"asm\" DataSource outside JUnit!");
        }
        asmDataSource = dataSource;
    }

    public static void setAsmLocalDataSource(JDBCBasedDAO dataSource) {
        if (!AsmCommon.jUnitEnvironment) {
            throw new IllegalArgumentException("Attempt to set \"asmlocal\" DataSource outside JUnit!");
        }
        asmLocalDataSource = dataSource;
    }

    private static JDBCBasedDAO getAsmDataSource() {
        if (asmDataSource != null) {
            return asmDataSource;
        }
        return DMFactory.getInstance().getDataSource();
    }

    private static JDBCBasedDAO getAsmLocalDataSource() {
        if (asmLocalDataSource != null) {
            return asmLocalDataSource;
        }
        return DMFactory.getInstance().getLocalDataSource();
    }

    protected static final ResultSetMapper getFieldMapper(final String field) {
        return new ResultSetMapper(){

            @Override
            public Object mapResults(ResultSet rs) throws SQLException {
                String name = OnDemandDAO.unknownName;
                if (rs.next()) {
                    name = rs.getString(field);
                }
                return name;
            }
        };
    }

    protected static final ResultSetMapper getCommProfileSetMapper() {
        return new ResultSetMapper(){

            @Override
            public Object mapResults(ResultSet rs) throws SQLException {
                HashSet<Long> commProfileSetIds = new HashSet<Long>();
                while (rs.next()) {
                    commProfileSetIds.add(rs.getLong("cscommprofilesetid"));
                }
                return commProfileSetIds;
            }
        };
    }

    protected static final ResultSetMapper getAsmInstanceCountMapper() {
        return new ResultSetMapper(){

            @Override
            public Object mapResults(ResultSet rs) throws SQLException, DMException {
                Integer count = null;
                if (rs.next()) {
                    count = rs.getInt("count");
                }
                return count;
            }
        };
    }

    protected static String getFieldSqlStmt(String field, String table, Long id) {
        return "SELECT " + field + " FROM " + table + " WHERE id = " + id;
    }

    public static String getName(String table, Long id) {
        return OnDemandDAO.getField(NAME, table, id);
    }

    public static String getField(String field, String table, Long id) {
        String name = unknownName;
        String sqlStmt = OnDemandDAO.getFieldSqlStmt(field, table, id);
        Object[] params = new Object[]{};
        try {
            name = (String)OnDemandDAO.getAsmDataSource().executeQuery(sqlStmt, params, OnDemandDAO.getFieldMapper(field));
        }
        catch (DMException e) {
            log.error((Object)"Unable to obtain name.", (Throwable)e);
        }
        return name;
    }

    public static String getName(NameableDBObject namedObject) {
        return OnDemandDAO.getField(namedObject.getFieldName(), namedObject.getTableName(), namedObject.getId());
    }

    public static Set<Long> getCPSetIdsForESH(Long asmAppId) {
        Object[] params = new Object[]{asmAppId};
        HashSet<Long> commProfileSetIds = new HashSet();
        try {
            commProfileSetIds = (Set)OnDemandDAO.getAsmDataSource().executeQuery(getSetIdsForESH, params, OnDemandDAO.getCommProfileSetMapper());
        }
        catch (DMException e) {
            log.error((Object)("Error obtaining the list of CommProfileSet IDs for AsmApplication " + asmAppId), (Throwable)e);
        }
        return commProfileSetIds;
    }

    public static Set<Long> getCPSetIdsForAppSetAssign(Long appsetId) {
        Object[] params = new Object[]{appsetId, appsetId};
        HashSet<Long> commProfileSetIds = new HashSet();
        try {
            commProfileSetIds = (Set)OnDemandDAO.getAsmDataSource().executeQuery(getSetIdsForAppSetAssign, params, OnDemandDAO.getCommProfileSetMapper());
        }
        catch (DMException e) {
            log.error((Object)("Error obtaining the list of CommProfileSet IDs for AsmApplicationSet " + appsetId), (Throwable)e);
        }
        return commProfileSetIds;
    }

    public static synchronized String readAsmParam(String parameterName) {
        String parameterValue = null;
        String sqlStmt = "SELECT value FROM asmlocalparm WHERE name = '" + parameterName + "'";
        Object[] params = new Object[]{};
        try {
            parameterValue = (String)OnDemandDAO.getAsmLocalDataSource().executeQuery(sqlStmt, params, OnDemandDAO.getFieldMapper("value"));
        }
        catch (DMException e) {
            log.error((Object)"Unable to read parameter from asmlocalparm.", (Throwable)e);
        }
        return parameterValue;
    }

    public static synchronized boolean updateAsmParam(String parameterName, String parameterValue) {
        try {
            String sqlStmt = "UPDATE asmlocalparm SET value=? WHERE name=?";
            Object[] params = new Object[]{parameterValue, parameterName};
            DAOResult result = OnDemandDAO.getAsmLocalDataSource().executeUpdate(sqlStmt, params);
            if (result.empty()) {
                sqlStmt = "INSERT INTO asmlocalparm (name, value) VALUES (?, ?)";
                params = new Object[]{parameterName, parameterValue};
                result = OnDemandDAO.getAsmLocalDataSource().executeUpdate(sqlStmt, params);
            }
        }
        catch (DMException e) {
            log.error((Object)"could not update asmlocalparm table", (Throwable)e);
            return false;
        }
        return true;
    }

    public static int numAsmInstances() {
        String fcn_name = "numAsmInstances";
        try {
            Object[] params = new Object[]{};
            Integer count = (Integer)OnDemandDAO.getAsmDataSource().executeQuery(getAsmInstanceCount, params, OnDemandDAO.getAsmInstanceCountMapper());
            return count == null ? 0 : count;
        }
        catch (DMException e) {
            if (log.isFinestEnabled()) {
                log.finest((Object)"numAsmInstances: error obtaining asm instance count from db. This is normal if the database is empty and has not finished initial load", (Throwable)e);
            }
            return 0;
        }
    }

    protected static final ResultSetMapper getAnyDeviceDataMapper() {
        return new ResultSetMapper(){

            @Override
            public Object mapResults(ResultSet rs) throws SQLException {
                ArrayList<AsmSipDeviceData> deviceDataList = new ArrayList<AsmSipDeviceData>();
                while (rs.next()) {
                    AsmSipDeviceData deviceData = new AsmSipDeviceData(rs.getLong("id"), rs.getLong("device_id"), rs.getString("datacategory"), rs.getString("dataname"), rs.getTimestamp("updatedatetime"), rs.getString("datavalue"));
                    deviceDataList.add(deviceData);
                }
                return deviceDataList;
            }
        };
    }

    public static List<AsmSipDeviceData> getAnyDeviceData(Long deviceId, String category, String name) {
        String fcn_name = "getAnyDeviceData";
        Boolean isFiner = log.isFinerEnabled();
        long nanos = 0L;
        if (isFiner.booleanValue()) {
            log.finer((Object)("getAnyDeviceData: Enter with deviceId: " + deviceId + ", category: " + category + ", and name: " + name));
            nanos = System.nanoTime();
        }
        List deviceDataList = null;
        ArrayList<Object> paramList = new ArrayList<Object>(3);
        paramList.add(deviceId);
        String query = getAnySipDeviceData;
        if (category != null) {
            query = query + " AND datacategory = ?";
            paramList.add(category);
        }
        if (name != null) {
            query = query + " AND dataname = ?";
            paramList.add(name);
        }
        try {
            deviceDataList = (List)OnDemandDAO.getAsmDataSource().executeQuery(query, paramList.toArray(), OnDemandDAO.getAnyDeviceDataMapper());
        }
        catch (DMException e) {
            log.error((Object)("getAnyDeviceData: error obtaining AsmSipDeviceData for deviceId: " + deviceId + ", category: " + category + ", and name: " + name), (Throwable)e);
        }
        if (isFiner.booleanValue()) {
            log.finer((Object)("getAnyDeviceData: Leave: SQL query for deviceId: " + deviceId + ", category: " + category + ", and name: " + name + " took " + (System.nanoTime() - nanos) + " nsec."));
        }
        return deviceDataList;
    }
}

