/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.dao;

import com.avaya.asm.alarming.GenericAlarmHandler;
import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.SMConsole;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.DataMgr;
import com.avaya.asm.datamgr.dao.DataAccessObject;
import com.avaya.asm.datamgr.dao.jdbc.ResultSetMapper;
import com.avaya.asm.datamgr.dao.replication.DAOTableEvent;
import com.avaya.asm.datamgr.objectapi.PushNotificationApplication;
import com.avaya.common.logging.client.Logger;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class PushNotificationApplicationDAO
extends DataAccessObject {
    private static final Logger log = AsmLogger.getLogger(PushNotificationApplicationDAO.class);
    private Map<Long, PushNotificationApplication> pushNotificationAppMap = new HashMap<Long, PushNotificationApplication>();
    protected static final String getPushNotificationApplications = "SELECT id, name, application_identifier, asm_push_notification_provider_id FROM asm_push_notification_application";
    protected static final String getPushNotificationApplication = "SELECT id, name, application_identifier, asm_push_notification_provider_id FROM asm_push_notification_application WHERE id = ?";
    protected static final ResultSetMapper pushNotificationApplicationMapper = new ResultSetMapper(){

        @Override
        public Object mapResults(ResultSet rs) throws SQLException {
            ConcurrentHashMap<Long, PushNotificationApplication> appMap = new ConcurrentHashMap<Long, PushNotificationApplication>();
            while (rs.next()) {
                Long id = rs.getLong("id");
                appMap.put(id, new PushNotificationApplication(id, rs.getString("name"), rs.getString("application_identifier"), (Long)rs.getObject("asm_push_notification_provider_id")));
            }
            return appMap;
        }
    };

    public PushNotificationApplicationDAO() {
        super(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init() {
        Map pushNotificationAppMapTMP;
        if (log.isFineEnabled()) {
            log.fine((Object)("Initializing " + this.getClass().getSimpleName()));
        }
        Object[] params = new Object[]{};
        try {
            pushNotificationAppMapTMP = (Map)this.dataSource.executeQuery(getPushNotificationApplications, params, pushNotificationApplicationMapper);
        }
        catch (DMException e) {
            this.setStatus(DataMgr.Status.FAIL);
            log.error((Object)("Error initializing " + this.getClass().getSimpleName()), (Throwable)e);
            GenericAlarmHandler.handleFailureEvent(this, e);
            return;
        }
        try {
            this.lock.acquireWriteLock();
            this.pushNotificationAppMap = pushNotificationAppMapTMP;
            this.setStatus(DataMgr.Status.OKAY);
        }
        finally {
            this.lock.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void updateDAO(DAOTableEvent tableEvent) {
        block16: {
            operation = tableEvent.getOperation();
            tableName = tableEvent.getTableName();
            id = tableEvent.getKey();
            if (PushNotificationApplicationDAO.log.isFineEnabled()) {
                PushNotificationApplicationDAO.log.fine((Object)this.logTag(operation, tableName, id));
            }
            oldApplication = null;
            newApplication = null;
            this.lock.acquireWriteLock();
            locked = true;
            try {
                params = new Object[]{id};
                if (!"asm_push_notification_application".equals(tableName)) break block16;
                switch (2.$SwitchMap$com$avaya$asm$datamgr$dao$replication$DAOReplicationEvent$OperationType[operation.ordinal()]) {
                    case 1: {
                        oldApplication = this.pushNotificationAppMap.get(id);
                    }
                    case 2: {
                        newApplication = (PushNotificationApplication)((Map)this.dataSource.executeQuery("SELECT id, name, application_identifier, asm_push_notification_provider_id FROM asm_push_notification_application WHERE id = ?", params, PushNotificationApplicationDAO.pushNotificationApplicationMapper)).get(id);
                        if (newApplication == null) ** break;
                        this.pushNotificationAppMap.put(id, newApplication);
                        ** break;
lbl22:
                        // 1 sources

                        break;
                    }
                    case 3: {
                        oldApplication = this.pushNotificationAppMap.remove(id);
                        break;
                    }
                    ** default:
lbl27:
                    // 1 sources

                    break;
                }
            }
            catch (DMException e) {
                if (locked) {
                    this.lock.releaseWriteLock();
                    locked = false;
                }
                PushNotificationApplicationDAO.log.error((Object)(this.logTag(operation, tableName, id) + "Error updating " + this.getClass().getSimpleName() + " object; re-initializing"), (Throwable)e);
                this.reinit();
                if (!this.okay()) {
                    PushNotificationApplicationDAO.log.error((Object)(this.logTag(operation, tableName, id) + "Reinit not successful!"));
                    return;
                }
            }
            finally {
                if (locked) {
                    this.lock.releaseWriteLock();
                    locked = false;
                }
            }
        }
        if (oldApplication != null || newApplication != null) {
            this.updateListeners(oldApplication, newApplication);
        }
        if (PushNotificationApplicationDAO.log.isFineEnabled()) {
            PushNotificationApplicationDAO.log.fine((Object)(this.getClass().getSimpleName() + " update successful"));
        }
    }

    public PushNotificationApplication getPushNotificationApplication(Long id) {
        if (id == null) {
            return null;
        }
        try {
            this.lock.acquireReadLock();
            PushNotificationApplication pushNotificationApplication = this.pushNotificationAppMap.get(id);
            return pushNotificationApplication;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PushNotificationApplication getPushNotificationApplicationByAppIdentifier(String appId) {
        if (appId == null) {
            return null;
        }
        try {
            this.lock.acquireReadLock();
            for (PushNotificationApplication app : this.pushNotificationAppMap.values()) {
                if (!appId.equals(app.getApplicationIdentifier())) continue;
                PushNotificationApplication pushNotificationApplication = app;
                return pushNotificationApplication;
            }
        }
        finally {
            this.lock.releaseReadLock();
        }
        return null;
    }

    @SMConsole(description="Get all Push Notification Applications")
    public Map<Long, PushNotificationApplication> getAllPushNotificationApplications() {
        try {
            this.lock.acquireReadLock();
            Map<Long, PushNotificationApplication> map = Collections.unmodifiableMap(this.pushNotificationAppMap);
            return map;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    @Override
    public List<String> getDependentTables() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("asm_push_notification_application");
        return list;
    }

    @Override
    protected Object getMainCollection() {
        return this.pushNotificationAppMap;
    }
}

