/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.dao;

import com.avaya.asm.alarming.GenericAlarmHandler;
import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.SMConsole;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.DataMgr;
import com.avaya.asm.datamgr.dao.DataAccessObject;
import com.avaya.asm.datamgr.dao.jdbc.ResultSetMapper;
import com.avaya.asm.datamgr.dao.replication.DAOTableEvent;
import com.avaya.asm.datamgr.objectapi.PushNotificationProvider;
import com.avaya.common.logging.client.Logger;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class PushNotificationProviderDAO
extends DataAccessObject {
    private static final Logger log = AsmLogger.getLogger(PushNotificationProviderDAO.class);
    private Map<Long, PushNotificationProvider> pushNotificationProviderMap = new HashMap<Long, PushNotificationProvider>();
    protected static final String getPushNotificationProviders = "SELECT id, name, company_domain, address, port, system_id, key_private, key_public, use_fwd_proxy from asm_push_notification_provider";
    protected static final String getPushNotificationProvider = "SELECT id, name, company_domain, address, port, system_id, key_private, key_public, use_fwd_proxy from asm_push_notification_provider WHERE id = ?";
    protected static final ResultSetMapper pushNotificationProviderMapper = new ResultSetMapper(){

        @Override
        public Object mapResults(ResultSet rs) throws SQLException {
            ConcurrentHashMap<Long, PushNotificationProvider> providerMap = new ConcurrentHashMap<Long, PushNotificationProvider>();
            while (rs.next()) {
                Long id = rs.getLong("id");
                providerMap.put(id, new PushNotificationProvider(id, rs.getString("name"), rs.getString("company_domain"), rs.getString("address"), rs.getInt("port"), rs.getString("system_id"), rs.getString("key_private"), rs.getString("key_public"), rs.getBoolean("use_fwd_proxy")));
            }
            return providerMap;
        }
    };

    public PushNotificationProviderDAO() {
        super(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init() {
        Map pushNotificationProviderMapTMP;
        if (log.isFineEnabled()) {
            log.fine((Object)("Initializing " + this.getClass().getSimpleName()));
        }
        Object[] params = new Object[]{};
        try {
            pushNotificationProviderMapTMP = (Map)this.dataSource.executeQuery(getPushNotificationProviders, params, pushNotificationProviderMapper);
        }
        catch (DMException e) {
            this.setStatus(DataMgr.Status.FAIL);
            log.error((Object)("Error initializing " + this.getClass().getSimpleName()), (Throwable)e);
            GenericAlarmHandler.handleFailureEvent(this, e);
            return;
        }
        try {
            this.lock.acquireWriteLock();
            this.pushNotificationProviderMap = pushNotificationProviderMapTMP;
            this.setStatus(DataMgr.Status.OKAY);
        }
        finally {
            this.lock.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void updateDAO(DAOTableEvent tableEvent) {
        block15: {
            operation = tableEvent.getOperation();
            tableName = tableEvent.getTableName();
            id = tableEvent.getKey();
            if (PushNotificationProviderDAO.log.isFineEnabled()) {
                PushNotificationProviderDAO.log.fine((Object)this.logTag(operation, tableName, id));
            }
            oldProvider = null;
            newProvider = null;
            this.lock.acquireWriteLock();
            locked = true;
            try {
                params = new Object[]{id};
                if (!"asm_push_notification_provider".equals(tableName)) break block15;
                switch (2.$SwitchMap$com$avaya$asm$datamgr$dao$replication$DAOReplicationEvent$OperationType[operation.ordinal()]) {
                    case 1: {
                        oldProvider = this.pushNotificationProviderMap.get(id);
                    }
                    case 2: {
                        newProvider = (PushNotificationProvider)((Map)this.dataSource.executeQuery("SELECT id, name, company_domain, address, port, system_id, key_private, key_public, use_fwd_proxy from asm_push_notification_provider WHERE id = ?", params, PushNotificationProviderDAO.pushNotificationProviderMapper)).get(id);
                        if (newProvider == null) ** break;
                        this.pushNotificationProviderMap.put(id, newProvider);
                        ** break;
lbl22:
                        // 1 sources

                        break;
                    }
                    case 3: {
                        oldProvider = this.pushNotificationProviderMap.remove(id);
                        break;
                    }
                    ** default:
lbl27:
                    // 1 sources

                    break;
                }
            }
            catch (DMException e) {
                if (locked) {
                    this.lock.releaseWriteLock();
                    locked = false;
                }
                PushNotificationProviderDAO.log.error((Object)(this.logTag(operation, tableName, id) + "Error updating " + this.getClass().getSimpleName() + " object; re-initializing"), (Throwable)e);
                this.reinit();
                if (!this.okay()) {
                    PushNotificationProviderDAO.log.error((Object)(this.logTag(operation, tableName, id) + "Reinit not successful!"));
                    return;
                }
            }
            finally {
                if (locked) {
                    this.lock.releaseWriteLock();
                    locked = false;
                }
            }
        }
        this.updateListeners(oldProvider, newProvider);
        if (PushNotificationProviderDAO.log.isFineEnabled()) {
            PushNotificationProviderDAO.log.fine((Object)(this.getClass().getSimpleName() + " update successful"));
        }
    }

    public PushNotificationProvider getPushNotificationProvider(Long id) {
        if (id == null) {
            return null;
        }
        try {
            this.lock.acquireReadLock();
            PushNotificationProvider pushNotificationProvider = this.pushNotificationProviderMap.get(id);
            return pushNotificationProvider;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    @SMConsole(description="Get all Push Notification Providers")
    public Map<Long, PushNotificationProvider> getAllPushNotificationProviders() {
        try {
            this.lock.acquireReadLock();
            Map<Long, PushNotificationProvider> map = Collections.unmodifiableMap(this.pushNotificationProviderMap);
            return map;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    @Override
    public List<String> getDependentTables() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("asm_push_notification_provider");
        return list;
    }

    @Override
    protected Object getMainCollection() {
        return this.pushNotificationProviderMap;
    }
}

