/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.dao;

import com.avaya.asm.alarming.GenericAlarmHandler;
import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.SMConsole;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.DataMgr;
import com.avaya.asm.datamgr.dao.DataAccessObject;
import com.avaya.asm.datamgr.dao.jdbc.ResultSetMapper;
import com.avaya.asm.datamgr.dao.replication.DAOTableEvent;
import com.avaya.asm.datamgr.objectapi.SIPLoadBalancerRow;
import com.avaya.common.logging.client.Logger;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class SIPLoadBalancerDAO
extends DataAccessObject {
    private static final Logger log = AsmLogger.getLogger(SIPLoadBalancerDAO.class);
    protected Map<Long, SIPLoadBalancerRow> loadBalancerRowMap = new ConcurrentHashMap<Long, SIPLoadBalancerRow>();
    protected static final String getLoadBalancers = "SELECT id, ipt_cmcluster_id, name, modulename FROM routing_siploadbalancer";
    protected static final String getLoadBalancer = "SELECT id, ipt_cmcluster_id, name, modulename FROM routing_siploadbalancer WHERE id = ?";
    protected static final ResultSetMapper loadBalancerMapper = new ResultSetMapper(){

        @Override
        public Object mapResults(ResultSet rs) throws SQLException {
            ConcurrentHashMap<Long, SIPLoadBalancerRow> map = new ConcurrentHashMap<Long, SIPLoadBalancerRow>();
            while (rs.next()) {
                Long id = rs.getLong("id");
                map.put(id, new SIPLoadBalancerRow(id, (Long)rs.getObject("ipt_cmcluster_id"), rs.getString("name"), rs.getString("modulename")));
            }
            return map;
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void init() {
        Map loadBalancerRowMapTMP;
        if (log.isFineEnabled()) {
            log.fine((Object)("Initializing " + SIPLoadBalancerDAO.class.getSimpleName()));
        }
        Object[] params = new Object[]{};
        try {
            loadBalancerRowMapTMP = (Map)this.dataSource.executeQuery(getLoadBalancers, params, loadBalancerMapper);
        }
        catch (DMException e) {
            this.setStatus(DataMgr.Status.FAIL);
            log.error((Object)("Error initializing " + this.getClass().getSimpleName()), (Throwable)e);
            GenericAlarmHandler.handleFailureEvent(this, e);
            return;
        }
        try {
            this.lock.acquireWriteLock();
            this.setStatus(DataMgr.Status.OKAY);
            this.loadBalancerRowMap = loadBalancerRowMapTMP;
        }
        finally {
            this.lock.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void updateDAO(DAOTableEvent tableEvent) {
        block15: {
            operation = tableEvent.getOperation();
            tableName = tableEvent.getTableName();
            id = tableEvent.getKey();
            if (SIPLoadBalancerDAO.log.isFineEnabled()) {
                SIPLoadBalancerDAO.log.fine((Object)this.logTag(operation, tableName, id));
            }
            newLoadBalancer = null;
            oldLoadBalancer = null;
            this.lock.acquireWriteLock();
            locked = true;
            try {
                params = new Object[]{id};
                if (!"routing_siploadbalancer".equals(tableName)) break block15;
                switch (2.$SwitchMap$com$avaya$asm$datamgr$dao$replication$DAOReplicationEvent$OperationType[operation.ordinal()]) {
                    case 1: {
                        newLoadBalancer = (SIPLoadBalancerRow)((Map)this.dataSource.executeQuery("SELECT id, ipt_cmcluster_id, name, modulename FROM routing_siploadbalancer WHERE id = ?", params, SIPLoadBalancerDAO.loadBalancerMapper)).get(id);
                        if (newLoadBalancer == null) ** break;
                        this.loadBalancerRowMap.put(id, newLoadBalancer);
                        ** break;
lbl20:
                        // 1 sources

                        break;
                    }
                    case 2: {
                        newLoadBalancer = (SIPLoadBalancerRow)((Map)this.dataSource.executeQuery("SELECT id, ipt_cmcluster_id, name, modulename FROM routing_siploadbalancer WHERE id = ?", params, SIPLoadBalancerDAO.loadBalancerMapper)).get(id);
                        if (newLoadBalancer == null) ** break;
                        this.loadBalancerRowMap.put(id, newLoadBalancer);
                        ** break;
lbl27:
                        // 1 sources

                        break;
                    }
                    case 3: {
                        this.loadBalancerRowMap.remove(id);
                        break;
                    }
                    ** default:
lbl33:
                    // 1 sources

                    break;
                }
            }
            catch (DMException e) {
                if (locked) {
                    this.lock.releaseWriteLock();
                    locked = false;
                }
                SIPLoadBalancerDAO.log.error((Object)(this.logTag(operation, tableName, id) + "Error updating " + this.getClass().getSimpleName() + " object; re-initializing"), (Throwable)e);
                this.reinit();
                if (!this.okay()) {
                    SIPLoadBalancerDAO.log.error((Object)(this.logTag(operation, tableName, id) + "Reinit NOT successful!"));
                    return;
                }
            }
            finally {
                if (locked) {
                    this.lock.releaseWriteLock();
                }
            }
        }
        if (SIPLoadBalancerDAO.log.isFineEnabled()) {
            SIPLoadBalancerDAO.log.fine((Object)(this.getClass().getSimpleName() + " update successful"));
        }
    }

    @Override
    public List<String> getDependentTables() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("routing_siploadbalancer");
        return list;
    }

    public SIPLoadBalancerRow getLoadBalancer(Long id) {
        if (id == null) {
            return null;
        }
        try {
            this.lock.acquireReadLock();
            SIPLoadBalancerRow sIPLoadBalancerRow = this.loadBalancerRowMap.get(id);
            return sIPLoadBalancerRow;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    @SMConsole(description="Get all SIP load balancers")
    public Map<Long, SIPLoadBalancerRow> getAllSIPLoadBalancers() {
        try {
            this.lock.acquireReadLock();
            Map<Long, SIPLoadBalancerRow> map = Collections.unmodifiableMap(this.loadBalancerRowMap);
            return map;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    @Override
    protected Object getMainCollection() {
        return this.loadBalancerRowMap;
    }
}

