/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.dao.cassandra;

import com.datastax.driver.core.TableMetadata;
import java.util.UUID;

public class ColumnFamilyMetaData {
    private String ksName;
    private String name;
    private String fqName;
    private UUID cfId = null;
    private int defaultTimeToLive = 0;

    public ColumnFamilyMetaData(String ksname, String name) {
        this.ksName = ksname;
        this.name = name;
        this.fqName = ksname + '.' + name;
    }

    public ColumnFamilyMetaData(TableMetadata tbMd) {
        this.ksName = tbMd.getKeyspace().getName();
        this.name = tbMd.getName();
        this.fqName = this.ksName + '.' + this.name;
        this.cfId = tbMd.getId();
        this.defaultTimeToLive = tbMd.getOptions().getDefaultTimeToLive();
    }

    public String getName() {
        return this.name;
    }

    public String getKsName() {
        return this.ksName;
    }

    public String getFqName() {
        return this.fqName;
    }

    public void setCfId(UUID cfId) {
        this.cfId = cfId;
    }

    public UUID getCfId() {
        return this.cfId;
    }

    public int getDefaultTimeToLive() {
        return this.defaultTimeToLive;
    }

    public void setDefaultTimeToLive(int defaultTimeToLive) {
        this.defaultTimeToLive = defaultTimeToLive;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.cfId == null ? 0 : this.cfId.hashCode());
        result = 31 * result + this.defaultTimeToLive;
        result = 31 * result + (this.fqName == null ? 0 : this.fqName.hashCode());
        result = 31 * result + (this.ksName == null ? 0 : this.ksName.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ColumnFamilyMetaData other = (ColumnFamilyMetaData)obj;
        if (this.cfId == null ? other.cfId != null : !this.cfId.equals(other.cfId)) {
            return false;
        }
        if (this.defaultTimeToLive != other.defaultTimeToLive) {
            return false;
        }
        if (this.fqName == null ? other.fqName != null : !this.fqName.equals(other.fqName)) {
            return false;
        }
        if (this.ksName == null ? other.ksName != null : !this.ksName.equals(other.ksName)) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public String toString() {
        return "ColumnFamilyMetaData [ksName=" + this.ksName + ", name=" + this.name + ", fqName=" + this.fqName + ", cfId=" + this.cfId + ", defaultTimeToLive=" + this.defaultTimeToLive + "]";
    }
}

