/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.dao.cassandra;

import com.avaya.asm.core.AESEncrypter;
import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.dao.cassandra.BucketRangeIterator;
import com.avaya.asm.datamgr.dao.cassandra.NullUserStoreKeyspaceBuilder;
import com.avaya.asm.datamgr.dao.cassandra.PreparedStatementBuilder;
import com.avaya.asm.datamgr.dao.cassandra.PushNotificationPreparedStatementType;
import com.avaya.asm.datamgr.dao.cassandra.PushNotificationPreparedStatements;
import com.avaya.asm.datamgr.dao.cassandra.SessionBasedDAO;
import com.avaya.asm.datamgr.dao.cassandra.SessionDAO;
import com.avaya.asm.datamgr.dao.cassandra.UserStoreKeyspace;
import com.avaya.asm.datamgr.dao.cassandra.UserStoreKeyspaceBuilder;
import com.avaya.asm.datamgr.dao.cassandra.UserStoreStatementBuilder;
import com.avaya.asm.datamgr.objectapi.DelayedEC500NetworkType;
import com.avaya.asm.datamgr.objectapi.PushNotificationClientInstance;
import com.avaya.asm.datamgr.objectapi.PushNotificationServiceControls;
import com.avaya.asm.datamgr.objectapi.PushNotificationServiceDelayedEC500Info;
import com.avaya.asm.datamgr.objectapi.PushNotificationServiceType;
import com.avaya.common.logging.client.Logger;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Statement;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class PushNotificationDAO
extends SessionBasedDAO {
    private static final Logger log = AsmLogger.getLogger(PushNotificationDAO.class);
    private static final int maxDeleteLimit = 5000;
    private static final int FETCHSIZE = 500;
    private static final int bucketSize = 100;
    private final PushNotificationPreparedStatements preparedStatements;
    private final UserStoreKeyspaceBuilder ksBuilder = new NullUserStoreKeyspaceBuilder(new UserStoreKeyspace("global_user_dc"));

    public PushNotificationDAO(SessionDAO sessionDAO) {
        super(sessionDAO);
        this.preparedStatements = new PushNotificationPreparedStatements(sessionDAO);
    }

    public BucketRangeIterator newBucketRangeIterator(List<InetAddress> downNodes) throws UnknownHostException, DMException {
        BucketRangeIterator bucketRangeIterator = new BucketRangeIterator(this.sessionDAO, "global_user_dc", 100, downNodes);
        return bucketRangeIterator;
    }

    public PushNotificationClientInstance getPushNotification(long commProfileSetId, String sipInstanceId) throws DMException {
        ResultSet rs;
        String fcn_name = "getPushNotification";
        boolean isFiner = log.isFinerEnabled();
        boolean isFinest = log.isFinestEnabled();
        long startTime = 0L;
        PushNotificationClientInstance pushNotification = null;
        if (isFiner) {
            log.finer((Object)("getPushNotification: enter with commProfileSetId=" + commProfileSetId + ", sipInstanceId=" + sipInstanceId));
        }
        int bucketId = PushNotificationDAO.findBucketByCommProfileSetId(commProfileSetId);
        PNPreparedStatementBuilder psBuilder = new PNPreparedStatementBuilder(PushNotificationPreparedStatementType.GET_NOTIFICATION, this.ksBuilder, bucketId, commProfileSetId, sipInstanceId);
        if (isFinest) {
            startTime = System.currentTimeMillis();
        }
        if (!(rs = this.sessionDAO.executeStatement((UserStoreStatementBuilder)psBuilder, this.ksBuilder)).isExhausted()) {
            Row row = rs.one();
            pushNotification = this.pushNotificationMapper(row);
        }
        if (isFinest) {
            long endTime = System.currentTimeMillis();
            log.finest((Object)("getPushNotification: getPushNotification took " + (endTime - startTime)));
        }
        if (isFiner) {
            log.finer((Object)("getPushNotification: Leave: with pushNotification=" + pushNotification));
        }
        return pushNotification;
    }

    public static int findBucketByCommProfileSetId(long commProfileSetId) {
        return (int)(commProfileSetId % 100L);
    }

    private PushNotificationClientInstance pushNotificationMapper(Row row) {
        return new PushNotificationClientInstance(row.getLong("commProfileSetId"), PushNotificationServiceType.valueOf(row.getString("pushNotificationServiceType")), row.getString("applicationType"), row.getString("applicationPushToken"), row.getString("applicationVoIPPushToken"), row.getString("sipInstanceId"), new PushNotificationServiceDelayedEC500Info(DelayedEC500NetworkType.fromString(row.getString("delayedEC500Information_alternateNetworkType")), row.getString("delayedEC500Information_alterneteNetworkAddres")), new PushNotificationServiceControls(row.getBool("controls_enableIncomingCallNotification"), row.getBool("controls_enableMessageWaitingIndication"), row.getBool("controls_useVoIPPushNotificationChannelForIncomingCalls"), row.getBool("controls_useDevelopmentPushNotificationNetwork")), AESEncrypter.EncryptionScheme.create(row.getString("encryptionScheme")), row.getString("encryptionKey"), row.getTimestamp("activationTime").getTime());
    }

    public List<PushNotificationClientInstance> getAllPushNotification(long commProfileSetId) throws DMException {
        String fcn_name = "getAllPushNotification";
        boolean isFiner = log.isFinerEnabled();
        boolean isFinest = log.isFinestEnabled();
        long startTime = 0L;
        ArrayList<PushNotificationClientInstance> pushNotificationList = new ArrayList<PushNotificationClientInstance>();
        if (isFiner) {
            log.finer((Object)("getAllPushNotification: enter with commProfileSetId=" + commProfileSetId));
        }
        int bucketId = PushNotificationDAO.findBucketByCommProfileSetId(commProfileSetId);
        PNPreparedStatementBuilder psBuilder = new PNPreparedStatementBuilder(PushNotificationPreparedStatementType.GET_ALL_NOTIFICATION, this.ksBuilder, bucketId, commProfileSetId, 500);
        if (isFinest) {
            startTime = System.currentTimeMillis();
        }
        ResultSet rs = this.sessionDAO.executeStatement((UserStoreStatementBuilder)psBuilder, this.ksBuilder);
        while (!rs.isExhausted()) {
            for (Row row : rs) {
                pushNotificationList.add(this.pushNotificationMapper(row));
            }
            PushNotificationClientInstance lastPushNotificationClientInstance = (PushNotificationClientInstance)pushNotificationList.get(pushNotificationList.size() - 1);
            long lastcommProfileSetId = lastPushNotificationClientInstance.getCommProfileSetId();
            String sipInstanceId = lastPushNotificationClientInstance.getSipInstanceId();
            int lastbucketId = PushNotificationDAO.findBucketByCommProfileSetId(lastcommProfileSetId);
            psBuilder = new PNPreparedStatementBuilder(PushNotificationPreparedStatementType.GET_ALL_PN_BY_SIPINSTANCE_RANGE, this.ksBuilder, lastbucketId, lastcommProfileSetId, sipInstanceId, 500);
            rs = this.sessionDAO.executeStatement((UserStoreStatementBuilder)psBuilder, this.ksBuilder);
        }
        if (isFinest) {
            long endTime = System.currentTimeMillis();
            log.finest((Object)("getAllPushNotification: PushNotificationDAO.getAllPushNotification took " + (endTime - startTime)));
        }
        if (isFiner) {
            log.finer((Object)("getAllPushNotification: Leave: with pushNotificationList=" + pushNotificationList));
        }
        return pushNotificationList;
    }

    public void setPushNotification(PushNotificationClientInstance pushNotificationInstance) throws DMException {
        String fcn_name = "setPushNotification";
        boolean isFiner = log.isFinerEnabled();
        boolean isFinest = log.isFinestEnabled();
        long startTime = 0L;
        if (isFiner) {
            log.finer((Object)("setPushNotification: enter with pushNotificationInstance=" + pushNotificationInstance));
        }
        if (isFinest) {
            startTime = System.currentTimeMillis();
        }
        PNPreparedStatementBuilder psBuilder = null;
        PushNotificationServiceControls controls = pushNotificationInstance.getControls();
        PushNotificationServiceDelayedEC500Info delayedEC500Information = pushNotificationInstance.getDelayedEC500Information();
        String alternateNetworkType = null;
        String alternateNetworkAddress = null;
        if (delayedEC500Information != null) {
            alternateNetworkType = delayedEC500Information.getAlternateNetworkType().getValue();
            alternateNetworkAddress = delayedEC500Information.getAlternateNetworkAddress();
        }
        psBuilder = new PNPreparedStatementBuilder(PushNotificationPreparedStatementType.SET_NOTIFICATION, this.ksBuilder, new Timestamp(pushNotificationInstance.getActivationTime()), pushNotificationInstance.getApplicationPushToken(), pushNotificationInstance.getApplicationType(), pushNotificationInstance.getApplicationVoIPPushToken(), controls.getEnableIncomingCallNotification(), controls.getEnableMessageWaitingIndication(), controls.isUseDevelopmentPushNotificationNetwork(), controls.isUseVoIPPushNotificationChannelForIncomingCalls(), alternateNetworkType, alternateNetworkAddress, pushNotificationInstance.getEncryptionKey(), pushNotificationInstance.getEncryptionScheme().getNameWithKeyLength(), pushNotificationInstance.getPushNotificationServiceType().name(), PushNotificationDAO.findBucketByCommProfileSetId(pushNotificationInstance.getCommProfileSetId()), pushNotificationInstance.getCommProfileSetId(), pushNotificationInstance.getSipInstanceId());
        this.sessionDAO.executeStatement((UserStoreStatementBuilder)psBuilder, this.ksBuilder);
        if (isFinest) {
            long endTime = System.currentTimeMillis();
            log.finest((Object)("setPushNotification: PushNotificationDAO.setPushNotification took " + (endTime - startTime)));
        }
        if (isFiner) {
            log.finer((Object)"setPushNotification: Leave: after saving pushNotificationinstance");
        }
    }

    public void deletePushNotification(long commProfileSetId, String sipInstanceId) throws DMException {
        String fcn_name = "deletePushNotification";
        boolean isFiner = log.isFinerEnabled();
        boolean isFinest = log.isFinestEnabled();
        long startTime = 0L;
        if (isFiner) {
            log.finer((Object)("deletePushNotification: enter with commProfileSetId=" + commProfileSetId + ",sipInstanceId=" + sipInstanceId));
        }
        int bucketId = PushNotificationDAO.findBucketByCommProfileSetId(commProfileSetId);
        PNPreparedStatementBuilder psBuilder = new PNPreparedStatementBuilder(PushNotificationPreparedStatementType.DELETE_NOTIFICATION, this.ksBuilder, bucketId, commProfileSetId, sipInstanceId);
        if (isFinest) {
            startTime = System.currentTimeMillis();
        }
        this.sessionDAO.executeStatement((UserStoreStatementBuilder)psBuilder, this.ksBuilder);
        if (isFinest) {
            long endTime = System.currentTimeMillis();
            log.finest((Object)("deletePushNotification: PushNotificationDAO.deletePushNotification took " + (endTime - startTime)));
        }
        if (isFiner) {
            log.finer((Object)"deletePushNotification: Leave: after deleting pushNotificationinstance");
        }
    }

    public void deleteAllPushNotification(long commProfileSetId) throws DMException {
        String fcn_name = "deleteAllPushNotification";
        boolean isFiner = log.isFinerEnabled();
        boolean isFinest = log.isFinestEnabled();
        long startTime = 0L;
        if (isFiner) {
            log.finer((Object)("deleteAllPushNotification: enter with commProfileSetId=" + commProfileSetId));
        }
        if (isFinest) {
            startTime = System.currentTimeMillis();
        }
        int bucketId = PushNotificationDAO.findBucketByCommProfileSetId(commProfileSetId);
        PNPreparedStatementBuilder psBuilder = new PNPreparedStatementBuilder(PushNotificationPreparedStatementType.DELETE_ALL_NOTIFICATION, this.ksBuilder, bucketId, commProfileSetId);
        if (isFinest) {
            startTime = System.currentTimeMillis();
        }
        this.sessionDAO.executeStatement((UserStoreStatementBuilder)psBuilder, this.ksBuilder);
        if (isFinest) {
            long endTime = System.currentTimeMillis();
            log.finest((Object)("deleteAllPushNotification: deleteAllPushNotification took " + (endTime - startTime)));
        }
        if (isFiner) {
            log.finer((Object)"deleteAllPushNotification: Leave: after deleting pushNotificationinstance");
        }
    }

    public List<PushNotificationClientInstance> getAllLocalPushNotification(List<Long> localCommprofileSetIds) throws DMException {
        String fcn_name = "getAllLocalPushNotification";
        boolean isFiner = log.isFinerEnabled();
        boolean isFinest = log.isFinestEnabled();
        long startTime = 0L;
        ArrayList<PushNotificationClientInstance> pushNotificationList = new ArrayList<PushNotificationClientInstance>();
        if (isFiner) {
            log.finer((Object)"getAllLocalPushNotification: enter ");
        }
        if (isFinest) {
            startTime = System.currentTimeMillis();
        }
        localCommprofileSetIds.stream().map(commProfileSetId -> {
            List<Object> pushnotifications = new ArrayList();
            try {
                pushnotifications = this.getAllPushNotification((long)commProfileSetId);
            }
            catch (Exception e) {
                log.error((Object)("getAllLocalPushNotification: caught exception " + e), (Throwable)e);
            }
            return pushnotifications;
        }).forEach(pushnotification -> pushNotificationList.addAll((Collection<PushNotificationClientInstance>)pushnotification));
        if (isFinest) {
            long endTime = System.currentTimeMillis();
            log.finest((Object)("getAllLocalPushNotification: getAllLocalPushNotification took " + (endTime - startTime)));
        }
        if (isFiner) {
            log.finer((Object)("getAllLocalPushNotification: Leave: with pushNotificationList=" + pushNotificationList));
        }
        return pushNotificationList;
    }

    public List<PushNotificationClientInstance> getAllPushNotificationByBucket(Object bucketId, List<Long> commProfileSetlist) throws DMException {
        String fcn_name = "getAllPushNotification_bucket";
        boolean isFiner = log.isFinerEnabled();
        boolean isFinest = log.isFinestEnabled();
        long startTime = 0L;
        int bucket_Id = (Integer)bucketId;
        ArrayList<PushNotificationClientInstance> pushNotificationList = new ArrayList<PushNotificationClientInstance>();
        Collections.sort(commProfileSetlist);
        PNPreparedStatementBuilder psBuilder = new PNPreparedStatementBuilder(PushNotificationPreparedStatementType.GET_ALL_NOTIFICATION_BY_BUCKET, this.ksBuilder, bucket_Id, commProfileSetlist, 500);
        if (isFinest) {
            startTime = System.currentTimeMillis();
        }
        ResultSet rs = this.sessionDAO.executeStatement((UserStoreStatementBuilder)psBuilder, this.ksBuilder);
        while (!rs.isExhausted()) {
            Iterator iterator = rs.iterator();
            int cnt = 0;
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                pushNotificationList.add(this.pushNotificationMapper(row));
                ++cnt;
            }
            if (cnt != 500) continue;
            PushNotificationClientInstance lastPushNotificationClientInstance = (PushNotificationClientInstance)pushNotificationList.get(pushNotificationList.size() - 1);
            String sipInstanceId = lastPushNotificationClientInstance.getSipInstanceId();
            long lastcommProfileSetId = lastPushNotificationClientInstance.getCommProfileSetId();
            int fromIndex = Collections.binarySearch(commProfileSetlist, lastcommProfileSetId);
            List<Long> subList = commProfileSetlist.subList(fromIndex, commProfileSetlist.size());
            psBuilder = new PNPreparedStatementBuilder(PushNotificationPreparedStatementType.GET_NEXT_CHUNK_OF_ALL_NOTFICATION_BY_BUCKET, this.ksBuilder, bucket_Id, subList, sipInstanceId, 500);
            rs = this.sessionDAO.executeStatement((UserStoreStatementBuilder)psBuilder, this.ksBuilder);
        }
        if (isFinest) {
            long endTime = System.currentTimeMillis();
            log.finest((Object)("getAllPushNotification_bucket: took " + (endTime - startTime)));
        }
        if (isFiner) {
            log.finer((Object)("getAllPushNotification_bucket: Leave: with pushNotificationList=" + pushNotificationList));
        }
        return pushNotificationList;
    }

    public void getCommProfileSetIdByLocalBucket(int bucketId, Collection<Long> commProfileSetIds) throws DMException {
        String fcn_name = "getPushNotificationByLocalBucket";
        boolean isFiner = log.isFinerEnabled();
        boolean isFinest = log.isFinestEnabled();
        long startTime = 0L;
        long last_commProfileSetId = 0L;
        long secondLast_commProfileSetId = 0L;
        if (isFiner) {
            log.finer((Object)("getPushNotificationByLocalBucket: enter with bucketRangeForSM=" + bucketId));
        }
        if (isFinest) {
            startTime = System.currentTimeMillis();
        }
        PNPreparedStatementBuilder psBuilder = new PNPreparedStatementBuilder(PushNotificationPreparedStatementType.COMMPROFILESETID_BY_BUCKET, this.ksBuilder, bucketId, 500);
        ResultSet rs = this.sessionDAO.executeStatement((UserStoreStatementBuilder)psBuilder, this.ksBuilder);
        while (!rs.isExhausted()) {
            for (Row row : rs) {
                last_commProfileSetId = row.getLong("commprofilesetid");
                if (last_commProfileSetId != secondLast_commProfileSetId) {
                    commProfileSetIds.add(last_commProfileSetId);
                }
                secondLast_commProfileSetId = last_commProfileSetId;
            }
            psBuilder = new PNPreparedStatementBuilder(PushNotificationPreparedStatementType.BULK_COMMPROFILESETID_BY_BUCKET, this.ksBuilder, bucketId, last_commProfileSetId, 500);
            rs = this.sessionDAO.executeStatement((UserStoreStatementBuilder)psBuilder, this.ksBuilder);
        }
        if (isFinest) {
            long endTime = System.currentTimeMillis();
            log.finest((Object)("getPushNotificationByLocalBucket: getPushNotificationByLocalBucket took " + (endTime - startTime)));
        }
        if (isFiner) {
            log.finer((Object)("getPushNotificationByLocalBucket: Leave: with commProfileList=" + commProfileSetIds));
        }
        log.info((Object)("getPushNotificationByLocalBucket: Leave: with commProfileList=" + commProfileSetIds));
    }

    public class PNPreparedStatementBuilder
    extends PreparedStatementBuilder<PushNotificationPreparedStatementType> {
        public PNPreparedStatementBuilder(PushNotificationPreparedStatementType type, UserStoreKeyspaceBuilder builder, Object ... args) {
            super(PushNotificationDAO.this.preparedStatements, type, builder, args);
        }

        @Override
        public Statement getStatement() throws DMException {
            Statement statement = super.getStatement();
            return statement;
        }
    }
}

