/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.dao.ppm;

import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.datamgr.DMFactory;
import com.avaya.asm.datamgr.DMUtilities;
import com.avaya.asm.datamgr.DataMgr;
import com.avaya.asm.datamgr.dao.AsmInstanceDAO;
import com.avaya.asm.datamgr.dao.DataAccessObject;
import com.avaya.asm.datamgr.dao.LocalUserDAO;
import com.avaya.asm.datamgr.dao.jdbc.ResultSetMapper;
import com.avaya.asm.datamgr.dao.replication.DAOReplicationEvent;
import com.avaya.asm.datamgr.dao.replication.DAOTableEvent;
import com.avaya.asm.datamgr.objectapi.ContactRecord;
import com.avaya.asm.datamgr.objectapi.ContactRecords;
import com.avaya.asm.datamgr.objectapi.LocalUser;
import com.avaya.asm.datamgr.objectapi.ppm.ContactListMember;
import com.avaya.common.logging.client.Logger;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ContactListMemberDAO
extends DataAccessObject {
    private static final Logger log = AsmLogger.getLogger(ContactListMemberDAO.class);
    protected final int fetchSize = 10000;
    protected static final String joinStmt = " JOIN cscontactlist cl ON cl.id = clm.cscontactlistid JOIN csuser u ON u.id = cl.csuserid JOIN cscommprofileset set ON set.csuserid = u.id JOIN cscommprofile cs ON cs.cscommprofilesetid = set.id JOIN asmcommprofile asm ON asm.id = cs.id " + (DMUtilities.isBranch() ? "WHERE u.isdeleted = false AND asm.survivability_server_id IN (SELECT sipentity_id FROM asminstance WHERE id=?)" : "JOIN asmusercommunityassign uca ON uca.asmusercommunity_id = asm.usercommunity_id WHERE u.isdeleted = false AND uca.asminstance_id = ?");
    protected static final String selectContactListMembers = "SELECT clm.id, clm.cspersonid, clm.cscontactlistid, clm.ispresencebuddy, clm.isspeeddial, clm.entryindex, clm.cscontactaddressid, clm.cshandleid, clm.label, clm.csprivatecontactinfoid, clm.csuserid, clm.updatedatetime, u.id AS userid FROM cscontactlistmember clm";
    protected String getContactListMembers = "SELECT clm.id, clm.cspersonid, clm.cscontactlistid, clm.ispresencebuddy, clm.isspeeddial, clm.entryindex, clm.cscontactaddressid, clm.cshandleid, clm.label, clm.csprivatecontactinfoid, clm.csuserid, clm.updatedatetime, u.id AS userid FROM cscontactlistmember clm" + joinStmt;
    protected String getContactListMember = this.getContactListMembers + " AND clm.id = ?";
    protected String getAllContactListMembers = "SELECT clm.id, clm.cspersonid, clm.cscontactlistid, clm.ispresencebuddy, clm.isspeeddial, clm.entryindex, clm.cscontactaddressid, clm.cshandleid, clm.label, clm.csprivatecontactinfoid, clm.csuserid, clm.updatedatetime  FROM cscontactlistmember clm  WHERE cscontactlistid = :csContactListId";
    protected static final ResultSetMapper contactListMemberMapper = new ResultSetMapper(){

        @Override
        public Object mapResults(ResultSet rs) throws SQLException {
            ContactListMember clm = null;
            Logger log = AsmLogger.getLogger(ContactListMemberDAO.class);
            while (rs.next()) {
                if (clm != null) {
                    log.warn((Object)("ContactListMemberDAO - More than one record found." + rs));
                    break;
                }
                clm = ContactListMemberDAO.createContactListMember(rs);
            }
            return clm;
        }
    };
    protected static final ResultSetMapper contactListMembersMapper = new ResultSetMapper(){

        @Override
        public Object mapResults(ResultSet rs) throws SQLException {
            ContactListMember clm = null;
            ArrayList<ContactListMember> clmList = new ArrayList<ContactListMember>();
            while (rs.next()) {
                clm = ContactListMemberDAO.createContactListMember(rs);
                clmList.add(clm);
            }
            return clmList;
        }
    };

    public ContactListMemberDAO() {
        super(true);
    }

    protected Object[] getSingleContactListMemberParams(Long id) {
        Long myAsmInstanceId = this.getAsmInstanceDAO().getMyInstanceId();
        return new Object[]{myAsmInstanceId == null ? 0L : myAsmInstanceId, id};
    }

    protected AsmInstanceDAO getAsmInstanceDAO() {
        return (AsmInstanceDAO)DMFactory.getInstance().getDataMgr(AsmInstanceDAO.class);
    }

    protected LocalUserDAO getLocalUserDAO() {
        return (LocalUserDAO)this.getDataMgr(LocalUserDAO.class);
    }

    @Override
    public synchronized void init() {
        if (log.isFineEnabled()) {
            log.fine((Object)("Initializing " + ContactListMemberDAO.class.getSimpleName()));
        }
        this.getLocalUserDAO();
        this.setStatus(DataMgr.Status.OKAY);
    }

    @Override
    public List<String> getDependentTables() {
        ArrayList<String> retVal = new ArrayList<String>();
        retVal.add("cscontactlistmember");
        return retVal;
    }

    private static ContactListMember createContactListMember(ResultSet rs) throws SQLException {
        Long id = rs.getLong("id");
        Long contactaddressid = (Long)rs.getObject("cscontactaddressid");
        Long handleid = (Long)rs.getObject("cshandleid");
        Long privatecontactinfoid = (Long)rs.getObject("csprivatecontactinfoid");
        boolean isCsUserId = rs.getObject("csuserid") != null;
        return new ContactListMember(id, rs.getLong("cspersonid"), rs.getLong("cscontactlistid"), rs.getBoolean("ispresencebuddy"), rs.getBoolean("isspeeddial"), rs.getInt("entryindex"), contactaddressid, handleid, rs.getString("label"), privatecontactinfoid, isCsUserId, rs.getTimestamp("updatedatetime"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateDAO(DAOTableEvent event) {
        DAOReplicationEvent.OperationType operation = event.getOperation();
        String tableName = event.getTableName();
        Long id = event.getKey();
        boolean locked = false;
        ArrayList<Object> oldObjects = new ArrayList<Object>();
        ArrayList<Object> newObjects = new ArrayList<Object>();
        try {
            if ("cscontactlistmember".equalsIgnoreCase(tableName)) {
                ContactListMember newMember = null;
                if (operation == DAOReplicationEvent.OperationType.INSERT || operation == DAOReplicationEvent.OperationType.UPDATE) {
                    newMember = (ContactListMember)this.dataSource.executeQuery(this.getContactListMember, this.getSingleContactListMemberParams(id), contactListMemberMapper);
                }
                this.lock.acquireWriteLock();
                locked = true;
                ContactListMember oldMember = null;
                if (operation == DAOReplicationEvent.OperationType.DELETE) {
                    oldMember = this.getContactListMemberFromEvent(event);
                }
                if (oldMember == null ? newMember != null : !oldMember.equals(newMember)) {
                    oldObjects.add(oldMember);
                    newObjects.add(newMember);
                }
            }
        }
        catch (Exception e) {
            if (locked) {
                this.lock.releaseWriteLock();
                locked = false;
            }
            log.error((Object)(this.logTag(operation, tableName, id) + "Error updating " + ContactListMemberDAO.class.getSimpleName() + " object; re-initializing"), (Throwable)e);
            this.reinit();
            if (!this.okay()) {
                log.error((Object)(this.logTag(operation, tableName, id) + "Update NOT successful!"));
                return;
            }
        }
        finally {
            if (locked) {
                this.lock.releaseWriteLock();
            }
        }
        if (log.isFineEnabled()) {
            log.fine((Object)this.logTag(operation, tableName, id));
        }
        if (!newObjects.isEmpty() || !oldObjects.isEmpty()) {
            this.updateListeners(oldObjects, newObjects);
        }
        if (log.isFineEnabled()) {
            log.fine((Object)(this.logTag(operation, tableName, id) + "Update successful"));
        }
    }

    private Long getLongValue(String columnName, DAOTableEvent event) {
        Long returnValue = null;
        String columnValue = event.getTblEventtDataEntry(columnName);
        if (columnValue != null) {
            try {
                returnValue = Long.parseLong(columnValue);
            }
            catch (NumberFormatException nfe) {
                log.warn((Object)("ContactListMemberDAO.getLongValue : NumberFormatException thrown for columnName = " + columnName + " and columnValue = " + columnValue));
            }
        }
        return returnValue;
    }

    private Integer getIntValue(String columnName, DAOTableEvent event) {
        Integer returnValue = null;
        String columnValue = event.getTblEventtDataEntry(columnName);
        if (columnValue != null) {
            try {
                returnValue = Integer.parseInt(columnValue);
            }
            catch (NumberFormatException nfe) {
                log.warn((Object)("ContactListMemberDAO.getIntValue : NumberFormatException thrown for columnName = " + columnName + " and columnValue = " + columnValue));
            }
        }
        return returnValue;
    }

    @Override
    public void objectChanged(Object oldObject, Object newObject) {
        if (oldObject instanceof LocalUser || newObject instanceof LocalUser) {
            if (newObject == null) {
                long userId = ((LocalUser)oldObject).getId();
                this.updateDAO(new DAOTableEvent("csuser", DAOReplicationEvent.OperationType.DELETE, userId));
            } else if (oldObject == null) {
                long userId = ((LocalUser)newObject).getId();
                this.updateDAO(new DAOTableEvent("csuser", DAOReplicationEvent.OperationType.INSERT, userId));
            }
        } else {
            super.objectChanged(oldObject, newObject);
        }
    }

    public List<Long> getContactIdsForContactList(ContactRecords dbRecords) {
        ArrayList<Long> personidList = new ArrayList<Long>();
        String fcn_name = "getContactIdsForContactList";
        boolean isFinest = log.isFinestEnabled();
        if (isFinest) {
            log.finest((Object)("getContactIdsForContactList: dbRecords = " + dbRecords));
        }
        if (dbRecords.getContactRecordList() != null && !dbRecords.getContactRecordList().isEmpty()) {
            List<ContactRecord> contactRecordList = dbRecords.getContactRecordList();
            for (ContactRecord record : contactRecordList) {
                personidList.add(record.getPerson_id());
            }
            return personidList;
        }
        return personidList;
    }

    public Collection<ContactListMember> getContactListMembers(ContactRecords dbRecords) {
        List<ContactListMember> contactmemberList = new ArrayList<ContactListMember>();
        String fcn_name = "getContactListMembers";
        boolean isFinest = log.isFinestEnabled();
        if (isFinest) {
            log.finest((Object)("getContactListMembers: dbRecords = " + dbRecords));
        }
        if (dbRecords != null && dbRecords.getContactRecordList() != null && dbRecords.getContactRecordList().size() > 0) {
            contactmemberList = this.getContactListMembersFromContactRecords(dbRecords);
        }
        return contactmemberList;
    }

    private List<ContactListMember> getContactListMembersFromContactRecords(ContactRecords dbRecords) {
        ArrayList<ContactListMember> contactListMembers = new ArrayList<ContactListMember>();
        List<ContactRecord> contactRecordList = dbRecords.getContactRecordList();
        for (ContactRecord record : contactRecordList) {
            boolean isCsUser = false;
            if (record.getContact_type().equals(ContactRecord.INTERNAL_CONTACT_TYPE)) {
                isCsUser = true;
            }
            ContactListMember clm = new ContactListMember(record.getMember_id(), record.getPerson_id(), record.getCscontactlistid(), record.isIspresencebuddy(), record.isIsspeedial(), record.getEntryindex(), record.getCscontactaddressid(), record.getCshandleid(), record.getLabel(), record.getCsprivatecontactinfoid(), isCsUser, null);
            contactListMembers.add(clm);
        }
        return contactListMembers;
    }

    @Override
    protected Object getMainCollection() {
        return null;
    }

    public ContactListMember getContactListMemberFromEvent(DAOTableEvent event) {
        Boolean isCsUserId = false;
        ContactListMember member = null;
        if (event.getTblEventData().size() > 0) {
            if (event.getTblEventtDataEntry("csuserid") != null) {
                isCsUserId = true;
            }
            member = new ContactListMember(this.getLongValue("id", event), this.getLongValue("cspersonid", event), this.getLongValue("cscontactlistid", event), Boolean.parseBoolean(event.getTblEventtDataEntry("ispresencebuddy")), Boolean.parseBoolean(event.getTblEventtDataEntry("isspeeddial")), this.getIntValue("entryindex", event), this.getLongValue("cscontactaddressid", event), this.getLongValue("cshandleid", event), event.getTblEventtDataEntry("label"), this.getLongValue("csprivatecontactinfoid", event), isCsUserId, Timestamp.valueOf(event.getTblEventtDataEntry("updatedatetime")));
        }
        return member;
    }

    public List<ContactListMember> getAllContactListMembers(Long contactListId) {
        List clmList = null;
        String query = this.getAllContactListMembers.replaceAll(":csContactListId", Long.toString(contactListId));
        try {
            Object[] params = new Object[]{};
            clmList = (List)this.dataSource.executeQuery(query, params, contactListMembersMapper);
        }
        catch (Exception e) {
            log.error((Object)("Error reading contactlistmembers: " + this.getClass().getSimpleName() + " object"), (Throwable)e);
        }
        return clmList;
    }

    @Override
    public int numChangesBeforeReinit() {
        return Integer.MAX_VALUE;
    }
}

