/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.dao.ppm;

import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.dao.cassandra.UserStoreKeyspace;
import com.avaya.asm.datamgr.dao.jdbc.JDBCBasedDAO;
import com.avaya.asm.datamgr.dao.jdbc.ResultSetMapper;
import com.avaya.common.logging.client.Logger;
import com.avaya.ustore.objectapi.DeviceDataKey;
import com.avaya.ustore.objectapi.DeviceDataRecord;
import java.sql.Array;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DeviceDataPostgresDAO {
    private static final Logger log = AsmLogger.getLogger(DeviceDataPostgresDAO.class);
    private static UserStoreKeyspace globalKS = new UserStoreKeyspace("global_user_dc");
    private static JDBCBasedDAO dataSource;
    protected static final String getDeviceDataQuery = "SELECT * FROM device WHERE acpid=:acpid AND datacategory=:datacategory AND devicehandle=:devicehandle";
    protected static final String getDeviceDataQueryWithDataName = "SELECT * FROM device WHERE acpid=:acpid AND datacategory=:datacategory AND devicehandle=:devicehandle AND dataname=:dataname";
    protected static final String insertDDQueryPart1 = "INSERT INTO device(acpid, datacategory, devicehandle, dataname, createddatetime, datavalue, families, ownercsuserid, updatedatetime) ";
    protected static final String insertDDQueryPart2 = " VALUES(:acpid,:datacategory,:devicehandle,:dataname,:createddatetime,:datavalue,:families,:ownercsuserid,:updatedatetime) ";
    protected static final String updateDDQuery = "UPDATE device SET datavalue=:datavalue, updatedatetime=:updatedatetime WHERE acpid=:acpid AND dataname=:dataname";
    private static final String SINGLE_QUOTE = "'";

    public static void setDataSource(JDBCBasedDAO source) {
        dataSource = source;
    }

    protected final ResultSetMapper getDeviceDataMapper() {
        return new ResultSetMapper(){

            @Override
            public Object mapResults(ResultSet rs) throws SQLException {
                ArrayList<DeviceDataRecord> deviceList = new ArrayList<DeviceDataRecord>();
                while (rs.next()) {
                    deviceList.add(DeviceDataPostgresDAO.this.buildDeviceDataFromResultSet(rs));
                }
                return deviceList;
            }
        };
    }

    public boolean setDeviceData(Collection<DeviceDataRecord> ddrCollection, boolean isAtomic) {
        String fcn_name = "setDeviceData";
        for (DeviceDataRecord ddr : ddrCollection) {
            DeviceDataKey ddk = ddr.getKey();
            String category = ddk.getDataCategory();
            if (category.equalsIgnoreCase("Config")) continue;
            long currentTimeMillis = System.currentTimeMillis();
            Timestamp cdtime = ddr.getCreatedDateTime() != null ? new Timestamp(ddr.getCreatedDateTime()) : new Timestamp(currentTimeMillis);
            Timestamp udtime = ddr.getCreatedDateTime() != null ? new Timestamp(ddr.getUpdateDateTime()) : new Timestamp(currentTimeMillis);
            String acpid = String.valueOf(ddk.getAsmCommProfileId());
            String datacategory = DeviceDataPostgresDAO.getStringWithQuote(ddk.getDataCategory());
            String devicehandle = DeviceDataPostgresDAO.getStringWithQuote(ddk.getDeviceHandle());
            String dataname = DeviceDataPostgresDAO.getStringWithQuote(ddk.getDataName());
            String createddatetime = DeviceDataPostgresDAO.getStringWithQuote(cdtime.toString());
            String datavalue = DeviceDataPostgresDAO.getStringWithQuote(ddr.getDataValue());
            String families = "Null";
            String ownercsuserid = String.valueOf(ddr.getOwnerCsUserId());
            String updatedatetime = DeviceDataPostgresDAO.getStringWithQuote(udtime.toString());
            Set<String> family = ddr.getFamily();
            if (family != null && !family.isEmpty()) {
                families = "'{" + String.join((CharSequence)",", family) + "}'";
            }
            HashMap<String, String> paramsToReplace = new HashMap<String, String>();
            paramsToReplace.put(":acpid", acpid);
            paramsToReplace.put(":datacategory", datacategory);
            paramsToReplace.put(":devicehandle", devicehandle);
            paramsToReplace.put(":dataname", dataname);
            paramsToReplace.put(":createddatetime", createddatetime);
            paramsToReplace.put(":datavalue", datavalue);
            paramsToReplace.put(":families", families);
            paramsToReplace.put(":ownercsuserid", ownercsuserid);
            paramsToReplace.put(":updatedatetime", updatedatetime);
            Set keys = paramsToReplace.keySet();
            Object[] params = new Object[]{};
            String query = null;
            try {
                List<DeviceDataRecord> gDDRespList = this.getDeviceData(ddk.getKeyspace(), ddk.getAsmCommProfileId(), ddk.getDataCategory(), ddk.getDeviceHandle(), ddk.getDataName(), null);
                if (gDDRespList != null && !gDDRespList.isEmpty()) {
                    query = updateDDQuery;
                    for (String key : keys) {
                        query = query.replace(key, (CharSequence)paramsToReplace.get(key));
                    }
                    dataSource.executeUpdate(query, params);
                    continue;
                }
                query = insertDDQueryPart2;
                for (String key : keys) {
                    query = query.replace(key, (CharSequence)paramsToReplace.get(key));
                }
                dataSource.executeUpdate(insertDDQueryPart1 + query, params);
            }
            catch (DMException ex) {
                log.error((Object)("setDeviceData Got DMException with SetDeviceData for ddr = " + ddr + ", query = " + query), (Throwable)ex);
                return false;
            }
        }
        return true;
    }

    public List<DeviceDataRecord> getDeviceData(UserStoreKeyspace keyspace, long acpId, String dataCategory, String deviceHandle, String dataName) throws DMException {
        return this.getDeviceData(keyspace, acpId, dataCategory, deviceHandle, null, null);
    }

    public List<DeviceDataRecord> getDeviceData(UserStoreKeyspace keyspace, long acpId, String dataCategory, String deviceHandle, String dataName, String family) throws DMException {
        String fcn_name = "getDeviceData";
        String query = getDeviceDataQuery;
        HashMap<String, String> paramsToReplace = new HashMap<String, String>();
        paramsToReplace.put(":acpid", DeviceDataPostgresDAO.getStringWithQuote(String.valueOf(acpId)));
        paramsToReplace.put(":datacategory", DeviceDataPostgresDAO.getStringWithQuote(dataCategory));
        paramsToReplace.put(":devicehandle", DeviceDataPostgresDAO.getStringWithQuote(deviceHandle));
        if (dataName != null && !dataName.isEmpty()) {
            paramsToReplace.put(":dataname", DeviceDataPostgresDAO.getStringWithQuote(dataName));
            query = getDeviceDataQueryWithDataName;
        }
        Object[] params = new Object[]{};
        Set keys = paramsToReplace.keySet();
        for (String key : keys) {
            query = query.replace(key, (CharSequence)paramsToReplace.get(key));
        }
        List ddrList = null;
        try {
            ddrList = (List)dataSource.executeQuery(query, params, this.getDeviceDataMapper());
        }
        catch (DMException ex) {
            log.error((Object)("getDeviceData, Got DMException for acpId = " + acpId + ", dataCategory = " + dataCategory + ", deviceHandle = " + deviceHandle), (Throwable)ex);
        }
        return ddrList;
    }

    private DeviceDataRecord buildDeviceDataFromResultSet(ResultSet rs) throws SQLException {
        String[] familyArr;
        DeviceDataKey ddk = new DeviceDataKey(rs.getLong("acpid"), rs.getString("datacategory"), rs.getString("devicehandle"), rs.getString("dataname"), globalKS);
        Array rsArr = rs.getArray("families");
        HashSet<String> family = null;
        if (rsArr != null && (familyArr = (String[])rsArr.getArray()) != null) {
            family = new HashSet<String>(Arrays.asList(familyArr));
        }
        DeviceDataRecord ddr = new DeviceDataRecord(ddk, rs.getLong("ownercsuserid"), rs.getTimestamp("createddatetime").getTime(), rs.getTimestamp("updatedatetime").getTime(), rs.getString("datavalue"), family);
        return ddr;
    }

    private static String getStringWithQuote(String str) {
        return SINGLE_QUOTE + str + SINGLE_QUOTE;
    }
}

