/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.dao.replication;

import com.avaya.asm.core.AsmCommon;
import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.AsmSettings;
import com.avaya.asm.datamgr.DMFactory;
import com.avaya.asm.datamgr.DataMgr;
import com.avaya.asm.datamgr.dao.DataAccessObject;
import com.avaya.asm.datamgr.dao.replication.DAOReplicationApplicationListener;
import com.avaya.asm.datamgr.dao.replication.DAOReplicationEvent;
import com.avaya.asm.datamgr.dao.replication.DAOReplicationEventList;
import com.avaya.asm.datamgr.dao.replication.DAOReplicationQueue;
import com.avaya.asm.datamgr.dao.replication.DAOReplicationQueueServicer;
import com.avaya.asm.datamgr.datadistributionlayer.DataDistLayerData;
import com.avaya.asm.datamgr.datadistributionlayer.DataDistLayerListener;
import com.avaya.asm.datamgr.datadistributionlayer.DataDistLayerMemberAddr;
import com.avaya.asm.datamgr.datadistributionlayer.DataDistLayerMessage;
import com.avaya.asm.datamgr.datadistributionlayer.GroupCommIntf;
import com.avaya.common.logging.client.Logger;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;

public class DAOReplicationListener
implements DataDistLayerListener {
    private final Logger log = AsmLogger.getLogger(DAOReplicationListener.class);
    private static volatile DAOReplicationListener myInstance = null;
    private boolean initialLoadInProgress = false;
    protected DMFactory dmFactory = null;
    protected DAOReplicationQueue eventQueue;
    protected DAOReplicationQueueServicer servicerThread;
    protected int curSequenceNum = -1;
    protected Timer eventTimer;
    protected long timeStamp = System.currentTimeMillis();
    protected boolean unprocessedEvents;
    protected List<DAOReplicationApplicationListener> appListeners;

    public static void setMyInstance() {
        if (AsmCommon.jUnitEnvironment) {
            myInstance = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DAOReplicationListener getInstance() {
        if (myInstance != null) return myInstance;
        Class<DAOReplicationListener> clazz = DAOReplicationListener.class;
        synchronized (DAOReplicationListener.class) {
            if (myInstance != null) return myInstance;
            myInstance = new DAOReplicationListener();
            // ** MonitorExit[var0] (shouldn't be in output)
            return myInstance;
        }
    }

    protected DAOReplicationListener() {
        this.log.info((Object)"Initializing DAOReplicationListener");
        this.eventQueue = new DAOReplicationQueue();
        this.servicerThread = new DAOReplicationQueueServicer(this.eventQueue);
        this.servicerThread.start();
        this.appListeners = new ArrayList<DAOReplicationApplicationListener>();
        if (!AsmCommon.jUnitEnvironment) {
            this.eventTimer = new Timer(true);
            this.eventTimer.scheduleAtFixedRate(new TimerTask(){

                @Override
                public void run() {
                    try {
                        DAOReplicationListener.this.timerRun();
                    }
                    catch (Exception e) {
                        DAOReplicationListener.this.log.error((Object)"Exception in task for flushing replication event queue", (Throwable)e);
                    }
                }
            }, 2000L, 30000L);
            this.log.info((Object)"Created a periodic timer that fires every 30 seconds to possibly flush our queue");
        }
    }

    public synchronized void timerRun() {
        if (this.unprocessedEvents && (double)System.currentTimeMillis() > (double)this.timeStamp + 55000.00000000001) {
            this.eventQueue.addEvent(new DAOReplicationEvent());
            this.unprocessedEvents = false;
        }
    }

    @Override
    public synchronized void destroy() {
        this.log.info((Object)"Destroying DAOReplicationListener");
        this.servicerThread.destroy();
        this.appListeners.clear();
        if (!AsmCommon.jUnitEnvironment) {
            this.eventTimer.cancel();
        }
        myInstance = null;
    }

    private DMFactory getFactory() {
        if (this.dmFactory == null) {
            return DMFactory.getInstance();
        }
        return this.dmFactory;
    }

    public void updateEventTables(Class<? extends DataAccessObject> daoClazz, List<String> dependentTables) {
        this.servicerThread.updateEventTables(daoClazz, dependentTables);
    }

    public static boolean initialLoadInProgress() {
        return DAOReplicationListener.getInstance().initialLoadInProgress;
    }

    public void registerListener(DAOReplicationApplicationListener listener) {
        if (!this.appListeners.contains(listener)) {
            this.appListeners.add(listener);
        }
    }

    @Override
    public void processMessage(DataDistLayerMessage message, DataDistLayerMemberAddr senderId) {
        int messageType = message.getMessageType();
        if (messageType == 0) {
            this.log.info((Object)"Starting DRS Initial Load");
            DAOReplicationEventList eventList = (DAOReplicationEventList)message.getPayload();
            this.updateSequenceNumber(eventList, false);
            this.initialLoadInProgress = true;
            for (DAOReplicationApplicationListener listener : this.appListeners) {
                listener.startingInitialLoad(eventList);
            }
        } else if (messageType == 1) {
            this.processEndOfInitialLoad((DAOReplicationEventList)message.getPayload());
        } else if (messageType == 2) {
            DAOReplicationEventList eventList = (DAOReplicationEventList)message.getPayload();
            if (this.log.isFinestEnabled()) {
                this.log.finest((Object)("Got a message: " + eventList));
            } else if (this.log.isFinerEnabled()) {
                this.log.finer((Object)("Got a message for " + eventList.size() + " events."));
            }
            for (DAOReplicationApplicationListener listener : this.appListeners) {
                listener.replicationEvent(eventList);
            }
            if (this.initialLoadInProgress) {
                this.processEndOfInitialLoad(eventList);
                return;
            }
            if (this.updateSequenceNumber(eventList, true)) {
                return;
            }
            for (DAOReplicationEvent event : eventList) {
                this.eventQueue.addEvent(event);
            }
            if (this.log.isFinestEnabled()) {
                this.log.finest((Object)("Event queue is now " + this.eventQueue));
            }
            if (AsmSettings.getBulkUpdateASAP() || eventList.size() < AsmSettings.getRetainEventsThreshold()) {
                this.eventQueue.addEvent(new DAOReplicationEvent());
                this.unprocessedEvents = false;
            } else {
                this.unprocessedEvents = true;
            }
            this.timeStamp = System.currentTimeMillis();
        } else {
            this.log.warn((Object)("Unknown message type: " + messageType));
        }
    }

    private void processEndOfInitialLoad(DAOReplicationEventList eventList) {
        this.log.info((Object)"Finished DRS Initial Load");
        DMFactory dmFactory = DMFactory.getInstance();
        dmFactory.getDataSource().resetConnections();
        dmFactory.getLocalDataSource().resetConnections();
        for (DAOReplicationApplicationListener listener : this.appListeners) {
            listener.beforeDAOReinit(eventList);
        }
        if (!this.updateSequenceNumber(eventList, true)) {
            this.reinitDAOs();
        }
        for (DAOReplicationApplicationListener listener : this.appListeners) {
            listener.finishedInitialLoad(eventList);
        }
        this.initialLoadInProgress = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean updateSequenceNumber(DAOReplicationEventList eventList, boolean reinit) {
        if (eventList == null) {
            this.log.warn((Object)"Recieved unexpected null DAOReplicationEventList in message payload.");
            return false;
        }
        try {
            if (this.curSequenceNum != -1 && reinit && eventList.sequenceNumber() != this.curSequenceNum + 1) {
                this.log.warn((Object)("Replication events did not come in order.  Sequence numbers did not match expected values.  Last seq=" + this.curSequenceNum + ", event seq=" + eventList.sequenceNumber()));
                this.reinitDAOs();
                eventList.clear();
                this.unprocessedEvents = false;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.curSequenceNum = eventList.sequenceNumber();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void reinitDAOs() {
        try {
            if (this.log.isFineEnabled()) {
                this.log.info((Object)("Reinitializing all " + DataAccessObject.class.getSimpleName() + "s"));
            }
            this.eventQueue.pauseExecution();
            this.eventQueue.flush();
            this.unprocessedEvents = false;
            DMFactory factory = this.getFactory();
            if (factory != null) {
                ClassLoader daoCL;
                ClassLoader origCl = Thread.currentThread().getContextClassLoader();
                Set<Class<? extends DataAccessObject>> allDAOClasses = factory.getAllDAOClasses();
                for (Class<? extends DataAccessObject> dao : allDAOClasses) {
                    try {
                        daoCL = dao.getClassLoader();
                        Thread.currentThread().setContextClassLoader(daoCL);
                        factory.getDataMgr(dao).setStatus(DataMgr.Status.UNINITIALIZED);
                    }
                    finally {
                        Thread.currentThread().setContextClassLoader(origCl);
                    }
                }
                for (Class<? extends DataAccessObject> dao : allDAOClasses) {
                    try {
                        daoCL = dao.getClassLoader();
                        Thread.currentThread().setContextClassLoader(daoCL);
                        factory.getDataMgr(dao);
                    }
                    catch (Exception e) {
                        factory.getDataMgr(dao).setStatus(DataMgr.Status.FAIL);
                        this.log.error((Object)("While reinitializing DAOs, attempts to reload " + dao.getSimpleName() + " caused this exception: "), (Throwable)e);
                    }
                    finally {
                        Thread.currentThread().setContextClassLoader(origCl);
                    }
                }
            }
        }
        finally {
            this.log.info((Object)("Done reinitializing all " + DataAccessObject.class.getSimpleName() + "s"));
            this.eventQueue.resumeExecution();
        }
    }

    @Override
    public DataDistLayerMessage.TargetAppId getListenerAppId() {
        return DataDistLayerMessage.TargetAppId.REPLICATION;
    }

    @Override
    public void hostLeftTheGroup(DataDistLayerMemberAddr hostId, GroupCommIntf.DDLGroupType groupType) {
    }

    @Override
    public Object handleMessage(DataDistLayerMessage message, DataDistLayerMemberAddr srcMember) {
        return null;
    }

    @Override
    public void otherMemberJoined(DataDistLayerMemberAddr otherMemberId, GroupCommIntf.DDLGroupType ddlGroupType) {
    }

    @Override
    public void thisMemberJoinedTheGroup(DataDistLayerMemberAddr thisMemberId, GroupCommIntf.DDLGroupType ddlGroupType) {
    }

    @Override
    public void dataStored(DataDistLayerMemberAddr senderId, DataDistLayerData data) {
    }

    @Override
    public void dataUpdated(DataDistLayerMemberAddr senderId, DataDistLayerData priorData, DataDistLayerData updatedData) {
    }

    @Override
    public void dataRemoved(DataDistLayerMemberAddr senderId, DataDistLayerData removedData) {
    }

    @Override
    public void bulkStoreReceived(DataDistLayerMemberAddr senderId, List<DataDistLayerData> dataList) {
    }

    @Override
    public void bulkRemoveReceived(DataDistLayerMemberAddr senderId, List<DataDistLayerData> dataList) {
    }
}

