/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.dao.replication;

import com.avaya.asm.datamgr.dao.replication.DAOReplicationEvent;
import java.util.concurrent.ConcurrentLinkedQueue;

public class DAOReplicationQueue {
    private final ConcurrentLinkedQueue<DAOReplicationEvent> eventQueue = new ConcurrentLinkedQueue();
    private boolean canProcessEvent = true;

    public synchronized DAOReplicationEvent getEvent() throws InterruptedException {
        while (this.eventQueue.isEmpty() || !this.canProcessEvent) {
            this.wait();
        }
        return this.eventQueue.poll();
    }

    public synchronized void addEvent(DAOReplicationEvent event) {
        this.eventQueue.add(event);
        this.notify();
    }

    public synchronized void pauseExecution() {
        this.canProcessEvent = false;
    }

    public synchronized void resumeExecution() {
        this.canProcessEvent = true;
        this.notify();
    }

    public void flush() {
        this.eventQueue.clear();
    }

    public boolean canProcessEvent() {
        return this.canProcessEvent;
    }

    public String toString() {
        return this.eventQueue.toString();
    }
}

