/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.dao.ustore;

import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.LoadBalancerAPI;
import com.avaya.asm.datamgr.dao.cassandra.ColumnFamilyMetaData;
import com.avaya.asm.datamgr.dao.cassandra.LoadBalancerPreparedStatementType;
import com.avaya.asm.datamgr.dao.cassandra.LoadBalancerPreparedStatements;
import com.avaya.asm.datamgr.dao.cassandra.NullUserStoreKeyspaceBuilder;
import com.avaya.asm.datamgr.dao.cassandra.PreparedStatementBuilder;
import com.avaya.asm.datamgr.dao.cassandra.SessionBasedDAO;
import com.avaya.asm.datamgr.dao.cassandra.SessionDAO;
import com.avaya.asm.datamgr.dao.cassandra.TokenRangeIterator;
import com.avaya.asm.datamgr.dao.cassandra.UserStoreKeyspace;
import com.avaya.asm.datamgr.dao.cassandra.UserStoreKeyspaceBuilder;
import com.avaya.asm.datamgr.dao.cassandra.UserStoreStatementBuilder;
import com.avaya.common.logging.client.Logger;
import com.avaya.ustore.objectapi.LoadBalancerData;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.Token;
import com.datastax.driver.core.TokenRange;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class LoadBalancerDAO1
extends SessionBasedDAO {
    private static final Logger log = AsmLogger.getLogger(LoadBalancerDAO1.class);
    private static final int maxDeleteLimit = 200000;
    private static final int fetchSize = 40000;
    private static final Integer readTimeoutMillis = 3000;
    private final LoadBalancerPreparedStatements preparedStatements;
    private SessionDAO.ExecuteOptions fetchSizeExecOptions = new SessionDAO.ExecuteOptions();
    private final UserStoreKeyspaceBuilder ksBuilder = new NullUserStoreKeyspaceBuilder(new UserStoreKeyspace("loadbalancer"));

    public LoadBalancerDAO1(SessionDAO sessionDAO) {
        super(sessionDAO);
        this.preparedStatements = new LoadBalancerPreparedStatements(sessionDAO);
    }

    private static List<List<String>> splitKeysByLimit(Collection<String> keys) {
        String fcn_name = "splitKeysByLimit";
        boolean isFiner = log.isFinerEnabled();
        int fromIndex = 0;
        int toIndex = 200000;
        ArrayList<List<String>> partition = new ArrayList<List<String>>();
        if (isFiner) {
            log.finer((Object)("splitKeysByLimit: enter with keys of size=" + keys.size()));
        }
        while (true) {
            if (toIndex >= keys.size()) break;
            partition.add(((List)keys).subList(fromIndex, toIndex));
            fromIndex = toIndex + 1;
            toIndex += 200000;
        }
        partition.add(((List)keys).subList(fromIndex, keys.size()));
        if (isFiner) {
            log.finer((Object)("splitKeysByLimit: Leave with partition of size=" + partition.size()));
        }
        return partition;
    }

    public String queryResolvedAddress(long loadBalancerId, String key) throws DMException {
        String fcn_name = "queryResolvedAddress";
        boolean isFiner = log.isFinerEnabled();
        boolean isFinest = log.isFinestEnabled();
        long startTime = 0L;
        String resolvedAddress = null;
        if (isFiner) {
            log.finer((Object)("queryResolvedAddress: enter with loadbalancerId=" + loadBalancerId + ", key=" + key));
        }
        LBPreparedStatementBuilder psBuilder = new LBPreparedStatementBuilder(LoadBalancerPreparedStatementType.QUERY_RESOLVED_ADDRESS, this.ksBuilder, loadBalancerId, key);
        if (isFinest) {
            startTime = System.currentTimeMillis();
        }
        ResultSet rs = this.sessionDAO.executeStatement((UserStoreStatementBuilder)psBuilder, this.ksBuilder);
        if (isFinest) {
            long endTime = System.currentTimeMillis();
            log.finest((Object)("queryResolvedAddress: loadBalancerDAO.queryResolvedAddress took " + (endTime - startTime)));
        }
        if (!rs.isExhausted()) {
            resolvedAddress = rs.one().getString("resolved_address");
        }
        if (isFiner) {
            log.finer((Object)("queryResolvedAddress: Leave: with resolvedAddress=" + resolvedAddress));
        }
        return resolvedAddress;
    }

    public List<String> getAllKeysByResolvedAddress(long loadBalancerId, String addr) throws DMException {
        String fcn_name = "getAllKeysByResolvedAddress";
        boolean isFiner = log.isFinerEnabled();
        boolean isFinest = log.isFinestEnabled();
        long startTime = 0L;
        if (isFiner) {
            log.finer((Object)("getAllKeysByResolvedAddress: enter with loadbalancerId=" + loadBalancerId + ",addr=" + addr));
        }
        LBPreparedStatementBuilder psBuilder = new LBPreparedStatementBuilder(LoadBalancerPreparedStatementType.GET_All_KEYS_BULK_READ, this.ksBuilder, addr);
        if (isFinest) {
            startTime = System.currentTimeMillis();
        }
        ResultSet rs = this.sessionDAO.executeStatement(psBuilder, this.fetchSizeExecOptions, this.ksBuilder);
        ArrayList<String> keys = new ArrayList<String>();
        Iterator rowIt = rs.iterator();
        int numUnequalLbIds = 0;
        while (rowIt.hasNext()) {
            Row row = (Row)rowIt.next();
            long lb_id = row.getLong("loadbalancer_id");
            if (loadBalancerId != lb_id) {
                ++numUnequalLbIds;
                continue;
            }
            if (row.isNull("key")) {
                log.warn((Object)("getAllKeysByResolvedAddress: null key for lb_id=" + lb_id + ", addr=" + addr));
                continue;
            }
            String key = row.getString("key");
            keys.add(key);
        }
        if (isFinest) {
            long endTime = System.currentTimeMillis();
            log.finest((Object)("getAllKeysByResolvedAddress: loadBalancerDAO.getAllKeysBulkRead took " + (endTime - startTime)));
        }
        if (isFiner) {
            log.finer((Object)("getAllKeysByResolvedAddress: leave, keys.size=" + keys.size() + ", numUnequalLbIds=" + numUnequalLbIds));
        }
        return keys;
    }

    public String setResolvedAddress(long loadBalancerId, String key, String addr, LoadBalancerAPI.ConsistencyScope cscope, boolean downgrade) throws DMException {
        String fcn_name = "setResolvedAddress";
        boolean isFiner = log.isFinerEnabled();
        boolean isFinest = log.isFinestEnabled();
        long startTime = 0L;
        String resolvedAddress = null;
        if (isFiner) {
            log.finer((Object)("setResolvedAddress: enter with loadbalancerId=" + loadBalancerId + ", key=" + key + " ,addr=" + addr + ", cScope=" + (Object)((Object)cscope) + ", downgrade" + downgrade));
        }
        SessionDAO.ExecuteOptions executeOptions = this.createExecuteOptions(null, downgrade, null);
        LBPreparedStatementBuilder psBuilder = new LBPreparedStatementBuilder(LoadBalancerPreparedStatementType.SET_RESOLVED_ADDRESS, this.ksBuilder, addr, loadBalancerId, key);
        if (isFinest) {
            startTime = System.currentTimeMillis();
        }
        ResultSet rs = this.sessionDAO.executeStatement(psBuilder, executeOptions, this.ksBuilder);
        if (isFinest) {
            long endTime = System.currentTimeMillis();
            log.finest((Object)("setResolvedAddress: loadBalancerDAO.setResolvedAddress took " + (endTime - startTime)));
        }
        if (rs.wasApplied()) {
            if (isFiner) {
                log.finer((Object)("setResolvedAddress: Leave: with resolved_address=" + addr));
            }
            resolvedAddress = addr;
            return resolvedAddress;
        }
        return resolvedAddress;
    }

    public String compareAndSetResolvedLocation(long loadBalancerId, String key, String expect, String update, LoadBalancerAPI.ConsistencyScope cscope, boolean downgrade) throws DMException {
        String fcn_name = "compareAndSetResolvedAddress";
        boolean isFiner = log.isFinerEnabled();
        boolean isFinest = log.isFinestEnabled();
        long startTime = 0L;
        if (isFiner) {
            log.finer((Object)("compareAndSetResolvedAddress: enter with loadbalancerId=" + loadBalancerId + ", key=" + key + ",update=" + update + "expect" + expect + ",cScope=" + (Object)((Object)cscope)));
        }
        LBPreparedStatementBuilder psBuilder = new LBPreparedStatementBuilder(LoadBalancerPreparedStatementType.CONDITIONAL_SET_RESOLVED_ADDRESS, this.ksBuilder, update, loadBalancerId, key, expect);
        if (isFinest) {
            startTime = System.currentTimeMillis();
        }
        LoadBalancerAPI.ConsistencyScope curScope = cscope;
        LoadBalancerAPI.ConsistencyScope retryScope = cscope == LoadBalancerAPI.ConsistencyScope.CLUSTER_LEVEL ? LoadBalancerAPI.ConsistencyScope.DATACENTER_LEVEL : LoadBalancerAPI.ConsistencyScope.CLUSTER_LEVEL;
        String returnedAddress = null;
        while (true) {
            long endTime;
            try {
                SessionDAO.ExecuteOptions executeOptions = this.createExecuteOptions(curScope, downgrade, readTimeoutMillis);
                ResultSet rs = this.sessionDAO.executeStatement(psBuilder, executeOptions, this.ksBuilder);
                if (rs.wasApplied()) {
                    if (isFiner) {
                        log.finer((Object)("compareAndSetResolvedAddress: Leave: with addr=" + update));
                    }
                    if (isFinest) {
                        endTime = System.currentTimeMillis();
                        log.finest((Object)("compareAndSetResolvedAddress: applied, executeStatement took " + (endTime - startTime) + " ms, cscope=" + (Object)((Object)curScope)));
                        startTime = endTime;
                    }
                    returnedAddress = update;
                    break;
                }
                if (isFinest) {
                    endTime = System.currentTimeMillis();
                    log.finest((Object)("compareAndSetResolvedAddress: NOT applied, executeStatement took " + (endTime - startTime) + " ms, cscope=" + (Object)((Object)curScope)));
                    startTime = endTime;
                }
                returnedAddress = this.queryResolvedAddress(loadBalancerId, key);
            }
            catch (DMException dme) {
                Throwable thr;
                if (isFinest) {
                    endTime = System.currentTimeMillis();
                    log.finest((Object)("compareAndSetResolvedAddress: DME exception caught, loadBalancerDAO.compareAndSetResolvedAddress took " + (endTime - startTime) + "ms, curScope=" + (Object)((Object)curScope)), (Throwable)dme);
                    startTime = endTime;
                }
                if ((thr = dme.getNestedException()) != null && SessionDAO.isInsufficientReplicas(dme) && curScope != retryScope) {
                    curScope = retryScope;
                    continue;
                }
                throw dme;
            }
            break;
        }
        if (isFiner) {
            log.finer((Object)("compareAndSetResolvedAddress: leave, returning " + returnedAddress));
        }
        return returnedAddress;
    }

    private SessionDAO.ExecuteOptions createExecuteOptions(LoadBalancerAPI.ConsistencyScope cscope, Boolean downgrade, Integer readTimeoutMS) {
        ConsistencyLevel cl = null;
        ConsistencyLevel serialCL = null;
        SessionDAO.ExecuteOptions execOpts = new SessionDAO.ExecuteOptions();
        if (cscope != null) {
            switch (cscope) {
                case CLUSTER_LEVEL: {
                    cl = ConsistencyLevel.QUORUM;
                    serialCL = ConsistencyLevel.SERIAL;
                    break;
                }
                case DATACENTER_LEVEL: {
                    cl = ConsistencyLevel.LOCAL_QUORUM;
                    serialCL = ConsistencyLevel.LOCAL_SERIAL;
                }
            }
        }
        if (cl != null) {
            execOpts.setConsistencyLevel(cl);
        }
        if (serialCL != null) {
            execOpts.setSerialConsistencyLevel(serialCL);
        }
        if (downgrade != null) {
            execOpts.setDowngradingConsistencyRetry(downgrade);
        }
        if (readTimeoutMS != null) {
            execOpts.setReadTimeOutMillis(readTimeoutMS);
        }
        return execOpts;
    }

    public void getKeys(long loadBalancerId, String addr, Collection<String> keys) throws DMException {
        String fcn_name = "getKeys";
        boolean isFiner = log.isFinerEnabled();
        boolean isFinest = log.isFinestEnabled();
        long startTime = 0L;
        LBPreparedStatementBuilder psBuilder = new LBPreparedStatementBuilder(LoadBalancerPreparedStatementType.GET_KEYS, this.ksBuilder, addr, loadBalancerId, 40000);
        if (isFiner) {
            log.finer((Object)"getKeys: enter");
        }
        if (isFinest) {
            startTime = System.currentTimeMillis();
        }
        ResultSet rs = this.sessionDAO.executeStatement((UserStoreStatementBuilder)psBuilder, this.ksBuilder);
        while (!rs.isExhausted()) {
            long loadbalancerId = 0L;
            String key = null;
            for (Row row : rs) {
                loadbalancerId = row.getLong("loadbalancer_id");
                key = row.getString("key");
                keys.add(key);
            }
            rs = this.sessionDAO.executeStatement((UserStoreStatementBuilder)new LBPreparedStatementBuilder(LoadBalancerPreparedStatementType.GET_KEYS_START_TOKEN, this.ksBuilder, addr, loadBalancerId, loadbalancerId, key, 40000), this.ksBuilder);
        }
        if (isFinest) {
            long endTime = System.currentTimeMillis();
            log.finest((Object)("getKeys: loadBalancerDAO.getKeys took " + (endTime - startTime)));
        }
        if (isFiner) {
            log.finer((Object)("getKeys: Leave: with Keys of size=" + keys.size()));
        }
    }

    public void deleteKeys(final long loadBalancerId, Collection<String> keys) throws DMException {
        String fcn_name = "deleteKeys";
        boolean isFiner = log.isFinerEnabled();
        boolean isFinest = log.isFinestEnabled();
        long startTime = 0L;
        if (isFiner) {
            log.finer((Object)("deleteKeys: enter, loadBalancerId=" + loadBalancerId + ", keys.size()=" + keys.size()));
        }
        List<List<String>> splitKeysByLimit = LoadBalancerDAO1.splitKeysByLimit(keys);
        if (isFinest) {
            startTime = System.currentTimeMillis();
        }
        for (final List<String> keysList : splitKeysByLimit) {
            UserStoreStatementBuilder stmt = new UserStoreStatementBuilder(){

                @Override
                public Statement getStatement() throws DMException {
                    LBPreparedStatementBuilder psBuilder = new LBPreparedStatementBuilder(LoadBalancerPreparedStatementType.DELETE_RESOLVED_ADDRESSES, LoadBalancerDAO1.this.ksBuilder, loadBalancerId, keysList);
                    return psBuilder.getStatement();
                }

                @Override
                public void newSession() {
                }
            };
            this.sessionDAO.executeStatement(stmt, this.ksBuilder);
        }
        if (isFinest) {
            long endTime = System.currentTimeMillis();
            log.finest((Object)("deleteKeys: loadBalancerDAO.deleteKeys took " + (endTime - startTime)));
        }
        if (isFiner) {
            log.finer((Object)"deleteKeys: Leave");
        }
    }

    public void resolvedAddressByLoadbalancerId(long loadBalancerId, Map<String, String> resolvedAddressByloadbalancerId) throws DMException {
        String fcn_name = "resolvedAddressByLoadbalancerId";
        boolean isFiner = log.isFinerEnabled();
        boolean isFinest = log.isFinestEnabled();
        long startTime = 0L;
        LBPreparedStatementBuilder psBuilder = new LBPreparedStatementBuilder(LoadBalancerPreparedStatementType.RESOLVED_ADDRESS_BY_LOADBALANCERID, this.ksBuilder, loadBalancerId, 40000);
        if (isFiner) {
            log.finer((Object)("resolvedAddressByLoadbalancerId: enter with loadbalancerId=" + loadBalancerId));
        }
        if (isFinest) {
            startTime = System.currentTimeMillis();
        }
        ResultSet rs = this.sessionDAO.executeStatement((UserStoreStatementBuilder)psBuilder, this.ksBuilder);
        while (!rs.isExhausted()) {
            long loadbalancerId = 0L;
            String key = null;
            for (Row row : rs) {
                loadbalancerId = row.getLong("loadbalancer_id");
                key = row.getString("key");
                resolvedAddressByloadbalancerId.put(key, row.getString("resolved_address"));
            }
            rs = this.sessionDAO.executeStatement((UserStoreStatementBuilder)new LBPreparedStatementBuilder(LoadBalancerPreparedStatementType.BULK_RESOLVED_ADDRESS_BY_LOADBALANCERID, this.ksBuilder, loadBalancerId, loadbalancerId, key, 40000), this.ksBuilder);
        }
        if (isFinest) {
            long endTime = System.currentTimeMillis();
            log.finest((Object)("resolvedAddressByLoadbalancerId: loadBalancerDAO.getAllResolvedAddress took " + (endTime - startTime)));
        }
        if (isFiner) {
            log.finer((Object)("resolvedAddressByLoadbalancerId: Leave with loadBalancerData of size=" + resolvedAddressByloadbalancerId.size()));
        }
    }

    public int getDefaultTimeToLive(String keyspace, String columnfamilyname) throws DMException {
        ColumnFamilyMetaData columnFamily;
        String fcn_name = "getColumnFamily";
        boolean isFiner = log.isFinerEnabled();
        boolean isFinest = log.isFinestEnabled();
        long startTime = 0L;
        if (isFiner) {
            log.finer((Object)("getColumnFamily: enter with keyspace=" + keyspace + " and columnFamilyName=" + columnfamilyname));
        }
        if (isFinest) {
            startTime = System.currentTimeMillis();
        }
        if ((columnFamily = this.sessionDAO.getColumnFamily(keyspace, columnfamilyname)) == null) {
            throw new DMException("ColumnFamilyMetaData is Null with columnFamilyName=" + columnfamilyname + " and keyspace=" + keyspace);
        }
        int defaultTimeToLive = columnFamily.getDefaultTimeToLive();
        if (isFinest) {
            long endTime = System.currentTimeMillis();
            log.finest((Object)("getColumnFamily: loadBalancerDAO.getColumnFamily took " + (endTime - startTime)));
        }
        if (isFiner) {
            log.finer((Object)("getColumnFamily: Leave with defaultTimeToLive =" + defaultTimeToLive));
        }
        return defaultTimeToLive;
    }

    public void deleteResolvedAddresses(long loadBalancerId, Collection<String> keys) throws DMException {
        String fcn_name = "deleteResolvedAddresses";
        boolean isFiner = log.isFinerEnabled();
        boolean isFinest = log.isFinestEnabled();
        long startTime = 0L;
        if (isFiner) {
            log.finer((Object)("deleteResolvedAddresses: enter with loadBalancerId=" + loadBalancerId + ", keys.size=" + keys.size()));
        }
        LBPreparedStatementBuilder psBuilder = new LBPreparedStatementBuilder(LoadBalancerPreparedStatementType.DELETE_RESOLVED_ADDRESSES, this.ksBuilder, loadBalancerId, keys);
        if (isFinest) {
            startTime = System.currentTimeMillis();
        }
        this.sessionDAO.executeStatement(psBuilder);
        if (isFinest) {
            long endTime = System.currentTimeMillis();
            log.finest((Object)("deleteResolvedAddresses: loadBalancerDAO.deleteResolvedAddress took " + (endTime - startTime) + " ms"));
        }
        if (isFiner) {
            log.finer((Object)"deleteResolvedAddresses: leave");
        }
    }

    public void getAllRecordsByLocalTokenRanges(List<InetAddress> downNodes, Collection<LoadBalancerData> lbDataRecs, LoadBalancerAPI.DataFilter filter) throws DMException {
        String fcn_name = "getAllRecordsByLocalTokenRanges";
        boolean isFiner = log.isFinerEnabled();
        boolean isFinest = log.isFinestEnabled();
        long startTime = 0L;
        if (isFiner) {
            log.finer((Object)("getAllRecordsByLocalTokenRanges: enter with downNodes=" + downNodes));
        }
        if (lbDataRecs == null) {
            String msg = "lbDataRecs cannot be null";
            log.error((Object)("getAllRecordsByLocalTokenRanges: " + msg + ", downNodes=" + downNodes));
            throw new IllegalArgumentException(msg);
        }
        if (isFinest) {
            startTime = System.currentTimeMillis();
        }
        TokenRangeIterator tokenRangeIterator = null;
        try {
            tokenRangeIterator = this.newTokenRangeIterator(downNodes);
        }
        catch (UnknownHostException e) {
            if (isFinest) {
                log.finest((Object)("getAllRecordsByLocalTokenRanges: newTokenRangeIterator threw " + e.getLocalizedMessage()));
            }
            DMException dme = new DMException(e);
            if (isFiner) {
                log.finer((Object)("getAllRecordsByLocalTokenRanges: leave, throwing " + dme.getClass().getSimpleName()));
            }
            throw new DMException(e);
        }
        catch (DMException e) {
            if (isFinest) {
                log.finest((Object)("getAllRecordsByLocalTokenRanges: newTokenRangeIterator threw " + e.getLocalizedMessage()));
            }
            if (isFiner) {
                log.finer((Object)("getAllRecordsByLocalTokenRanges: leave, throwing " + e.getClass().getSimpleName()));
            }
            throw e;
        }
        TokenRange next = null;
        if (tokenRangeIterator != null) {
            next = tokenRangeIterator.getNext();
        }
        while (next != null) {
            this.getDataFromTokenRange(next, lbDataRecs, filter);
            next = tokenRangeIterator.getNext();
        }
        if (isFinest) {
            long endTime = System.currentTimeMillis();
            log.finest((Object)("getAllRecordsByLocalTokenRanges: loadBalancerDAO.getAllRecordsByLocalTokenRanges took " + (endTime - startTime)));
        }
        if (isFiner) {
            log.finer((Object)("getAllRecordsByLocalTokenRanges: leave, lbDataRecs.size=" + lbDataRecs.size()));
        }
    }

    private void getDataFromTokenRange(TokenRange tokenRange, Collection<LoadBalancerData> lbDataRecs, LoadBalancerAPI.DataFilter filter) throws DMException {
        String fcn_name = "getDataFromTokenRange";
        boolean isFiner = log.isFinerEnabled();
        boolean isFinest = log.isFinestEnabled();
        long startTime = 0L;
        if (isFiner) {
            log.finer((Object)("getDataFromTokenRange: enter, tokenRange=" + tokenRange + ", lbDataRecs.size=" + lbDataRecs.size()));
        }
        Token start = null;
        Token end = null;
        if (tokenRange != null) {
            start = tokenRange.getStart();
            end = tokenRange.getEnd();
        }
        LoadBalancerData lastLbData = null;
        Object[] columns = new Object[3];
        while (true) {
            boolean skipPastLastLbData;
            LBPreparedStatementBuilder builder = this.getStatementBuilder(start, end, lastLbData);
            if (isFinest) {
                startTime = System.currentTimeMillis();
            }
            ResultSet rs = this.sessionDAO.executeStatement(builder);
            Iterator it = rs.iterator();
            int numRows = 0;
            long lbId = -1L;
            String key = null;
            String addr = null;
            boolean bl = skipPastLastLbData = lastLbData != null;
            while (it.hasNext()) {
                Row row = (Row)it.next();
                ++numRows;
                if (!this.getRowColumns(row, columns)) {
                    log.warn((Object)("getDataFromTokenRange: Couldn't convert row=" + row));
                    break;
                }
                lbId = (Long)columns[0];
                key = (String)columns[1];
                addr = (String)columns[2];
                if (skipPastLastLbData) {
                    boolean found = true;
                    if (lbId != lastLbData.getLoadbalancerId()) {
                        found = false;
                    } else if (key != null) {
                        if (!key.equals(lastLbData.getKey())) {
                            found = false;
                        }
                    } else if (lastLbData.getKey() != null) {
                        found = false;
                    }
                    if (!found) continue;
                    skipPastLastLbData = false;
                    continue;
                }
                if (filter == null || filter.apply(lbId, key, addr)) {
                    LoadBalancerData lbData = new LoadBalancerData(lbId, key, addr);
                    lbDataRecs.add(lbData);
                    if (!isFinest) continue;
                    log.finest((Object)("getDataFromTokenRange: added lbData=" + lbData));
                    continue;
                }
                if (!isFinest) continue;
                log.finest((Object)("getDataFromTokenRange: not adding lbId=" + lbId + ", key=" + key + ", addr=" + addr));
            }
            if (numRows < 40000) break;
            lastLbData = new LoadBalancerData(lbId, key, addr);
        }
        if (isFinest) {
            long endTime = System.currentTimeMillis();
            log.finest((Object)("getDataFromTokenRange: getDataFromTokenRange took " + (endTime - startTime)));
        }
        if (isFiner) {
            log.finer((Object)("getDataFromTokenRange: enter, lbDataRecs.size=" + lbDataRecs.size()));
        }
    }

    private boolean getRowColumns(Row row, Object[] columns) {
        String fcn_name = "getRowColumns";
        if (row.isNull(0)) {
            log.warn((Object)("getRowColumns: row has null loadbalancer_id, row=" + row));
            return false;
        }
        if (row.isNull(1)) {
            log.warn((Object)("getRowColumns: row has null key, row=" + row));
            return false;
        }
        long lbId = row.getLong(0);
        String key = row.getString(1);
        String address = null;
        if (!row.isNull(2)) {
            address = row.getString(2);
        }
        columns[0] = lbId;
        columns[1] = key;
        columns[2] = address;
        return true;
    }

    private LBPreparedStatementBuilder getStatementBuilder(Token start, Token end, LoadBalancerData lastLbData) {
        String fcn_name = "getStatementBuilder";
        boolean isFiner = log.isFinerEnabled();
        if (isFiner) {
            log.finer((Object)("getStatementBuilder: enter, start=" + start + ", end=" + end + ", lastLbData=" + lastLbData));
        }
        LBPreparedStatementBuilder builder = null;
        LoadBalancerPreparedStatementType type = null;
        if (start == null) {
            if (end == null) {
                type = LoadBalancerPreparedStatementType.GET_All_RESOLVED_ADDRESS;
                if (lastLbData == null) {
                    type = LoadBalancerPreparedStatementType.GET_All_RESOLVED_ADDRESS;
                    builder = new LBPreparedStatementBuilder(type, this.ksBuilder, 40000);
                } else {
                    type = LoadBalancerPreparedStatementType.GET_ALL_START_KEY_UNBOUNDED;
                    builder = new LBPreparedStatementBuilder(type, this.ksBuilder, lastLbData.getLoadbalancerId(), lastLbData.getKey(), 40000);
                }
            } else if (lastLbData == null) {
                type = LoadBalancerPreparedStatementType.GET_ALL_BOUNDED;
                builder = new LBPreparedStatementBuilder(type, this.ksBuilder, end, 40000);
            } else {
                type = LoadBalancerPreparedStatementType.GET_ALL_START_KEY_BOUNDED;
                builder = new LBPreparedStatementBuilder(type, this.ksBuilder, lastLbData.getLoadbalancerId(), lastLbData.getKey(), end, 40000);
            }
        } else if (end == null) {
            if (lastLbData != null) {
                type = LoadBalancerPreparedStatementType.GET_ALL_START_KEY_UNBOUNDED;
                builder = new LBPreparedStatementBuilder(type, this.ksBuilder, lastLbData.getLoadbalancerId(), lastLbData.getKey(), 40000);
            } else {
                type = LoadBalancerPreparedStatementType.GET_ALL_START_TOKEN_UNBOUNDED;
                builder = new LBPreparedStatementBuilder(type, this.ksBuilder, start, 40000);
            }
        } else if (lastLbData != null) {
            type = LoadBalancerPreparedStatementType.GET_ALL_START_KEY_BOUNDED;
            builder = new LBPreparedStatementBuilder(type, this.ksBuilder, lastLbData.getLoadbalancerId(), lastLbData.getKey(), end, 40000);
        } else {
            type = LoadBalancerPreparedStatementType.GET_ALL_START_TOKEN_BOUNDED;
            builder = new LBPreparedStatementBuilder(type, this.ksBuilder, start, end, 40000);
        }
        if (isFiner) {
            log.finer((Object)("getStatementBuilder: leave, statementType=" + builder.getType()));
        }
        return builder;
    }

    private TokenRangeIterator newTokenRangeIterator(List<InetAddress> downNodes) throws UnknownHostException, DMException {
        TokenRangeIterator tokenRangeIterator = new TokenRangeIterator(this.sessionDAO, "loadbalancer", downNodes);
        return tokenRangeIterator;
    }

    public class LBPreparedStatementBuilder
    extends PreparedStatementBuilder<LoadBalancerPreparedStatementType> {
        public LBPreparedStatementBuilder(LoadBalancerPreparedStatementType type, UserStoreKeyspaceBuilder builder, Object ... args) {
            super(LoadBalancerDAO1.this.preparedStatements, type, builder, args);
            LoadBalancerDAO1.this.fetchSizeExecOptions.setFetchSize(40000);
        }

        @Override
        public Statement getStatement() throws DMException {
            Statement statement = super.getStatement();
            return statement;
        }
    }
}

